% clear all 
% mex cec13_func.cpp -DWINDOWS
clear;
clc;
format long;
benchmark = 2017;
problemIndex = [1:30];
fun_nums=30;
D=30;
Xmin=-100;
Xmax=100;
FES=10000*D;
runTime=51;
FW = 1;
PR = 0.8;
tic
algorithmDir_basic = 'basic';
algorithmDir = 'HMRFO';


%% For CEC2011
if benchmark ~= 2011
    pathOfBoxPlot = ['./',algorithmDir,'_CEC',num2str(benchmark),'_D',num2str(D),'_Mean&Std_and_Box-Plot.xls'];
    pathOfConvergence = ['./',algorithmDir,'_CEC',num2str(benchmark),'_D',num2str(D),'_Convergence.xls'];
else
    %% init table for CEC2011
    pathOfBoxPlot = ['./',algorithmDir,'_CEC',num2str(benchmark),'_Mean&Std_and_Box-Plot.xls'];
    pathOfConvergence = ['./',algorithmDir,'_CEC',num2str(benchmark),'_Convergence.xls'];
end
%% init table
tableOfBoxPlot = initTableforBoxPlot(length(problemIndex),runTime);
tableOfConvergence = initTableforConvergence(length(problemIndex));

val_2_reach = 10^(-8);

rgo = [100;200;300;400;500;600;700;800;900;1000;1100;1200;1300;1400;1500;1600;1700;1800;1900;2000;2100;2200;2300;2400;2500;2600;2700;2800;2900;3000];
fhd=str2func('cec17_func');
% fname = ['CSDE_',num2str(D),'D.txt'];
% f_out = fopen(fname,'wt');
% fMedian = ['CSDE_',num2str(D),'D_locMedian.txt'];
% f_loc = fopen(fMedian,'wt');
%ftime = ['CSDE_',num2str(D),'D.txt'];
%f_tout = fopen(ftime,'a');

for i= problemIndex
    func=i;
    disp(['func',num2str(func)]);
%     disp(['fid:',num2str(fun_num)]);
%     fprintf(f_out,'fid:%d\n',fun_num);
%     fprintf(f_loc,'fid:%d\n',fun_num);
    resultChart = [];
    t = 1;
    f = func;
    fnum = f;
    optimum = func * 100.0;
    for j=1:runTime 
        [optimalChart]= HMRFO_func(fhd,D,FES,Xmin,Xmax,func,FW,PR);
        
        resultChart = [resultChart,optimalChart];
        
        run = j;
        disp(['run',num2str(run)]);
    end
    boxPlotChart = resultChart(end,:);
    convergenceChart = mean(resultChart,2);
    if benchmark ~= 2011
        path = ['./',algorithmDir_basic,'_',algorithmDir,'_CEC',num2str(benchmark),'_D',num2str(D),'.xlsx'];
    else
        path = ['./',algorithmDir_basic,'_',algorithmDir,'_CEC',num2str(benchmark),'.xlsx'];
    end
    sheetName = ['CEC_' num2str(benchmark) '_F'];
    xlswrite(path,resultChart,[sheetName,num2str(f),'_D',num2str(D)]);
    
    %% save result
    tableOfBoxPlot = updateTableforBoxPlot(tableOfBoxPlot,boxPlotChart,pathOfBoxPlot,rgo,f);
    tableOfConvergence = updateTableforConvergence(tableOfConvergence,convergenceChart,pathOfConvergence,rgo,f);
    

end
toc

function tableB = initTableforBoxPlot(problemNum, runNum)
row = 3 + problemNum;
col = 1 + runNum;
tableB = cell(row, col);
tableB{1,2} = 'mean';
tableB{1,3} = 'std';
for i = 1:problemNum
    tableB{i+1,1} = ['F' num2str(i)];
end
end

function tableC = initTableforConvergence(problemNum)
col = problemNum;
tableC = cell(1,col);
for i = 1:col
    tableC{1,i} = ['F' num2str(i)];
end
end

function tableB = updateTableforBoxPlot(tableB,data,path,rgo,problemIndex)
[row,col] = size(data);
% rgo = repmat(rgo(problemIndex),1,col);
rgo = repmat(rgo,1,col);
% data = data - rgo;
dataMean = mean(data,2);
dataStd = std(data,0,2);
Dcol = ones(1,col);
Drow = ones(1,row);
dataMean = mat2cell(dataMean,Drow,[1]);
dataStd = mat2cell(dataStd,Drow,[1]);
tableB(problemIndex+1,2) = dataMean;
tableB(problemIndex+1,3) = dataStd;
dataCol = mat2cell(data,[1],Dcol);
tableB(problemIndex+1,4:3+col) = dataCol;
xlswrite(path,tableB);
end

function tableC = updateTableforConvergence(tableC,data,path,rgo,problemIndex)
[row,col] = size(data);
% rgo = repmat(rgo(problemIndex)',row,1);
rgo = repmat(rgo',1,col);
% data = data - rgo;
Drow = ones(1,row);
dataCol = mat2cell(data,Drow,[1]);
tableC(2:row+1,problemIndex) = dataCol;
xlswrite(path,tableC);
end

function showTraj(problemIndex, nFES, popu, pBest, optimal, imgPath)
popuSize = size(popu,1);
func_plot(problemIndex);
h = plot(popu(:,1),popu(:,2),'.r','MarkerSize',15);
% r = sectionStep;
% for i = 1:popuSize
% x = popu(i,1);
% y = popu(i,2);
% rectangle('Position',[x-r,y-r,2*r,2*r],'Curvature',[1,1],'linewidth',1),axis equal
hold on
% plot(optimal(1,1),optimal(1,2),'-rp','MarkerSize',20);
% plot(pBest(:,1),pBest(:,2),'.b','MarkerSize',15);
if mod(nFES / popuSize, 1) == 0
    saveas(gcf,[[imgPath '/'],num2str(nFES / popuSize) '.png']);
    saveas(gcf,[[imgPath '/'],num2str(nFES / popuSize) '.eps'], 'epsc');
end
hold off
end