% Clear the MATLAB environment and turn off all warnings for a clean run
clear all;
warning('off', 'all');

% Define the save path for the results and create the directory if it does not exist
save_path = './result_v2/';
if ~exist(save_path, 'dir')
    mkdir(save_path);
end

% Set the problem parameters
problem_id = 1;
dataset_name = {'Zoo'}; % Use a more descriptive variable name for clarity
Datasets = load('Dataset_FS.mat'); % Load dataset file
Data = Datasets.(dataset_name{1}); % Access the specified dataset

% Determine the feature set size 'n' based on the dataset dimensionality
[~, total_features] = size(Data);
feature_count = total_features - 1; % Exclude the label column
max_features = 200;
min_features = 100;
% Ensure 'n' is within the specified range [min_features, max_features]
n = min(max(feature_count, min_features), max_features);
% Define the number of function evaluations
FES = n * 100;

% Define the runtime iterations
runtime_iterations = 1:30;

% Main loop to run the algorithm for each runtime iteration
for run_number = runtime_iterations
    platemo('problem', {@FS, dataset_name, problem_id, run_number}, ...
            'algorithm', {@IGEA, save_path}, ...
            'N', n, 'maxFE', FES);
end

% Close all open figures
close all;

% Perform the post-processing of results
mHV_cal_for_csv;

SO_PEER;
