function redundancy = calculate_redundancy(X, y)
    num_features = size(X, 2);
    redundancy = zeros(1, num_features);
    
    for i = 1:num_features
        feature_values = unique(X(:, i));  % 特征 i 的取值
        num_values = length(feature_values);
        entropy_feature = calculate_entropy(X(:, i));  % 特征 i 的熵
        
        for j = 1:num_values
            value = feature_values(j);
            subset_indices = X(:, i) == value;  % 特征 i 取值为 value 的样本索引
            subset_labels = y(subset_indices);  % 特征 i 取值为 value 的样本标签
            subset_entropy = calculate_entropy(subset_labels);  % 计算子集的熵
            
            subset_prob = sum(subset_indices) / length(X(:, i));  % 计算特征 i 取值为 value 的概率
            redundancy(i) = redundancy(i) + subset_prob * subset_entropy;  % 累加特征的熵冗余度
        end
        
        % 计算特征的信息熵冗余度
        redundancy(i) = (entropy_feature - redundancy(i)) / entropy_feature;
    end
end

function entropy = calculate_entropy(labels)
    class_counts = tabulate(labels);  % 统计各类别的频数
    class_probabilities = class_counts(:, 3) / 100;  % 计算各类别的概率
    entropy = -sum(class_probabilities .* log2(class_probabilities));  % 计算熵
end
