clc
clear all
Algorithm = 'ISPSO';
str = {'Australian','German','Ionosphere','Dermatology','KrVsKpEW'...
    'Waveform','Spambase','sonar','Hillvalley','MUSK1','Semeion_handwritten_digit','Arrhythmia','Madelon',...
    'Isolet5','Yale32','ORL32','Zoo'};
CallStack = dbstack('-completenames');
load(fullfile(fileparts(CallStack(1).file),'Dataset_FS.mat'),'Dataset');
for problem_id = [5:5]
    All = 30;
    runtime = [1:All];
    Data = Dataset.(str{problem_id});
    TrainIn = Data(1:ceil(end*0.7),1:end-1);
    TrainOut = Data(1:ceil(end*0.7),end);
    ValidIn = Data(ceil(end*0.7) + 1:end,1:end-1);
    ValidOut = Data(ceil(end*0.7)+1:end,end);
    Train_data = [TrainIn,TrainOut];
    Valid_data = [ValidIn,ValidOut];
    [~,D] = size(Data);D = D-1;
    rank = calculate_information_gain_ratio(TrainIn,TrainOut);
    alter_features = mapminmax(rank,0,1);
    p = [];
    [F1,F2,F3] = F_divide(alter_features);
    current = 0;
%     Best = [];
    parfor number = runtime
        T = 100;
        t = 0;
        N = 30;
        Maxeval = N * 100;
        eval = 0;
        ub = 1;
        lb = 0;
        Pop = initialization(N,D,ub,lb,alter_features,F1,F2,F3);
        Pop1 = init(N,D,ub,lb,alter_features,F1,F2,F3);
        Pop =Pop > 0.5;
        Pbest = Pop;
%         fit = Evaluation(Pop1,N,D,Train_data);
%         disp(min(fit));
        fitness = Evaluation(Pop,N,D,Train_data);
%         disp(min(fitness));
        eval = eval + N;
        p_fitness = fitness;
        [pBest,pBest_index] = min(fitness);
        pBest_individual = Pop(pBest_index,:);
        gBest = pBest;
        gBest_individual = pBest_individual;
        V = rand(N,D);
        thresold1 = ones(1,D) * 10;
        best = [gBest];
        while eval < Maxeval
            [Pop,fitness,p_fitness,V,Pbest,thresold1] = MBPSO(Pop,fitness,p_fitness,Pbest,pBest_individual,eval,Maxeval,N,D,V,Train_data,alter_features,thresold1);
            eval = eval + N;
            [pBest,pBest_index]=min(fitness);
            pBest_individual = Pop(pBest_index,:);
            if(gBest>pBest)
                gBest = pBest;
                gBest_individual = pBest_individual;
            end
%             if(mod(eval,30) == 0)
%                 disp(size(find(thresold1 <=0)));
%                 disp(max(thresold1));
%             end
%             best = [best,gBest];
            fprintf('algorithm-%s problem-%s runtime-%s |%5.0f -----> %9.16f\n', Algorithm, str{problem_id},num2str(number),eval,gBest);
        end
%         Best = [Best;best]; 
%         total = [total,gBest];
        %% solve the result as .csv
%         final=all_optimal_individuals;        
        final = gBest_individual > 0.5;
        pb = [];
        s=[];
        s=logical(final);
        while sum(s) == 0
            s= logical(round(rand(1 , size(s,2))));
        end
        mdltest = fitcknn(TrainIn(:,s),TrainOut,'NumNeighbors',5);
        c = predict(mdltest,ValidIn(:,s));
        confMat = confusionmat(ValidOut, c);
        [~,label] = size(confMat);
        % disp(label);
        precision = 0;
        recall = 0;
        for i = 1 : label
        precision = precision + confMat(i,i) / sum(confMat(:,i));
        recall = recall + confMat(i,i) / sum(confMat(i,:));
        end
        precision = precision / label;
        recall = recall / label;
        loss = 1-length(find(c==ValidOut))/length(c);
        pb = [pb,gBest,loss,precision,recall,final];
        p = [p;pb];
    end
    p1 = mean(p(:,1:4));
    dir_name = class(Algorithm);
    save_path = './ISPSO-result/';
    if ~exist(save_path,'dir')
        mkdir(save_path)
    end
    csv_name=strcat(Algorithm,'-',str{problem_id},'.xlsx');
    % write p to first sheet
    sheet_name = 'Sheet1';
    writematrix(p,fullfile(save_path,csv_name),'Sheet',sheet_name);
    
    % write p1 to second sheet
    sheet_name = 'Sheet2';
    writematrix(p1,fullfile(save_path,csv_name),'Sheet',sheet_name);

end