import torch
import pandas as pd
import numpy as np
from torch import nn, optim
from torch.utils.data import DataLoader
from sklearn.metrics import mean_squared_error, r2_score, mean_absolute_error
from numpy import concatenate
from pandas import read_csv
from sklearn.preprocessing import MinMaxScaler
from math import sqrt
import numpy as np
from matplotlib import pyplot as plt
from experiment_content.typical_models import LSTM_model
import time
from experiment_content.power_dataset import Power_ds
import os


# calculate MAPE
def mean_absolute_percentage_error(real, predict):
    res = 0
    count = 0
    for i in range(len(real)):
        if real[i] != 0:
            res += abs((predict[i] - real[i]) / real[i])
            count += 1
    if count == 0:
        return 0  # Avoid division by zero
    return float(res / count)

def plot_predict(pre, test_labels):
    plt.plot(test_labels, label='real')
    plt.plot(pre, label='predict')
    plt.title('real-predict')
    plt.xlabel('hour')
    plt.ylabel('power')
    plt.legend()  # 显示图例，与label搭配使用
    plt.show()


task = 'persistence'

tar_domain = 'tetouan_region1_power'

n_hours = 5
n_features = 4


running_day = 7
testing_day = 30

dataset = read_csv(
    os.path.join('D:\\小论文\\小论文2\\experiment_content\\dealt_data', 'tetouan_region1_power' + '.csv'),
    header=0, index_col=0)

sample_num = running_day*24 + testing_day*24 + n_hours + 1

values = dataset.values[-sample_num:, 0]
values = values.astype('float32')

train_power = values[:running_day*24]
test_power = values[-testing_day*24:]
# print(test_power[-1])

#求train_power的平均值
train_power_mean = np.mean(train_power)
print(train_power_mean)

#生成一个与test_power长度相等的ndarray
prediction = np.full_like(test_power, train_power_mean)

# calculate RMSE
rmse = sqrt(mean_squared_error(test_power, prediction))
print('Test RMSE: %.3f' % rmse)

# calculate MAPE
mape = mean_absolute_percentage_error(test_power, prediction)
print('Test mape: %.3f' % mape)


# calculate MAE
mae = mean_absolute_error(test_power, prediction)
print('Test MAE: %.3f' % mae)

# calculate R^2
R2 = r2_score(test_power, prediction)
print(f"R-squared (R^2): {R2:.3f}")

# plot_predict(prediction, test_power)


# 拟合曲线记录
csv_file1 = 'D:\\小论文\\小论文2\\results_record\\多源域与单源域对比\\panama_2_region1\\pre_values_compare.csv'
test_labels = test_power.reshape(-1)
# 将test_labels写入csv文件中
df = pd.Series(test_labels, name='Real')
df.to_csv(csv_file1, index=False)

best_predict = prediction.reshape(-1)
df = pd.read_csv(csv_file1)
df['Mean'] = best_predict
df.to_csv(csv_file1, index=False)