import pandas as pd
import numpy as np
from sklearn.preprocessing import MinMaxScaler
from matplotlib import pyplot as plt
import seaborn as sns
from sklearn.feature_selection import mutual_info_regression

#计算文件时间序列中24小时的分别均值与方差
def calculate_mean_and_var(file_path):
    # 读取CSV文件
    df = pd.read_csv(file_path)
    #取df第二列
    df = df.iloc[:, 1]
    # 将数据转换为NumPy数组
    power = df.values
    power = power.astype('float32')
    power = power.reshape(-1, 1)
    # print(power[0::24][-2:])

    # normalize features
    scaler = MinMaxScaler(feature_range=(0, 1)).fit(power)
    scaled = scaler.fit_transform(power)
    # 分别计算24个时间点的均值与方差
    means_list = []
    var_list = []
    for i in range(24):
        means = np.mean(scaled[i::24])
        var = np.var(scaled[i::24])
        means_list.append(means)
        var_list.append(var)
    #把列表中的np数字转换成浮点类型
    means_list = [float(x) for x in means_list]
    var_list = [float(x) for x in var_list]

    return means_list, var_list



if __name__ == '__main__':
    #设置全局字体为Times New Roman
    plt.rcParams['font.family'] = 'Times New Roman'


    file_path1 = 'D:\\小论文\\小论文2\\experiment_content\\dealt_data\\panama_power.csv'
    file_path2 = 'D:\\小论文\\小论文2\\experiment_content\\dealt_data\\tetouan_region1_power.csv'
    file_path3 = 'D:\\小论文\\小论文2\\experiment_content\\dealt_data\\tetouan_region2_power.csv'
    file_path4 = 'D:\\小论文\\小论文2\\experiment_content\\dealt_data\\tetouan_region3_power.csv'

    means_list1, var_list1 = calculate_mean_and_var(file_path1)  #巴拿马数据从1.00开始，所以需要把最后一个元素放到第一个位置
    means_list1 = [means_list1[-1]] + means_list1[:-1]
    var_list1 = [var_list1[-1]] + var_list1[:-1]

    means_list2, var_list2 = calculate_mean_and_var(file_path2)
    means_list3, var_list3 = calculate_mean_and_var(file_path3)
    means_list4, var_list4 = calculate_mean_and_var(file_path4)


    # 示例数据
    x = range(24)

    # 创建图形和第一个纵轴
    fig, ax1 = plt.subplots()

    # 绘制第一个数据系列
    ax1.plot(x, means_list1, 'b-', label='panama', linewidth=1.5)  #使用实线
    ax1.plot(x, means_list2, 'g-', label='region1', linewidth=1.5)
    ax1.plot(x, means_list3, 'r-', label='region2', linewidth=1.5)
    ax1.plot(x, means_list4, 'y-', label='region3', linewidth=1.5)
    ax1.set_xlabel('Hour(h)', fontsize=12)
    ax1.set_ylabel('Mean  of  Energy', color='k', fontsize=12)
    ax1.set_ylim(0, 1)
    ax1.tick_params(axis='y', labelcolor='k')
    #x轴刻度的24个点全部显示
    ax1.set_xticks(x)


    # 创建第二个纵轴，共享同一横轴
    ax2 = ax1.twinx()

    # 绘制第二个数据系列，使用虚线，并手动限制y轴坐标
    ax2.plot(x, var_list1, 'b--', label='panama', linewidth=1)
    ax2.plot(x, var_list2, 'g--', label='region1', linewidth=1)
    ax2.plot(x, var_list3, 'r--', label='region2', linewidth=1)
    ax2.plot(x, var_list4, 'y--', label='region3', linewidth=1)
    ax2.set_ylim(0, 0.1)
    ax2.set_ylabel('Variance  of  Energy', color='r', fontsize=12)
    ax2.tick_params(axis='y', labelcolor='r')

    # 添加图例，不同轴的图例分开放置，一个在左一个在右
    lines1, labels1 = ax1.get_legend_handles_labels()
    lines2, labels2 = ax2.get_legend_handles_labels()
    legend1 = ax1.legend(loc='upper left', bbox_to_anchor=(0, 1), bbox_transform=ax1.transAxes, fontsize=12)
    legend2 = ax2.legend(loc='upper right', bbox_to_anchor=(1, 1), bbox_transform=ax2.transAxes, fontsize=10)

    for text in legend2.get_texts():
        text.set_color('red')

    #图像X轴左右两边不留空白
    plt.xlim(-0.1, 23.1)

    # 显示图形
    plt.show()
