clc;
clear all;
format long;
format compact;
optimalChart_interval = 100;
for ProblemSize = [100]
    Val2Reach = 10^(-8);
    MaxRegion = 100.0;
    MinRegion = -100.0;
    LU = [-100 * ones(1, ProblemSize); 100 * ones(1, ProblemSize)];
    algorithmDir = 'PAIDDEunopf';Benchmark = 'CEC2017';FHD=@cec17_func;
    NumPrbs = 30;
    Runs = 1;
    FF = zeros(Runs,30);
    PopSize = 200;
    MaxNfes = 10000*ProblemSize;
    PbestRate = 0.1;
    rd = 0.95;
    c = [0.5,0.7];
%     fprintf('Running SS algorithm on D= %d\n', ProblemSize)
%     for Func = 1 : NumPrbs
   
   tic
    for Func = [1,3:30]
        Optimum = Func * 100.0;
        fprintf('\n-------------------------------------------------------\n')
        fprintf('Function = %d, Dimension size = %d\n', Func, ProblemSize);
        resultChart = [];
        for run_id = 1 : Runs
            run_id
            optimalChart = [];
            %         [BciFitVar, BciSolution, BciIndex] = SSunopf(FHD, LU, PopSize, MaxNfes, PbestRate, rd, c, Func);
            [resultChart, optimalChart, BciFitVar, BciSolution, BciIndex,pd] = PAIDDEunopf(optimalChart_interval, Val2Reach, Optimum, resultChart, optimalChart, FHD, LU, [], MaxNfes, [], [], [],[],[], Func);
            resultChart = [resultChart, optimalChart];
            bci_error_val = BciFitVar - Optimum;
            if bci_error_val < Val2Reach
                bci_error_val = 0;
            end
            FF(run_id,Func)= bci_error_val;
%             fprintf('%d th run, best-so-far error vaLUe = %1.8e\n', run_id , bci_error_val);
         D = ProblemSize;
%          if D == 10
%             pd = pd(1:10:end);
%             pd = repelem(pd,5);
%             pd = pd(1:1000);
%          elseif D == 30
%              pd = pd(1:10:end);
%              pd = repelem(pd,11);
%              pd = pd(1:3000);        
%          elseif D == 50
%              pd = pd(1:10:end);
%              pd = repelem(pd,17);
%              pd = pd(1:5000);   
%          elseif D == 100
%              pd = pd(1:5:end);
%              pd = repelem(pd,16);
%              pd = pd(1:10000); 
%          end
%           name_string = ['pdD',num2str(D),'_F',num2str(Func),'=pd'];
%           eval(name_string);
%           save(['pdD',num2str(D),'_F',num2str(Func),'.mat',],['pdD',num2str(D),'_F',num2str(Func)]);
%           name_string = [];
        end
        

        
        savepath = [algorithmDir,'_',Benchmark,'_D',num2str(ProblemSize),'.xlsx'];
        sheetname = [Benchmark,'_D',num2str(ProblemSize),'_F',num2str(Func)];
%         xlswrite(savepath,resultChart,sheetname);
%         fprintf('\n')
%         fprintf('min error vaLUe = %1.8e, max = %1.8e, median = %1.8e, mean = %1.8e, std = %1.8e\n', min(FF(:,Func)), max(FF(:,Func)), median(FF(:,Func)), mean(FF(:,Func)), std(FF(:,Func)))
    end %% end 1 Function run
    PAIDDEtimeD100 = toc;
    save('PAIDDEtimeD100')
%     xlswrite(['Population',num2str(ProblemSize),'.xlsx'],FF,1);
end
