function [popu,fitness,pfit,temp_lep] = Chaotic_selection(popu,fitness,down,up,Chaos_p,wf,D,pfit,temp_lep,Strategy,iter,iterations,success_num,fail_num,LEP)
% lb=lu(1,:);
% ub=lu(2,:);
% randPopuList = randperm(popsize);
% randPopuList = setdiff(randPopuList,1,'stable');
% indiR1 = popold(randPopuList(1),:);
% indiR2 = popold(randPopuList(2),:);
rand('seed',now);
z=0.5;
g=iter;
radius = 0.5 * (1-iter/iterations);
ub = up;
lb = down;
switch Strategy
    case 1
        %% CJADE-R
        j=randi([1,12],1,1);
        temp_X=popu+radius*(up-down).*(Chaos_p(j,g)-z);%r=0.1
        temp_X = windfarm_constraint(temp_X, wf.NA_loc, D,down,up);
        [fit_temp,~,~]= wf_fitness(wf,temp_X);

        if fit_temp>fitness
            popu=temp_X;
            fitness=fit_temp;
        end

    case 2
        %% CJADE-P
        temp_X=rand(12,n);
        for j=1:12
            temp_X(j,:)=popu + radius * (ub-lb) * (Chaos_p(j,g)-z);
            temp_X = windfarm_constraint(temp_X, wf.NA_loc, D,down,up);
            [fit_temp,~,~]= wf_fitness(wf,temp_X);

        end

        [num_Fbest, num_X]=max(fit_temp);
        if num_Fbest>fitness
            popu=temp_X(num_X,:);
            fitness=num_Fbest;
        end

    case 4
        %% CJADE-M
        % Stochastic universal sampling
        rr = rand;

        %  cumulative probability
        normfit1 = cumsum(pfit)/sum(pfit);
        index = find(rr<normfit1);
        select = index(1);

        % x_index = floor(popold(indBest(1),:) -1 / wf.rows);
        % y_index = floor(popold(indBest(1),:) -1  - x_index* wf.rows);
        % x_index = x_index + radius*(wf.rows)*(Chaos_p(select,g)-z);
        % y_index = y_index + radius*(wf.cols)*(Chaos_p(select,g)-z);
        % temp_X =  x_index *12+y_index +1;
        temp_X=popu + radius.*(ub-lb).*(Chaos_p(select,g)-z);

        temp_X = windfarm_constraint(temp_X, wf.NA_loc, D,down,up);
        [fit_temp,power_order]= wf_fitness(wf,temp_X);


        if fit_temp>fitness
            popu=temp_X;
            fitness=fit_temp;
            success_num(temp_lep,select) = 1;
            fail_num(temp_lep,~select)=1;
        else
            success_num(temp_lep,:) = 0;
            fail_num(temp_lep,:)=1;
        end
        ns = success_num;
        nf = fail_num;

        for i = 1 : 12
            if (sum(ns(:, i)) + sum(nf(:, i))) == 0
                pfit(i) = 0.01;%to avoid the possible null success rates
            else
                pfit(i) = sum(ns(:, i)) / (sum(ns(:, i)) + sum(nf(:, i))) + 0.01;
            end
        end

        temp_lep = temp_lep +1;
        if temp_lep > LEP
            temp_lep = 1;
        end

    case 3
        % Stochastic universal sampling
        rr = rand;
        normfit1 = cumsum(pfit)/sum(pfit);
        index = find(rr<normfit1);
        select = index(1);

        lpcount=[];
        temp_X = popu +(indiR1-indiR2)*Chaos_p(select,g)*0.01;%r=0.1

        temp_X = windfarm_constraint(temp_X, wf.NA_loc, D,down,up);
        [fit_temp,~]= wf_fitness(wf,temp_X);


        if fit_temp>fitness
            popu=temp_X;
      
            tlpcount = zeros(1, 12);
            tlpcount(select) = fitness-fit_temp;
            success_num(temp_lep,select)=fitness-fit_temp;
            lpcount=[lpcount;tlpcount];

            fitness=fit_temp;
        end
        temp_lep = temp_lep+1;
        ns = success_num;%[ns; sum(lpcount, 1)];

        %success and failure memory
        if k_circle+1 >= LEP
            for i = 1 : 12
                if sum(sum(ns, 1))== 0
                    pfit(i) = 1/12;%to avoid the possible null success rates
                else
                    pfit(i) = sum(ns(:, i)) / sum(sum(ns, 1))  + 1/12;
                end
            end
            
            if temp_lep > LEP
                temp_lep = 1;
            end
        end
end
end