function [BestChart,BestFitness,farmlayout,farmlayout_NA] = SUGGA(pop_size,wf,iterations,t,NA_type,tn,wt,svr_model,algorithmDir)
%% Parameter
BestChart = zeros(iterations,1);
BestFitness=zeros(iterations,1);
farmlayout = zeros(iterations,wf.rows*wf.cols);
farmlayout_NA = zeros(iterations,wf.rows*wf.cols);
pop_power = zeros(pop_size,wf.cols * wf.rows);
dim = wf.turbine_num; down = 1;up = wf.rows *wf.cols;
%% Initialization

[pop,pop_NA,pop_indices] = windfarm_init_binary(pop_size,wf);
% [pop1,pop_NA1,pop_indices1] = windfarm_init_binary1(pop_size,wf);



farmlayout(1,:) = pop(1,:);
CrossPercent = 0.6;
MutatPercent = 0.1;
ElitPercent = 0.2;% - CrossPercent - MutatPercent;
random_rate = 0.5;
CrossNum = round(CrossPercent * pop_size);
if mod(CrossNum,2)~=0;
    CrossNum = CrossNum - 1;
end
MutatNum = round(MutatPercent*pop_size);
ElitNum = round(ElitPercent*pop_size); % 0.2

%% loop
% while FEs <= Max_FEs
for iter = 1:iterations
    tic
    [popuFitness,power_order,lp_power_accum]= wf_fitness(wf,pop);

    [popuFitness, sorted_index] = sort(popuFitness,'descend');
    
    pop = pop(sorted_index,:);
    pop_NA = pop_NA(sorted_index,:);
    pop_indices = pop_indices(sorted_index, :);
    power_order = power_order(sorted_index,:);

    if iter == 1
        BestFitness(iter,:) = popuFitness(1);
        BestChart(iter,:) = popuFitness(1) / wf.power_total;
        farmlayout(iter,:) = pop(1,:);
        farmlayout_NA(iter,:) = pop_NA(1,:);
    else
        if popuFitness(1) > BestFitness(iter-1)
            BestFitness(iter,:) = popuFitness(1);
            BestChart(iter,:) = popuFitness(1) / wf.power_total;
            farmlayout(iter,:) = pop(1,:);
            farmlayout_NA(iter,:) = pop_NA(1,:);
        else
            BestFitness(iter,:) = BestFitness(iter-1);
            BestChart(iter,:) = BestChart(iter-1,:);
            farmlayout(iter,:) = farmlayout(iter-1,:);
            farmlayout_NA(iter,:) = farmlayout_NA(iter-1,:);
        end

    end
    [pop,pop_NA,pop_indices,power_order] = sugga_move_worst(wf,pop,pop_NA,pop_indices,pop_size,power_order,svr_model);
    
    [n_parent,parents_ind,parent_layouts,parent_layouts_NA,parent_pop_indices] = slection(pop,pop_NA,pop_indices,pop_size,ElitPercent,random_rate);
   
    
    [pop,pop_NA,pop_indices] = crossover(wf,pop,pop_NA,pop_indices,pop_size,n_parent,parents_ind,parent_layouts,parent_pop_indices);
   
    [pop,pop_NA,pop_indices] = mutation(pop,pop_NA, pop_indices, pop_size, MutatPercent,wf);
    
    

%     fprintf('%s NA %d Turbine Num:%d Wind %s run: %d iteration: %d  eta %f fitness %f\n',algorithmDir,NA_type,tn,wt,t,iter,BestChart(iter,:),BestFitness(iter,:))
end


end


