function [pop,pop_NA,pop_indices,power_order]=sugga_move_worst(wf, pop,pop_NA, pop_indices, popsize, power_order,svr_model)

for i = 1:popsize
    if rand <0.5
        [pop(i,:),pop_NA(i,:),pop_indices(i,:),power_order(i,:)] = sugga_move_worst_case_random(wf,pop(i,:),pop_NA(i,:),pop_indices(i,:),power_order(i,:));
    else
        [pop(i,:),pop_NA(i,:),pop_indices(i,:),power_order(i,:)] = sugga_move_worst_case_best(wf,pop(i,:),pop_NA(i,:),pop_indices(i,:),power_order(i,:),svr_model);
    end
end

end
function [pop,pop_NA,pop_indices,power_order]=sugga_move_worst_case_random(wf, pop,pop_NA,pop_indices,power_order)
  
turbine_pos = power_order(1,1);
    while 1
        null_turbine_pos = randi(wf.cols*wf.rows);
        if pop_NA(1, null_turbine_pos)==0
            break
        end
    end
    pop(1,turbine_pos) = 0;
    pop(1,null_turbine_pos) = 1;
    pop_NA(1,turbine_pos) = 0;
    pop_NA(1,null_turbine_pos) = 1;
    
    power_order(1, 1) = null_turbine_pos;
    pop_indices(1, :) = sort(power_order(1, :));
end

function [pop,pop_NA,pop_indices,power_order] = sugga_move_worst_case_best(wf,pop,pop_NA,pop_indices,power_order,model)

    n_candiate = 5;
    pos_candidate = zeros(n_candiate,2);
    ind_pos_candidate = zeros(n_candiate,1);
    turbine_pos = power_order(1, 1);
    ind_can = 1;
    while 1
        null_turbine_pos = randi(wf.cols*wf.rows);
        if pop_NA(1,null_turbine_pos) == 0
           pos_candidate(ind_can,2) = floor(null_turbine_pos / wf.cols);
           pos_candidate(ind_can,1) = floor(null_turbine_pos - pos_candidate(ind_can, 2) * wf.cols);
           ind_pos_candidate(ind_can) = null_turbine_pos;
           ind_can = ind_can + 1;
           if ind_can > n_candiate 
               break
           end
        end
    end
    label_temp = zeros(n_candiate,1);
    [svr_val,~,~]=svmpredict(label_temp,pos_candidate, model,'-b 0 -q');
    [svr_val,sorted_index] = sort(svr_val,'descend');
    
    null_turbine_pos = ind_pos_candidate(sorted_index(1));
    

    pop(1,turbine_pos) = 0;
    pop(1,null_turbine_pos) = 1;
    pop_NA(1,turbine_pos) = 0;
    pop_NA(1,null_turbine_pos) = 1;
    
    power_order(1, 1) = null_turbine_pos;
    pop_indices(1, :) = sort(power_order(1, :));
end