function [pop,pop_NA,init_pop_nonezero_indices] = windfarm_init_binary1(popsize, wf)
%% original 

    pop = zeros(popsize,wf.rows* wf.cols);
    pop_NA = zeros(popsize,wf.rows* wf.cols);
    for ind = wf.NA_loc
        pop_NA(:,ind) = 2;
    end
    position_size=wf.turbine_num*popsize*2;
    positionX = randi(wf.cols,[position_size,1])-1;
    positionY = randi(wf.rows,[position_size,1])-1;

    ind_rows = 1;%  # index of layouts from 0 to n-1
    ind_pos = 1;%  # index of positionX, positionY from 0 to N*n*2-1
    
    N_count = 0;
    while ind_rows <= popsize
        index = positionX(ind_pos,1) + positionY(ind_pos,1) * wf.cols+1;
        
        cur_state = pop_NA(ind_rows, index);
        if (cur_state ~= 1) &&( cur_state ~= 2)
            pop(ind_rows, index) = 1;
            pop_NA(ind_rows, index) = 1;
            N_count = N_count + 1;
            if sum(pop(ind_rows,:)) == wf.turbine_num
                ind_rows  = 1 + ind_rows;
                N_count = 0;
            end
        end
        ind_pos = ind_pos+  1;
        if ind_pos >= position_size
            print("Not enough positions")
            break
        end
    end

    init_pop_nonezero_indices = zeros(popsize,wf.turbine_num);
    for ind_init_pop =1 : popsize
        ind_indices = 1;
        for ind = 1:wf.rows * wf.cols
            if pop(ind_init_pop, ind) == 1
                init_pop_nonezero_indices(ind_init_pop, ind_indices) = ind;
                ind_indices =ind_indices+ 1;
            end
        end
    end
end