function [popu, vel, flag] = CLPSO(popu, vel, maxVel, pBest, pBestFit, pBestSelected, ai, gBest, inerOmega, flag, m)
%
c = [1.496, 1.496];
gap = 7;
[popuSize, D] = size(popu);
for i =1:popuSize
    if flag(i,:) >= gap
        flag(i,:) =0;
        [pBestSelected, ai] = AssignPBest(popuSize, D, ai, pBestFit, pBestSelected, m);
    end
    
    for j = 1:D
        pBest_fi(i,j)=pBest(pBestSelected(i,j),j);
    end
    
    term3 = c(2) .* ai(i,:) .* rand(1,D) .* (gBest - popu(i,:));
    term2 = c(1) .* (1 - ai(i,:)) .* rand(1,D) .* (pBest_fi(i,:) - popu(i,:));
    vel(i,:)=inerOmega .* vel(i,:) + term2 + term3;
    
    vel(i,:) = (vel(i,:) > maxVel) .* maxVel + (vel(i,:) <= maxVel).*vel(i,:);
    vel(i,:) = (vel(i,:) < (-maxVel)) .* (-maxVel) + (vel(i,:) >= (-maxVel)) .* vel(i,:);
    
    popu(i,:) = popu(i,:) + vel(i,:);
end
end