clear
clc
tn_list = [15,20];
wd = 4;
n_speeds = [1,1,1,3,];
n_directions = [1,4,6,12];
unifrom = [0,1,0,1];
path = 'D:/Wind Farm\\Code\\Wind Farm\\WFLOP_SUGGA_Python-master\\WFLOP_SUGGA_Python-master\\data\\wds';


for i = 1:4
    for tn = tn_list
        for na = 0:12
            x_path = sprintf('%s/x_tn%d_na0_wd%d.dat',path,tn,wd);
            y_path = sprintf('%s/y_tn%d_na0_wd%d.dat',path,tn,wd);
            
            x_data = load(x_path);
            y_data = load(y_path);
            sparse_x = sparse(x_data);
            model = svmtrain(y_data, x_data, '-s 3 -t 2 -c 2000.0 -g 0.3 -p 0.1');
            if unifrom(i)
                save(sprintf('svr_tn%d_na%d_%dspeed_%ddirection_uniform.mat',tn,na,n_speeds(i),n_directions(i)),'model')
            else
                save(sprintf('svr_tn%d_na%d_%dspeed_%ddirection.mat',tn,na,n_speeds(i),n_directions(i)),'model')
            end
            
            
        end
    end

end

% y_data
% SVR(kernel='rbf', C=2000.0, gamma=0.3, epsilon=.1)

[predict_label] = svmpredict(y_data, x_data, model);
a = zeros(144,1);
[predict_label1] = svmpredict(a, x_data, model);
sum( predict_label - predict_label1)
% libsvmwrite('test.txt',x_data,y_data)
% load fisheriris
% inds = ~strcmp(species,'setosa');
% X = meas(inds,3:4);
% y = species(inds);
% 
% SVMModel = fitcsvm(X,y);