close all

max_it = 20000;
Chaos_p = GenerateChaos(max_it);
map_name = {'Logistic map','PWLCM map','Singer map','Sine map','Gaussian map','Tent map',...
    'Bernoulli map','Chebyshev map','Circle map','Cubic map','Sinusoidal map','ICMIC map',...
    'uniform distribution','normal random'};
fig = figure('Name','map','Position',[100,100,1400,900]);
tiledlayout(3,4,'TileSpacing','compact','Padding','tight')
for i =1:12
    nexttile
    histogram(Chaos_p(i,:),'BinWidth',0.01,'EdgeColor','none','FaceColor',[0.4940 0.1840 0.5560],'FaceAlpha',1.0)
    title(map_name{i},"FontSize",24,'FontName','Times')
end

saveas(fig,'map.eps','epsc')
saveas(fig,'map.png','png')
