clc
clear all;
Algorithm = 'BDE';
str = {'Australian','Vehicle','German','Breast','Ionosphere','Dermatology','KrVsKpEW','Waveform','spect','sonar'...
    'Hillvalley','MUSK1','URBAN1','Semeion_handwritten_digit','LSVT_voice_rehabilitation','Yale32','Zoo','SCADI','Wine','SPECTF'...
    'Colon'};
for problem_id = 1
%     resultChart = [];
    %% Initialization
    %initial runtime
    runtime =30;
    %initial popusize
    CallStack = dbstack('-completenames');
    load(fullfile(fileparts(CallStack(1).file),'Dataset_FS.mat'),'Dataset');
    Data = Dataset.(str{problem_id});
    %% load Data from dataset
    %divide data into Train and Test as 70%:30%
    TrainIn = Data(1:ceil(end*0.7),1:end-1);
    TrainOut = Data(1:ceil(end*0.7),end);
    ValidIn = Data(ceil(end*0.7)+1:end,1:end-1);
    ValidOut = Data(ceil(end*0.7)+1:end,end);
    Train_data = [TrainIn,TrainOut];
    Valid_data = [ValidIn,ValidOut];
    [~,D] = size(Data);D = D-1;
    best_tester=[];best_tests=[];
         G=[];
    %% Main loop:30 times independent runs
     feature_num=size(TrainIn,2);
       for i=1:feature_num 
        t_mi(i)=mutualinfo(TrainIn(:,i),TrainOut);
       end
        
        
     for idx=1:feature_num     
        for jdx=1:feature_num
         if idx==jdx
            I(idx,jdx)=eps;
          else
             I(idx,jdx) =SU(TrainIn(:,idx), TrainIn(:,jdx));
             if  I(idx,jdx)==0
                 I(idx,jdx)=eps;
             end
         end
        end
     end
         gain = information_gain(TrainIn, TrainOut);
         
   for number =1: runtime
       % Parameter setting
        N        = 30; 
        max_Iter =100; 
        CR       = 0.9;
        FES = N*max_Iter;
        nFES = 0;  
        %initial and evaluate the first popu.
        pointer=zeros(N,D);
        [~,cur_feature]=max(t_mi);
 
       Popu=zeros(N,D);
  
 
for i = 1:N
  for d = 1:D
    if rand() > 0.5
      Popu(i,d) = 1;
    end
  end
end

  
  
for i = 1:N  
    MemoryI=I;
    for d = 1:D
       

         if d==1
              pointer(i,d)=cur_feature;
                temp=1-max(t_mi);
%              
                if rand<temp
                Popu(i,cur_feature)=0;
                else
                Popu(i,cur_feature)=1;
                end
             MemoryI(:,cur_feature)=0;
         elseif d~=1&&d~=D
             if  Popu(i, pointer(i,d-1))==1
              probability= MemoryI(pointer(i,d-1),:)./sum( MemoryI(pointer(i,d-1),:));
                [a,clas_def]=roulette_wheel(probability,d);
                 pointer(i,d)=a;
                 if (clas_def==0)
                    Popu(i,pointer(i,d))=1;
                 else
                    Popu(i,pointer(i,d))=0;
                 end
                
             else
                probability=MemoryI(pointer(i,d-1),:)./sum(MemoryI(pointer(i,d-1),:));
                 [a,clas_def]=roulette_wheel(probability,d);
                 
                 pointer(i,d)=a;
                 if (clas_def==0)
                    Popu(i,pointer(i,d))=0;
                 else
                    Popu(i,pointer(i,d))=1;
                 end
             end
                  MemoryI(:,a)=0;
         else
             probability= MemoryI(pointer(i,d-1),:)./sum( MemoryI(pointer(i,d-1),:));
                [a,~]=roulette_wheel(probability,d);
                 pointer(i,d)=a;
                if t_mi(pointer(i,d))>mean(t_mi)
                     Popu(i,pointer(i,d))=0;
                else
                    Popu(i,pointer(i,d))=1;
                end
                  MemoryI(:,a)=0;
         end
        
    end
end
        fitness = Evaluation(Popu,N,D,Train_data);
        [pBest,pBest_idx]=min(fitness);
        pBest_indicidual = Popu(pBest_idx,:);
        lBest_indicidual = Popu(pBest_idx,:);
        nFES = nFES + N;
        %initial global best
        gBest = pBest;
        lBest= pBest;
       oldgBest=gBest;

        gBest_individual = pBest_indicidual;
       meansu=mean(I);
          c=0;
           F=1;
        
        while nFES<FES
           
            [Popu,fitness,gBest,gBest_individual,oldgBest,c] = BDE(Popu,fitness,D,N,Train_data,c,gBest,gBest_individual,I,meansu,F,nFES,FES,oldgBest,gain,t_mi);
            nFES = nFES + N;
            fprintf('algorithm-%s problem-%s runtime-%s |%5.0f -----> %9.16f\n', Algorithm, str{problem_id},num2str(number),nFES,gBest);
        end
        %% solve the result as .csv
       final = gBest_individual;
            p = [];
            s=[];
            s=logical(final);
            while sum(s) == 0
                s= logical(round(rand(1 , size(s,2))));
            end
           mdltest = fitcknn(TrainIn(:,logical( final)),TrainOut,'NumNeighbors',5);
            c = predict(mdltest,ValidIn(:,logical(s)));
            p = 1-length(find(c==ValidOut))/length(c);
            cp=1-p;
            totalcp(number,:)=cp;
            p=[gBest,p,cp,final];
            G=[G;p];
     
    end 
       
     dir_name = class(Algorithm);
        save_path = './result/';
        if ~exist(save_path,'dir')
            mkdir(save_path)
        end
        csv_name=strcat(Algorithm,'-',str{problem_id},'_',num2str(number),'.csv');
        writematrix(G,fullfile(save_path,csv_name))
       
         
          
          
          
    end




