function [popu, lu, rgo, o, A, M, a, alpha, b] = Initialization(popuSize, D, benchmark, problemIndex)
switch benchmark
    case 2005
        CEC2005Dir = 'CEC/CEC_2005';
        addpath(['../../', CEC2005Dir]);
        rgo = [0];
        switch problemIndex
            case 1
                % lu: define the upper and lower bounds of the variables
                lu = [-100 * ones(1, D); 100 * ones(1, D)];
                % Load the data for this test function
                load sphere_func_data
                A = []; M = []; a = []; alpha = []; b = [];
                
            case 2
                lu = [-100 * ones(1, D); 100 * ones(1, D)];
                load schwefel_102_data
                A = []; M = []; a = []; alpha = []; b = [];
                
            case 3
                lu = [-100 * ones(1, D); 100 * ones(1, D)];
                load high_cond_elliptic_rot_data
                A = []; a = []; alpha = []; b = [];
                
                if D == 2, load elliptic_M_D2,
                elseif D == 10, load elliptic_M_D10,
                elseif D == 30, load elliptic_M_D30,
                elseif D == 50, load elliptic_M_D50,
                end
            case 4
                
                lu = [-100 * ones(1, D); 100 * ones(1, D)];
                load schwefel_102_data
                A = []; M = []; a = []; alpha = []; b = [];
                
            case 5
                
                lu = [-100 * ones(1, D); 100 * ones(1, D)];
                load schwefel_206_data
                M = []; a = []; alpha = []; b = [];
                
            case 6
                
                lu = [-100 * ones(1, D); 100 * ones(1, D)];
                load rosenbrock_func_data
                A = []; M = []; a = []; alpha = []; b = [];
                
            case 7
                
                lu = [0 * ones(1, D); 600 * ones(1, D)];
                load griewank_func_data
                A = []; a = []; alpha = []; b = [];
                
                if D == 2, load griewank_M_D2,
                elseif D == 10, load griewank_M_D10,
                elseif D == 30, load griewank_M_D30,
                elseif D == 50, load griewank_M_D50,
                end
                
            case 8
                
                lu = [-32 * ones(1, D); 32 * ones(1, D)];
                load ackley_func_data
                A = []; a = []; alpha = []; b = [];
                
                if D == 2, load ackley_M_D2,
                elseif D == 10, load ackley_M_D10,
                elseif D == 30, load ackley_M_D30,
                elseif D == 50, load ackley_M_D50,
                end
                
            case 9
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load rastrigin_func_data
                A = []; M = []; a = []; alpha = []; b = [];
                
            case 10
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load rastrigin_func_data
                A = []; a = []; alpha = []; b = [];
                if D == 2, load rastrigin_M_D2,
                elseif D == 10, load rastrigin_M_D10,
                elseif D == 30, load rastrigin_M_D30,
                elseif D == 50, load rastrigin_M_D50,
                end
                
            case 11
                
                lu = [-0.5 * ones(1, D); 0.5 * ones(1, D)];
                load weierstrass_data
                A = []; a = []; alpha = []; b = [];
                if D == 2, load weierstrass_M_D2,
                elseif D == 10, load weierstrass_M_D10,
                elseif D == 30, load weierstrass_M_D30,
                elseif D == 50, load weierstrass_M_D50,
                end
                
            case 12
                
                lu = [-pi * ones(1, D); pi * ones(1, D)];
                load schwefel_213_data
                A = []; M = []; o = [];
                
            case 13
                
                lu = [-3 * ones(1, D); 1 * ones(1, D)];
                load EF8F2_func_data
                A = []; M = []; a = []; alpha = []; b = [];
                
            case 14
                
                lu = [-100 * ones(1, D); 100 * ones(1, D)];
                load E_ScafferF6_func_data
                if D == 2, load E_ScafferF6_M_D2,
                elseif D == 10, load E_ScafferF6_M_D10,
                elseif D == 30, load E_ScafferF6_M_D30,
                elseif D == 50, load E_ScafferF6_M_D50,
                end
                A = []; a = []; alpha = []; b = [];
                
            case 15
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func1_data
                A = []; M = []; a = []; alpha = []; b = [];
                
            case 16
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func1_data
                if D == 2, load hybrid_func1_M_D2,
                elseif D == 10, load hybrid_func1_M_D10,
                elseif D == 30, load hybrid_func1_M_D30,
                elseif D == 50, load hybrid_func1_M_D50,
                end
                A = []; a = []; alpha = []; b = [];
                
            case 17
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func1_data
                if D == 2, load hybrid_func1_M_D2,
                elseif D == 10, load hybrid_func1_M_D10,
                elseif D == 30, load hybrid_func1_M_D30,
                elseif D == 50, load hybrid_func1_M_D50,
                end
                A = []; a = []; alpha = []; b = [];
                
            case 18
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func2_data
                if D == 2, load hybrid_func2_M_D2,
                elseif D == 10, load hybrid_func2_M_D10,
                elseif D == 30, load hybrid_func2_M_D30,
                elseif D == 50, load hybrid_func2_M_D50,
                end
                A = []; a = []; alpha = []; b = [];
                
            case 19
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func2_data
                if D == 2, load hybrid_func2_M_D2,
                elseif D == 10, load hybrid_func2_M_D10,
                elseif D == 30, load hybrid_func2_M_D30,
                elseif D == 50, load hybrid_func2_M_D50,
                end
                A = []; a = []; alpha = []; b = [];
                
            case 20
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func2_data
                if D == 2, load hybrid_func2_M_D2,
                elseif D == 10, load hybrid_func2_M_D10,
                elseif D == 30, load hybrid_func2_M_D30,
                elseif D == 50, load hybrid_func2_M_D50,
                end
                A = []; a = []; alpha = []; b = [];
                
            case 21
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func3_data
                if D == 2, load hybrid_func3_M_D2,
                elseif D == 10, load hybrid_func3_M_D10,
                elseif D == 30, load hybrid_func3_M_D30,
                elseif D == 50, load hybrid_func3_M_D50,
                end
                A = []; a = []; alpha = []; b = [];
                
            case 22
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func3_data
                if D == 2, load hybrid_func3_HM_D2,
                elseif D == 10, load hybrid_func3_HM_D10,
                elseif D == 30, load hybrid_func3_HM_D30,
                elseif D == 50, load hybrid_func3_HM_D50,
                end
                A = []; a = []; alpha = []; b = [];
                
            case 23
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func3_data
                if D == 2, load hybrid_func3_M_D2,
                elseif D == 10, load hybrid_func3_M_D10,
                elseif D == 30, load hybrid_func3_M_D30,
                elseif D == 50, load hybrid_func3_M_D50,
                end
                A = []; a = []; alpha = []; b = [];
                
            case 24
                
                lu = [-5 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func4_data
                if D == 2, load hybrid_func4_M_D2,
                elseif D == 10, load hybrid_func4_M_D10,
                elseif D == 30, load hybrid_func4_M_D30,
                elseif D == 50, load hybrid_func4_M_D50,
                end
                A = []; a = []; alpha = []; b = [];
                
            case 25
                
                lu = [2 * ones(1, D); 5 * ones(1, D)];
                load hybrid_func4_data
                if D == 2, load hybrid_func4_M_D2,
                elseif D == 10, load hybrid_func4_M_D10,
                elseif D == 30, load hybrid_func4_M_D30,
                elseif D == 50, load hybrid_func4_M_D50,
                end
                A = []; a = []; alpha = []; b = [];
        end
    case 2008
        A = []; M = []; a = []; alpha = []; b = [];
        rgo = [0];
    case 2011
        if problemIndex == 11; problemIndex = 111; end;
        if problemIndex == 12; problemIndex = 112; end;
        if problemIndex == 13; problemIndex = 113; end;
        if problemIndex == 14; problemIndex = 114; end;
        if problemIndex == 15; problemIndex = 115; end;
        if problemIndex == 16; problemIndex = 116; end;
        if problemIndex == 17; problemIndex = 117; end;
        if problemIndex == 18; problemIndex = 118; end;
        if problemIndex == 19; problemIndex = 119; end;
        if problemIndex == 20; problemIndex = 1110; end;
        if problemIndex == 21; problemIndex = 12; end;
        if problemIndex == 22; problemIndex = 13; end;
        CEC2011Dir = 'CEC/CEC_2011/CEC 2011 Benchmarks';
        addpath(['../../', CEC2011Dir]);
        addpath(['../../', CEC2011Dir, '/Probs_1_to_8']);
        addpath(['../../', CEC2011Dir, '/Prob_9_Transmission_Pricing']);
        addpath(['../../', CEC2011Dir, '/Prob_10_Circ_Antenna']);
        addpath(['../../', CEC2011Dir, '/Probs_11_ELD_Package/DED Codes']);
        addpath(['../../', CEC2011Dir, '/Probs_11_ELD_Package/ELD Codes']);
        addpath(['../../', CEC2011Dir, '/Probs_11_ELD_Package/Hydrothermal Codes']);
        addpath(['../../', CEC2011Dir, '/Probs_12_to_13_Package']);
        GetFunInfoAddr = @CEC2011get_fun_info;
        [LB, UB, dem, opt_f, err] = GetFunInfoAddr(problemIndex);
        lu = [LB;UB];
        A = []; M = []; a = []; alpha = []; b = []; o = [];
        rgo = [0];
    case 2013
        CEC2013Dir = 'CEC/CEC_2013';
        addpath(['../../', CEC2013Dir]);
        addpath(['../../',CEC2013Dir, '/input_data']);
        lb = -100;
        ub = 100;
        lu = [lb * ones(1, D); ub * ones(1, D)];
        A = []; M = []; a = []; alpha = []; b = []; o = [];
        source = '../../CEC\CEC_2013/input_data';
        copyfile(source, 'input_data');
        rgo = [-1400;-1300;-1200;-1100;-1000;-900;-800;-700;-600;-500;-400;-300;-200;-100;100;200;300;400;500;600;700;800;900;1000;1100;1200;1300;1400];
    case 2014
        CEC2014Dir = 'CEC/CEC_2014';
        addpath(['../../', CEC2014Dir]);
        addpath(['../../',CEC2014Dir, '/input_data']);
        lb = -100;
        ub = 100;
        lu = [lb * ones(1, D); ub * ones(1, D)];
        A = []; M = []; a = []; alpha = []; b = []; o = [];
        source = '../../CEC\CEC_2014/input_data';
        copyfile(source, 'input_data');
        rgo = [0];
    case 2017
        CEC2017Dir = 'CEC/CEC_2017';
        addpath(['../../', CEC2017Dir]);
        addpath(['../../',CEC2017Dir, '/input_data']);
        lb = -100;
        ub = 100;
        lu = [lb * ones(1, D); ub * ones(1, D)];
        A = []; M = []; a = []; alpha = []; b = []; o = [];
        source = '../../CEC\CEC_2017/input_data';
        copyfile(source, 'input_data');
        rgo = [100;200;300;400;500;600;700;800;900;1000;1100;1200;1300;1400;1500;1600;1700;1800;1900;2000;2100;2200;2300;2400;2500;2600;2700;2800;2900;3000];
    case 2019
end
if benchmark == 2011
    popu = repmat(lu(1, :), popuSize, 1) + rand(popuSize, dem) .* (repmat(lu(2, :) - lu(1, :), popuSize, 1));
else
    popu = repmat(lu(1, :), popuSize, 1) + rand(popuSize, D) .* (repmat(lu(2, :) - lu(1, :), popuSize, 1));
end
end

