% the main.m
clear all
algorithmDir_basic = 'SIS';
algorithmDir = 'SIS';
optimalChart_interval = 100;
%%
% Global parameters setting

%CEC2005 include 25 functions
%CEC2011 include 22 functions
%CEC2013 include 28 functions
%CEC2014 include 30 functions
%CEC2017 include 30 functions
benchmark = 2017;
problemIndex = [1 3:30];
runTime = 51;
D =30;
pop = 100;
FES = 1 * 10^4 * D;
PDD=[];
l=0.5;
popuSize=pop;
% analysisChart = [];
addpath('../../');
%% For CEC2011
if benchmark ~= 2011
    pathOfBoxPlot = ['./',algorithmDir,'_CEC',num2str(benchmark),'_D',num2str(D),'_Mean&Std_and_Box-Plot.xls'];
    pathOfConvergence = ['./',algorithmDir,'_CEC',num2str(benchmark),'_D',num2str(D),'_Convergence.xls'];
else
    %% init table for CEC2011
    pathOfBoxPlot = ['./',algorithmDir,'_CEC',num2str(benchmark),'_Mean&Std_and_Box-Plot.xls'];
    pathOfConvergence = ['./',algorithmDir,'_CEC',num2str(benchmark),'_Convergence.xls'];
end
%% init table
tableOfBoxPlot = initTableforBoxPlot(length(problemIndex),runTime);
tableOfConvergence = initTableforConvergence(length(problemIndex));
rand('seed', sum(100 * clock));
val_2_reach = 10^(-8);
for func = problemIndex
    resultChart = [];
    t = 1;
    f = func;
    fnum = f;
    optimum = func * 100.0;
    if benchmark == 2011
        if f == 11; fnum = 111; end;
        if f == 12; fnum = 112; end;
        if f == 13; fnum = 113; end;
        if f == 14; fnum = 114; end;
        if f == 15; fnum = 115; end;
        if f == 16; fnum = 116; end;
        if f == 17; fnum = 117; end;
        if f == 18; fnum = 118; end;
        if f == 19; fnum = 119; end;
        if f == 20; fnum = 1110; end;
        if f == 21; fnum = 12; end;
        if f == 22; fnum = 13; end;
        CEC2011Dir = 'CEC/CEC_2011/CEC 2011 Benchmarks';
        addpath(['../../', CEC2011Dir]);
        GetFunInfoAddr = @CEC2011get_fun_info;
        [LB, UB, dem, opt_f, err] = GetFunInfoAddr(fnum);
        D = dem;disp(D);
        %% ============================================================================================================================================================
        %% ============================================================================================================================================================
        popuSize = 100;  %fix this line when running CEC_2011
        FES = 1 * 10^4 * D; %fix this line when running CEC_2011
        %% ============================================================================================================================================================
        %% ============================================================================================================================================================
    end
    for run_id = 1 : runTime
        %% init of each run
        % FES count
        nFES = 0;
        nfes = nFES;

        optimalChart = [];
        % Population initialization
        [popu, lu, rgo, o, A, M, a, alpha, b] = Initialization(popuSize, D, benchmark, f);
        % dimension for certain problem
        D = size(popu,2);

        x = [];
        [popuFitness] = Evaluation(popu, benchmark, f);
        popuFitness =popuFitness';
        [a,best] = min(popuFitness);
        x= popu(best,:);
        
        if rgo ~= 0
            rgo = rgo(f);
        end
        n=D;
        constraints=lu';
        bsf_fit_var = 1e+30;
        PD=0;
        N = pop;	% number of considered points
        step= [];
        N0 = floor((N)^(1/n));	% number of points in regular grid per one dimension
        for i = 1:n
            step(i) = (constraints(i,2)-constraints(i,1))/N0;
        end

        % discretization step
        delta_x_m = step;
        % data record
        for i = 1 : popuSize
            nFES = nFES + 1;
            if popuFitness(i) < bsf_fit_var
                bsf_fit_var = popuFitness(i);
            end
            if mod(nFES, optimalChart_interval) == 0
                optimalChart = [optimalChart;bsf_fit_var];
            else
                if nFES == FES
                    optimalChart = [optimalChart;bsf_fit_var];
                end
            end
            if nFES > FES; break; end
        end
        if D == 2
            mkdir traj
            imgPath = ['traj_' num2str(benchmark) '_' num2str(problemIndex)];
            mkdir(imgPath);
        end
        %diversity calculation
        PDChart = [];
        popu_mean = mean(popu);
        for i = 1 : N
            PD = PD + norm(popu(i,:)-popu_mean,2)^2;
        end
        PD = sqrt(PD)/N;
        PDChart = [PDChart;PD];
        while nFES < FES
            R=nFES/FES*0.1;
            x_selected = [];
            f_temp = [];
            c=floor(pop*l);
            cc=pop-c;

            %%Chaos subpopulation L
            x_sele1=zeros(c, n);
            Chaos=[];
            z1=rand(n,1);
            for s=1:n
                while z1(s)==0.25 || z1(s)==0.5 || z1(s)==0.75
                    z1(s)=rand;
                end
            end
            a=4.0;
            Chaos(:,1)=z1;
            for h=1:c-1
                Chaos(:,h+1)=a*Chaos(:,h)-Chaos(:,h)*a.*Chaos(:,h);
            end
            neighborhood =Chaos';
            for j = 1:n
                x_sele1(:,j) = (2*neighborhood(:,j)-1)*delta_x_m(1,j)+...
                    x(j)*ones(c,1);
            end
            [x_sele1] = BoundaryDetection(x_sele1,lu);
            [fl] = Evaluation(x_sele1, benchmark, f);
            [optimalFitl,optIl] = min(fl);
            ffl=optimalFitl;

            %%random subpopulation R
            x_sele2=zeros(cc, n);
            neighborhoodc =rand(cc, n);
            for j = 1:n
                x_sele2(:,j) = (2*neighborhoodc(:,j)-1)*delta_x_m(1,j)+...
                    x(j)*ones(cc,1);
            end
            [x_sele2] = BoundaryDetection(x_sele2,lu);
            [fc] = Evaluation(x_sele2, benchmark, f);
            [optimalFitc,optIc] = min(fc);
            ffc=optimalFitc;
            x_selected= [x_selected; x_sele1; x_sele2];
            f_temp = [f_temp, fl, fc];
            
            %%intelligent scheme
            if ffc<ffl
                delta_x_m=delta_x_m-R*delta_x_m;
                x= x_sele2(optIc,:);
            else
                delta_x_m=delta_x_m+R*delta_x_m;
                x= x_sele1(optIl,:);
            end

            f_temp= f_temp';
            popuFitness =  f_temp;

            % data record
            for i = 1 : popuSize
                nFES = nFES + 1;
                if popuFitness(i) < bsf_fit_var
                    bsf_fit_var = popuFitness(i);
                end
                if mod(nFES, optimalChart_interval) == 0
                    optimalChart = [optimalChart;bsf_fit_var];
                else
                    if nFES == FES
                        optimalChart = [optimalChart;bsf_fit_var];
                    end
                end
                if nFES > FES; break; end
            end

            % For minimization problems
            optimal = bsf_fit_var;
            fprintf('%s problem %5.0f time %5.0f |%5.0f -----> %9.16f\n', algorithmDir, f,run_id,nFES,optimal);
            if D == 2
                showTraj(f, nFES, x_selected(1:popuSize,:), optimal, optimal, imgPath);
            end
            %diversity calculation
            popu_mean = mean(popu);
            for i = 1 : N
                PD = PD + norm(popu(i,:)-popu_mean,2)^2;
            end
            PD = sqrt(PD)/N;
            PDChart = [PDChart;PD];
        end
        resultChart = [resultChart,optimalChart];
        bsf_error_val = bsf_fit_var - optimum;
        if bsf_error_val < val_2_reach
            bsf_error_val = 0;
        end
        PDD=[PDD,PDChart];
    end
    %     analysisChart = [analysisChart;resultChart(maxIter,:)];
    boxPlotChart = resultChart(end,:);
    convergenceChart = mean(resultChart,2);
    if benchmark ~= 2011
        path = ['./',algorithmDir_basic,'_',algorithmDir,'_CEC',num2str(benchmark),'_D',num2str(D),'.xls'];
    else
        path = ['./',algorithmDir_basic,'_',algorithmDir,'_CEC',num2str(benchmark),'.xls'];
    end
    sheetName = ['CEC_' num2str(benchmark) '_F'];
    xlswrite(path,resultChart,[sheetName,num2str(f),'_D',num2str(D)]);

    %% save result
    tableOfBoxPlot = updateTableforBoxPlot(tableOfBoxPlot,boxPlotChart,pathOfBoxPlot,rgo,f);
    tableOfConvergence = updateTableforConvergence(tableOfConvergence,convergenceChart,pathOfConvergence,rgo,f);
end
%% delete file
switch benchmark
    case 2013
        rmdir('input_data', 's');
    case 2014
        rmdir('input_data', 's');
    case 2017
        rmdir('input_data', 's');
end
function tableB = initTableforBoxPlot(problemNum, runNum)
row = 3 + problemNum;
col = 1 + runNum;
tableB = cell(row, col);
tableB{1,2} = 'mean';
tableB{1,3} = 'std';
for i = 1:problemNum
    tableB{i+1,1} = ['F' num2str(i)];
end
end

function tableC = initTableforConvergence(problemNum)
col = problemNum;
tableC = cell(1,col);
for i = 1:col
    tableC{1,i} = ['F' num2str(i)];
end
end

function tableB = updateTableforBoxPlot(tableB,data,path,rgo,problemIndex)
[row,col] = size(data);
% rgo = repmat(rgo(problemIndex),1,col);
rgo = repmat(rgo,1,col);
data = data - rgo;
dataMean = mean(data,2);
dataStd = std(data,0,2);
Dcol = ones(1,col);
Drow = ones(1,row);
dataMean = mat2cell(dataMean,Drow,[1]);
dataStd = mat2cell(dataStd,Drow,[1]);
tableB(problemIndex+1,2) = dataMean;
tableB(problemIndex+1,3) = dataStd;
dataCol = mat2cell(data,[1],Dcol);
tableB(problemIndex+1,4:3+col) = dataCol;
xlswrite(path,tableB);
end

function tableC = updateTableforConvergence(tableC,data,path,rgo,problemIndex)
[row,col] = size(data);
% rgo = repmat(rgo(problemIndex)',row,1);
rgo = repmat(rgo',1,col);
data = data - rgo;
Drow = ones(1,row);
dataCol = mat2cell(data,Drow,[1]);
tableC(2:row+1,problemIndex) = dataCol;
xlswrite(path,tableC);
end

function showTraj(problemIndex, nFES, popu, pBest, optimal, imgPath)
popuSize = size(popu,1);
func_plot(problemIndex);
h = plot(popu(:,1),popu(:,2),'.r','MarkerSize',15);
hold on
if mod(nFES / popuSize, 1) == 0
    %     saveas(gcf,[[imgPath '/'],num2str(nFES / popuSize) '.png']);
    saveas(gcf,[[imgPath '/'],num2str(nFES / popuSize) '.fig']);
    %     saveas(gcf,[[imgPath '/'],num2str(nFES / popuSize) '.eps'], 'epsc');
end
hold off
end


