/*#Paper:  Serial Multilevel-learned Differential Evolution with Adaptive Control of Exploration and Exploitation
All the code of the SMLDE is contained in "SMLDE.cpp" file.
Compilation is simple using gcc/g++:
g++ SMLDE.cpp -o SMLDE.exe -std=c++11 -O3 -march=corei7-avx -fexpensive-optimizations -fomit-frame-pointer
Please note that the compilation requires support of C++11 standard. 
You may omit everything after "-O3", however, these options give a significant boost on most systems.
This will create SMLDE.exe, available for running.
Next, the main optimization loop will be started, writing data to "SMLDE_(DIM)_(F).csv", 
where F and DIM are the function number and problem dimension. */
#include <cmath>
#include <time.h>
#include <iomanip>
#include <vector>
#include <cstring>
#include <sstream>
#include <fstream>
#include <iostream>
#include <random>

#include "mCEC_Function.h"

#define INF 1.0e99
#define EPS 1.0e-14
#define E  2.7182818284590452353602874713526625
#define PI 3.141592653589793
#define ME 2.220446049250310e-16

using namespace std;
unsigned globalseed = unsigned(time(NULL));
//unsigned globalseed = 2018;
unsigned seed1 = globalseed + 0;
unsigned seed2 = globalseed + 100;
unsigned seed3 = globalseed + 200;
unsigned seed4 = globalseed + 300;
unsigned seed5 = globalseed + 400;
std::mt19937 generator_uni_i(seed1);
std::mt19937 generator_uni_r(seed2);
std::mt19937 generator_norm(seed3);
std::mt19937 generator_cachy(seed4);
std::mt19937 generator_uni_i_2(seed5);
std::uniform_int_distribution<int> uni_int(0, 32768);
std::uniform_real_distribution<double> uni_real(0.0, 1.0);
std::normal_distribution<double> norm_dist(0.0, 1.0);
std::cauchy_distribution<double> cachy_dist(0.0, 1.0);
double jumping_rate = 0.2;
FIELD_TYPE objective_value[20];

int IntRandom(int target) {
	if (target == 0)
		return 0;
	return uni_int(generator_uni_i) % target;
}
double Random(double minimal, double maximal) {
	return uni_real(generator_uni_r) * (maximal - minimal) + minimal;
}
double NormRand(double mu, double sigma) {
	return norm_dist(generator_norm) * sigma + mu;
}
double CachyRand(double mu, double sigma) {
	return cachy_dist(generator_cachy) * sigma + mu;
}
void qSort2int(double* Mass, int* Mass2, int low, int high) {
	int i = low;
	int j = high;
	double x = Mass[(low + high) >> 1];
	do {
		while (Mass[i] < x) ++i;
		while (Mass[j] > x) --j;
		if (i <= j) {
			double temp = Mass[i];
			Mass[i] = Mass[j];
			Mass[j] = temp;
			double temp2 = Mass2[i];
			Mass2[i] = Mass2[j];
			Mass2[j] = temp2;
			i++;
			j--;
		}
	} while (i <= j);
	if (low < j) qSort2int(Mass, Mass2, low, j);
	if (i < high) qSort2int(Mass, Mass2, i, high);
}

//void cec11_test_func(double*, double*);
double* OShift, * M, * y, * z, * x_bound;
int ini_flag = 0, n_flag, func_flag, * SS;
int GNVars;
double ResultsArray[51][14];
int LastFEcount;
int NFEval = 0;
int MaxFEval = 0;
double tempF[1];
double fopt[1];
char buffer[30];
double globalbest;

int gbi;//**记录全局最优个体的序号
int GBI;//**

bool globalbestinit;
bool initfinished;
vector<double> FitTemp;

/*void GetOptimum(int func_num, double* xopt, double* fopt) {
	FILE* fpt;
	char FileName[30];
	sprintf(FileName, "input_data/shift_data_%d.txt", func_num);
	fpt = fopen(FileName, "r");
	if (fpt == NULL)
		printf("\n Error: Cannot open input file for reading \n");
	for (int k = 0; k < GNVars; k++)
		fscanf(fpt, "%lf", &xopt[k]);
	fclose(fpt);
	cec17_test_func(xopt, fopt, GNVars, 1, func_num);
}*/
typedef struct {
    int Dim;
    double* CurRight;
    double* CurLeft;
} Info ;

void FindLimits(double* Ind, double* Parent, int CurNVars, double* CurLeft, double* CurRight) {
	for (int j = 0; j < CurNVars; j++) {
		if (Ind[j] < CurLeft[j])
			Ind[j] = (CurLeft[j] + Parent[j]) / 2.0;
		if (Ind[j] > CurRight[j])
			Ind[j] = (CurRight[j] + Parent[j]) / 2.0;
	}
}

Info GetInfo(int func_num){
    int Dim;
    double* CurLeft; 
    double* CurRight;
    Info return_info;

    switch(func_num){
    	case 1:{           
            Dim = 6;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for (int i = 0; i != Dim; i++){
                CurLeft[i] = -6.4;
                CurRight[i] = 6.35; 
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 2:{
            Dim = 30;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for (int i = 0; i != Dim; i++){
                CurLeft[i] = -4 - (floor((double(i)+1-4)/3) / 4);
                CurRight[i] = (-1) * CurLeft[i]; 
            }
            CurRight[0] = 4; 
            CurRight[1] = 4;   
            CurRight[2] = PI; 
            CurLeft[0] = 0; 
            CurLeft[1] = 0; 
            CurLeft[2] = 0;
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 3:{   
            Dim = 1;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for (int i = 0; i != Dim; i++){
                CurLeft[i] = 0.6;
                CurRight[i] = 0.9; 
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        } 
        case 4:{    
            Dim = 1;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for (int i = 0; i != Dim; i++){
                CurLeft[i] = 0;
                CurRight[i] = 5; 
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 5:{
            Dim = 30;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for (int i = 0; i != Dim; i++){
                CurLeft[i] = -4 - (floor((double(i)+1-4)/3) / 4);
                CurRight[i] = (-1) * CurLeft[i]; 
            }
            CurRight[0] = 4; 
            CurRight[1] = 4;   
            CurRight[2] = PI; 
            CurLeft[0] = 0; 
            CurLeft[1] = 0; 
            CurLeft[2] = 0;
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 6:{
            Dim = 30;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for (int i = 0; i != Dim; i++){
                CurLeft[i] = -4 - (floor((double(i)+1-4)/3) / 4);
                CurRight[i] = (-1) * CurLeft[i]; 
            }
            CurRight[0] = 4; 
            CurRight[1] = 4;   
            CurRight[2] = PI; 
            CurLeft[0] = 0; 
            CurLeft[1] = 0; 
            CurLeft[2] = 0;
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 7:{
            Dim = 20;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for (int i = 0; i != Dim; i++){
                CurLeft[i] = 0;
                CurRight[i] = 2*PI; 
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }     
        case 8:{
            Dim = 7;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for (int i = 0; i != Dim; i++){
                CurLeft[i] = ME;
                CurRight[i] = 15; 
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }   
        case 9:{
            Dim = 126;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for (int i = 0; i != Dim; i++){
                CurLeft[i] = 0;
            }
            CurRight[0] = 0.217; CurRight[1] = 0.024; CurRight[2] = 0.076; CurRight[3] = 0.892; CurRight[4] = 0.128; CurRight[5] = 0.250;
            CurRight[6] = 0.058; CurRight[7] = 0.112; CurRight[8] = 0.062; CurRight[9] = 0.082; CurRight[10] = 0.035; CurRight[11] = 0.09;
            CurRight[12] = 0.032; CurRight[13] = 0.095; CurRight[14] = 0.022; CurRight[15] = 0.175; CurRight[16] = 0.032; CurRight[17] = 0.087;
            CurRight[18] = 0.035; CurRight[19] = 0.024; CurRight[20] = 0.106; CurRight[21] = 0.217; CurRight[22] = 0.024; CurRight[23] = 0.026;
            CurRight[24] = 0.491; CurRight[25] = 0.228; CurRight[26] = 0.300; CurRight[27] = 0.058; CurRight[28] = 0.112; CurRight[29] = 0.062;
            CurRight[30] = 0.082; CurRight[31] = 0.035; CurRight[32] = 0.090; CurRight[33] = 0.032; CurRight[34] = 0.095; CurRight[35] = 0.022;
            CurRight[36] = 0.175; CurRight[37] = 0.032; CurRight[38] = 0.087; CurRight[39] = 0.035; CurRight[40] = 0.024; CurRight[41] = 0.106;
            CurRight[42] = 0.216; CurRight[43] = 0.024; CurRight[44] = 0.076; CurRight[45] = 0.216; CurRight[46] = 0.216; CurRight[47] = 0.216;
            CurRight[48] = 0.058; CurRight[49] = 0.112; CurRight[50] = 0.062; CurRight[51] = 0.082; CurRight[52] = 0.035; CurRight[53] = 0.090;
            CurRight[54] = 0.032; CurRight[55] = 0.095; CurRight[56] = 0.022; CurRight[57] = 0.175; CurRight[58] = 0.032; CurRight[59] = 0.087;
            CurRight[60] = 0.035; CurRight[61] = 0.024; CurRight[62] = 0.081; CurRight[63] = 0.217; CurRight[64] = 0.024; CurRight[65] = 0.076;
            CurRight[66] = 0.228; CurRight[67] = 0.228; CurRight[68] = 0.228; CurRight[69] = 0.058; CurRight[70] = 0.112; CurRight[71] = 0.062;
            CurRight[72] = 0.082; CurRight[73] = 0.035; CurRight[74] = 0.090; CurRight[75] = 0.032; CurRight[76] = 0.095; CurRight[77] = 0.022;
            CurRight[78] = 0.025; CurRight[79] = 0.032; CurRight[80] = 0.087; CurRight[81] = 0.035; CurRight[82] = 0.024; CurRight[83] = 0.081;
            CurRight[84] = 0.124; CurRight[85] = 0.024; CurRight[86] = 0.076; CurRight[87] = 0.124; CurRight[88] = 0.124; CurRight[89] = 0.124;
            CurRight[90] = 0.058; CurRight[91] = 0.112; CurRight[92] = 0.062; CurRight[93] = 0.082; CurRight[94] = 0.035; CurRight[95] = 0.065;
            CurRight[96] = 0.032; CurRight[97] = 0.095; CurRight[98] = 0.022; CurRight[99] = 0.124; CurRight[100] = 0.032; CurRight[101] = 0.087;
            CurRight[102] = 0.035; CurRight[103] = 0.024; CurRight[104] = 0.106; CurRight[105] = 0.116; CurRight[106] = 0.024; CurRight[107] = 0.076;
            CurRight[108] = 0.116; CurRight[109] = 0.116; CurRight[110] = 0.116; CurRight[111] = 0.058; CurRight[112] = 0.087; CurRight[113] = 0.062;
            CurRight[114] = 0.082; CurRight[115] = 0.035; CurRight[116] = 0.090; CurRight[117] = 0.032; CurRight[118] = 0.095; CurRight[119] = 0.022;
            CurRight[120] = 0.116; CurRight[121] = 0.032; CurRight[122] = 0.087; CurRight[123] = 0.035; CurRight[124] = 0.024; CurRight[125] = 0.106;
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        } 
        case 10:{
            Dim = 12;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for (int i = 0; i != 6; i++){
                CurLeft[i] = 0.2;
                CurRight[i] = 1; 
            }
            for (int i = 6; i != Dim; i++){
                CurLeft[i] = -180;
                CurRight[i] = 180; 
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        } 
        case 11:{
            Dim = 120;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for(int i = 0; i < 120;)
            {
                CurLeft[i] = 10;
                CurRight[i] = 75;
                i++;
                CurLeft[i] = 20;
                CurRight[i] = 125;
                i++;
                CurLeft[i] = 30;
                CurRight[i] = 175;
                i++;
                CurLeft[i] = 40;
                CurRight[i] = 250;
                i++;
                CurLeft[i] = 50;
                CurRight[i] = 300;
                i++;
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 12:{
            Dim = 216;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for(int i = 0; i < 216;)
            {
                CurLeft[i] = 150;
                CurRight[i] = 470;
                i++;
                CurLeft[i] = 135;
                CurRight[i] = 460;
                i++;
                CurLeft[i] = 73;
                CurRight[i] = 340;
                i++;
                CurLeft[i] = 60;
                CurRight[i] = 300;
                i++;
                CurLeft[i] = 73;
                CurRight[i] = 243;
                i++;
                CurLeft[i] = 57;
                CurRight[i] = 160;
                i++;
                CurLeft[i] = 20;
                CurRight[i] = 130;
                i++;
                CurLeft[i] = 47;
                CurRight[i] = 120;
                i++;
                CurLeft[i] = 20;
                CurRight[i] = 80;
                i++;
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 13:{
            Dim = 6;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            CurLeft[0] = 100; CurLeft[1] = 50; CurLeft[2] = 80; CurLeft[3] = 50; CurLeft[4] = 50; CurLeft[5] = 50; 
            CurRight[0] = 500; CurRight[1] = 200; CurRight[2] = 300; CurRight[3] = 150; CurRight[4] = 200; CurRight[5] = 120;
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }  
        case 14:{
            Dim = 13;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            CurLeft[0] = 0; CurLeft[1] = 0; CurLeft[2] = 0; CurLeft[3] = 60; CurLeft[4] = 60; CurLeft[5] = 60; CurLeft[6] = 60; CurLeft[7] = 60; CurLeft[8] = 60;
            CurLeft[9] = 40; CurLeft[10] = 40; CurLeft[11] = 55; CurLeft[12] = 55; 
            CurRight[0] = 680; CurRight[1] = 360; CurRight[2] = 360; CurRight[3] = 180; CurRight[4] = 180; CurRight[5] = 180; CurRight[6] = 180; CurRight[7] = 180; CurRight[8] = 180;
            CurRight[9] = 120; CurRight[10] = 120; CurRight[11] = 120; CurRight[12] = 120;
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 15:{
            Dim = 15;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            CurLeft[0] = 150; CurLeft[1] = 150; CurLeft[2] = 20; CurLeft[3] = 20; CurLeft[4] = 150; CurLeft[5] = 135; CurLeft[6] = 135; CurLeft[7] = 60; CurLeft[8] = 25;
            CurLeft[9] = 25; CurLeft[10] = 20; CurLeft[11] = 20; CurLeft[12] = 25; CurLeft[13] = 15; CurLeft[14] = 15; 
            CurRight[0] = 455; CurRight[1] = 455; CurRight[2] = 130; CurRight[3] = 130; CurRight[4] = 470; CurRight[5] = 460; CurRight[6] = 465; CurRight[7] = 300; CurRight[8] = 162;
            CurRight[9] = 160; CurRight[10] = 80; CurRight[11] = 80; CurRight[12] = 85; CurRight[13] = 55; CurRight[14] = 55;
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }    
        case 16:{
            Dim = 40;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            CurLeft[0] = 36; CurLeft[1] = 36; CurLeft[2] = 60; CurLeft[3] = 80; CurLeft[4] = 47; CurLeft[5] = 68; CurLeft[6] = 110; CurLeft[7] = 135; CurLeft[8] = 135; CurLeft[9] = 130;
            CurLeft[10] = 94; CurLeft[11] = 94; CurLeft[12] = 125; CurLeft[13] = 125; CurLeft[14] = 125;  CurLeft[15] = 125; CurLeft[16] = 220; CurLeft[17] = 220;  CurLeft[18] = 242; CurLeft[19] = 242;
            CurLeft[20] = 254; CurLeft[21] = 254; CurLeft[22] = 254; CurLeft[23] = 254; CurLeft[24] = 254; CurLeft[25] = 254; CurLeft[26] = 10; CurLeft[27] = 10; CurLeft[28] = 10; CurLeft[29] = 47; 
            CurLeft[30] = 60; CurLeft[31] = 60; CurLeft[32] = 60; CurLeft[33] = 90; CurLeft[34] = 90; CurLeft[35] = 90; CurLeft[36] = 25; CurLeft[37] = 25; CurLeft[38] = 25; CurLeft[39] = 242;
            CurRight[0] = 114; CurRight[1] = 114; CurRight[2] = 120; CurRight[3] = 190; CurRight[4] = 97; CurRight[5] = 140; CurRight[6] = 300; CurRight[7] = 300; CurRight[8] = 300; CurRight[9] = 300;
            CurRight[10] = 375; CurRight[11] = 375; CurRight[12] = 500; CurRight[13] = 500; CurRight[14] = 500; CurRight[15] = 500; CurRight[16] = 500; CurRight[17] = 500; CurRight[18] = 550; CurRight[19] = 550;
            CurRight[20] = 550; CurRight[21] = 550; CurRight[22] = 550; CurRight[23] = 550; CurRight[24] = 550; CurRight[25] = 550; CurRight[26] = 150; CurRight[27] = 150; CurRight[28] = 150; CurRight[29] = 97;
            CurRight[30] = 190; CurRight[31] = 190; CurRight[32] = 190; CurRight[33] = 200; CurRight[34] = 200; CurRight[35] = 200; CurRight[36] = 110; CurRight[37] = 110; CurRight[38] = 110; CurRight[39] = 550;
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }  
        case 17:{
            Dim = 140;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            CurLeft[0] = 71; CurLeft[1] = 120; CurLeft[2] = 125; CurLeft[3] = 125; CurLeft[4] = 90; CurLeft[5] = 90; CurLeft[6] = 280; CurLeft[7] = 280; CurLeft[8] = 260; CurLeft[9] = 260;
            CurLeft[10] = 260; CurLeft[11] = 260; CurLeft[12] = 260; CurLeft[13] = 260; CurLeft[14] = 260;  CurLeft[15] = 260; CurLeft[16] = 260; CurLeft[17] = 260;  CurLeft[18] = 260; CurLeft[19] = 260;
            CurLeft[20] = 260; CurLeft[21] = 260; CurLeft[22] = 260; CurLeft[23] = 260; CurLeft[24] = 280; CurLeft[25] = 280; CurLeft[26] = 280; CurLeft[27] = 280; CurLeft[28] = 260; CurLeft[29] = 260; 
            CurLeft[30] = 260; CurLeft[31] = 260; CurLeft[32] = 260; CurLeft[33] = 260; CurLeft[34] = 260; CurLeft[35] = 260; CurLeft[36] = 120; CurLeft[37] = 120; CurLeft[38] = 423; CurLeft[39] = 423;
            CurLeft[40] = 3; CurLeft[41] = 3; CurLeft[42] = 160; CurLeft[43] = 160; CurLeft[44] = 160; CurLeft[45] = 160; CurLeft[46] = 160; CurLeft[47] = 160; CurLeft[48] = 160; CurLeft[49] = 160;
            CurLeft[50] = 165; CurLeft[51] = 165; CurLeft[52] = 165; CurLeft[53] = 165; CurLeft[54] = 180; CurLeft[55] = 180; CurLeft[56] = 103; CurLeft[57] = 198; CurLeft[58] = 100; CurLeft[59] = 153;
            CurLeft[60] = 163; CurLeft[61] = 95; CurLeft[62] = 160; CurLeft[63] = 160; CurLeft[64] = 196; CurLeft[65] = 196; CurLeft[66] = 196; CurLeft[67] = 196; CurLeft[68] = 130; CurLeft[69] = 130;
            CurLeft[70] = 137; CurLeft[71] = 137; CurLeft[72] = 195; CurLeft[73] = 175; CurLeft[74] = 175; CurLeft[75] = 175; CurLeft[76] = 175; CurLeft[77] = 330; CurLeft[78] = 160; CurLeft[79] = 160;
            CurLeft[80] = 200; CurLeft[81] = 56; CurLeft[82] = 115; CurLeft[83] = 115; CurLeft[84] = 115; CurLeft[85] = 207; CurLeft[86] = 207; CurLeft[87] = 175; CurLeft[88] = 175; CurLeft[89] = 175;
            CurLeft[90] = 175; CurLeft[91] = 360; CurLeft[92] = 415; CurLeft[93] = 795; CurLeft[94] = 795; CurLeft[95] = 578; CurLeft[96] = 615; CurLeft[97] = 612; CurLeft[98] = 612; CurLeft[99] = 758;
            CurLeft[100] = 755; CurLeft[101] = 750; CurLeft[102] = 750; CurLeft[103] = 713; CurLeft[104] = 718; CurLeft[105] = 791; CurLeft[106] = 786; CurLeft[107] = 795; CurLeft[108] = 795; CurLeft[109] = 795;
            CurLeft[110] = 795; CurLeft[111] = 94; CurLeft[112] = 94; CurLeft[113] = 94; CurLeft[114] = 244; CurLeft[115] = 244; CurLeft[116] = 244; CurLeft[117] = 95; CurLeft[118] = 95; CurLeft[119] = 116;
            CurLeft[120] = 175; CurLeft[121] = 2; CurLeft[122] = 4; CurLeft[123] = 15; CurLeft[124] = 9; CurLeft[125] = 12; CurLeft[126] = 10; CurLeft[127] = 112; CurLeft[128] = 4; CurLeft[129] = 5;
            CurLeft[130] = 5; CurLeft[131] = 50; CurLeft[132] = 5; CurLeft[133] = 42; CurLeft[134] = 42; CurLeft[135] = 41; CurLeft[136] = 17; CurLeft[137] = 7; CurLeft[138] = 7; CurLeft[139] = 26;
            
            CurRight[0] = 119; CurRight[1] = 189; CurRight[2] = 190; CurRight[3] = 190; CurRight[4] = 190; CurRight[5] = 190; CurRight[6] = 490; CurRight[7] = 490; CurRight[8] = 496; CurRight[9] = 496;
            CurRight[10] = 496; CurRight[11] = 496; CurRight[12] = 506; CurRight[13] = 509; CurRight[14] = 506; CurRight[15] = 505; CurRight[16] = 506; CurRight[17] = 506; CurRight[18] = 505; CurRight[19] = 505;
            CurRight[20] = 505; CurRight[21] = 505; CurRight[22] = 505; CurRight[23] = 505; CurRight[24] = 537; CurRight[25] = 537; CurRight[26] = 549; CurRight[27] = 549; CurRight[28] = 501; CurRight[29] = 501;
            CurRight[30] = 506; CurRight[31] = 506; CurRight[32] = 506; CurRight[33] = 506; CurRight[34] = 500; CurRight[35] = 500; CurRight[36] = 241; CurRight[37] = 241; CurRight[38] = 774; CurRight[39] = 769;
            CurRight[40] = 19; CurRight[41] = 28; CurRight[42] = 250; CurRight[43] = 250; CurRight[44] = 250; CurRight[45] = 250; CurRight[46] = 250; CurRight[47] = 250; CurRight[48] = 250; CurRight[49] = 250;
            CurRight[50] = 504; CurRight[51] = 504; CurRight[52] = 504; CurRight[53] = 504; CurRight[54] = 471; CurRight[55] = 561; CurRight[56] = 341; CurRight[57] = 617; CurRight[58] = 312; CurRight[59] = 471;
            CurRight[60] = 500; CurRight[61] = 302; CurRight[62] = 511; CurRight[63] = 511; CurRight[64] = 490; CurRight[65] = 490; CurRight[66] = 490; CurRight[67] = 490; CurRight[68] = 432; CurRight[69] = 432;
            CurRight[70] = 455; CurRight[71] = 455; CurRight[72] = 541; CurRight[73] = 536; CurRight[74] = 540; CurRight[75] = 538; CurRight[76] = 540; CurRight[77] = 574; CurRight[78] = 531; CurRight[79] = 531;
            CurRight[80] = 542; CurRight[81] = 132; CurRight[82] = 245; CurRight[83] = 245; CurRight[84] = 245; CurRight[85] = 307; CurRight[86] = 307; CurRight[87] = 345; CurRight[88] = 345; CurRight[89] = 345;
            CurRight[90] = 345; CurRight[91] = 580; CurRight[92] = 645; CurRight[93] = 984; CurRight[94] = 978; CurRight[95] = 682; CurRight[96] = 720; CurRight[97] = 718; CurRight[98] = 720; CurRight[99] = 964;
            CurRight[100] = 958; CurRight[101] = 1007; CurRight[102] = 1006; CurRight[103] = 1013; CurRight[104] = 1020; CurRight[105] = 954; CurRight[106] = 952; CurRight[107] = 1006; CurRight[108] = 1013; CurRight[109] = 1021;
            CurRight[110] = 1015; CurRight[111] = 203; CurRight[112] = 203; CurRight[113] = 203; CurRight[114] = 379; CurRight[115] = 379; CurRight[116] = 379; CurRight[117] = 190; CurRight[118] = 189; CurRight[119] = 194;
            CurRight[120] = 321; CurRight[121] = 19; CurRight[122] = 59; CurRight[123] = 83; CurRight[124] = 53; CurRight[125] = 37; CurRight[126] = 34; CurRight[127] = 373; CurRight[128] = 20; CurRight[129] = 38;
            CurRight[130] = 19; CurRight[131] = 98; CurRight[132] = 10; CurRight[133] = 74; CurRight[134] = 74; CurRight[135] = 105; CurRight[136] = 51; CurRight[137] = 19; CurRight[138] = 19; CurRight[139] = 40;
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }  
        case 18:{
            Dim = 96;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for(int i = 0; i < 96;)
            {
                CurLeft[i] = 5;

                CurRight[i] = 15;
                i++;
                CurLeft[i] = 6;
                CurRight[i] = 15;
                i++;
                CurLeft[i] = 10;
                CurRight[i] = 30;
                i++;
                CurLeft[i] = 13;
                CurRight[i] = 25;
                i++;
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 19:{
            Dim = 96;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for(int i = 0; i < 96;)
            {
                CurLeft[i] = 5;
                CurRight[i] = 15;
                i++;
                CurLeft[i] = 6;
                CurRight[i] = 15;
                i++;
                CurLeft[i] = 10;
                CurRight[i] = 30;
                i++;
                CurLeft[i] = 13;
                CurRight[i] = 25;
                i++;
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 20:{
            Dim = 96;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            for(int i = 0; i < 96;)
            {
                CurLeft[i] = 5;
                CurRight[i] = 15;
                i++;
                CurLeft[i] = 6;
                CurRight[i] = 15;
                i++;
                CurLeft[i] = 10;
                CurRight[i] = 30;
                i++;
                CurLeft[i] = 13;
                CurRight[i] = 25;
                i++;
            }
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
        case 21:{
            Dim = 26;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            CurLeft[0] = 1900; CurLeft[1] = 2.5; CurLeft[2] = 0; CurLeft[3] = 0; CurLeft[4] = 100; CurLeft[5] = 100; CurLeft[6] = 100; CurLeft[7] = 100; CurLeft[8] = 100;
            CurLeft[9] = 100; CurLeft[10] = 0.01; CurLeft[11] = 0.01; CurLeft[12] = 0.01; CurLeft[13] = 0.01; CurLeft[14] = 0.01; CurLeft[15] = 0.01; CurLeft[16] = 1.1; CurLeft[17] = 1.1;
            CurLeft[18] = 1.05; CurLeft[19] = 1.05; CurLeft[20] = 1.05; CurLeft[21] = -PI; CurLeft[22] = -PI; CurLeft[23] = -PI; CurLeft[24] = -PI; CurLeft[25] = -PI; 

            CurRight[0] = 2300; CurRight[1] = 4.05; CurRight[2] = 1; CurRight[3] = 1; CurRight[4] = 500; CurRight[5] = 500; CurRight[6] = 500; CurRight[7] = 500; CurRight[8] = 500;
            CurRight[9] = 600; CurRight[10] = 0.99; CurRight[11] = 0.99; CurRight[12] = 0.99; CurRight[13] = 0.99; CurRight[14] = 0.99; CurRight[15] = 0.99; CurRight[16] = 6; CurRight[17] = 6;
            CurRight[18] = 6; CurRight[19] = 6; CurRight[20] = 6; CurRight[21] = PI; CurRight[22] = PI; CurRight[23] = PI; CurRight[24] = PI; CurRight[25] = PI; 
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }   
       case 22:{
            Dim = 22;
            CurLeft = new double[Dim];
            CurRight = new double[Dim];
            CurLeft[0] = -1000; CurLeft[1] = 3; CurLeft[2] = 0; CurLeft[3] = 0; CurLeft[4] = 100; CurLeft[5] = 100; CurLeft[6] = 30; CurLeft[7] = 400; CurLeft[8] = 800;
            CurLeft[9] = 0.01; CurLeft[10] = 0.01; CurLeft[11] = 0.01; CurLeft[12] = 0.01; CurLeft[13] = 0.01; CurLeft[14] = 1.05; CurLeft[15] = 1.05; CurLeft[16] = 1.15; CurLeft[17] = 1.7;
            CurLeft[18] = -PI; CurLeft[19] = -PI; CurLeft[20] = -PI; CurLeft[21] = -PI; 

            CurRight[0] = 0; CurRight[1] = 5; CurRight[2] = 1; CurRight[3] = 1; CurRight[4] = 400; CurRight[5] = 500; CurRight[6] = 300; CurRight[7] = 1600; CurRight[8] = 2200;
            CurRight[9] = 0.9; CurRight[10] = 0.9; CurRight[11] = 0.9; CurRight[12] = 0.9; CurRight[13] = 0.9; CurRight[14] = 6; CurRight[15] = 6; CurRight[16] = 6.5; CurRight[17] = 291;
            CurRight[18] = PI; CurRight[19] = PI; CurRight[20] = PI; CurRight[21] = PI; 
            return_info.Dim = Dim;
            return_info.CurRight = CurRight;
            return_info.CurLeft = CurLeft;
            return return_info;
        }
    }
}

class Optimizer {
public:
	bool FitNotCalculated;
	double F;
	double F2;
	double Cr;
	int Int_ArchiveSizeParam;
	int MemorySize;
	int MemoryIter;
	int SuccessFilled;
	int MemoryCurrentIndex;

	int NVars;
	int NInds;
	int NIndsMax;
	int NIndsMin;

	double bestfit;
	int besti;

	int func_num;
	int TheChosenOne;
	int Generation;
	double ArchiveSizeParam;
	double psize;
	double psizeParam;
	int ArchiveSize;
	int CurrentArchiveSize;
	double ArchiveProb;

	double* Donor;
	double* Trial;
	int* Rands;

	double** Popul;
	double** PopulTemp;
	double* FitMass;
	double* FitMassTemp;
	double* FitMassCopy;
	double* BestInd;
	int* Indexes;
	double** Archive;
	double* FitMassArch;

	double* tempSuccessCr;
	double* tempSuccessF;

	double Right;
	double Left;

	double* MemoryCr;
	double* MemoryF;
	double* FitDelta;

	

	double CEC11(double* HostVector, int func_num);
	void Initialize(int newNInds, int newNVars, int func_num,
		double NewArchSizeParam, double NewArchiveProbParam, double NewPSize, double* CurRight, double* CurLeft);
	void Clean();
//	void MainCycle(ofstream& outFile, ofstream& outFile1);
	void MainCycle(ofstream& outFile, Info return_info);
	void FindNSaveBest(bool init);

	void PSO_MoveP();
	void PSO_UpdateBests(int TheChosenOne);

	void CopyToArchive(double* RefusedParent, double RefusedFitness);
	void SaveSuccessCrF(double Cr, double F, double FitD);
	void UpdateMemoryCrF();
	double MeanWL(double* Vector, double* TempWeights, int Size);
	void RemoveWorst(int NInds, int NewNInds);

	int GetImprState();
	bool GetFitState();

	int SelectWorst();
	int SelectBest();
};
double Optimizer::CEC11(double* HostVector, int func_num) {
    switch(func_num){
    case 1:{ 
        cost_function1(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    }
    case 2:{ 
        cost_function2(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;        
        return objective_value[0];
    } 
    case 3:{ 
        cost_function3(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];             
    }
    case 4:{ 
        cost_function4(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 5:{ 
        cost_function5(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 6:{ 
        cost_function6(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 7:{ 
        cost_function7(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 8:{ 
        cost_function8(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 9:{ 
        cost_function9(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 10:{ 
        cost_function10(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 11:{ 
        cost_function11_5(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 12:{ 
        cost_function11_10(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 13:{ 
        cost_function12_6(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 14:{ 
        cost_function12_13(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 15:{ 
        cost_function12_15(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 16:{ 
        cost_function12_40(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 17:{ 
        cost_function12_140(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 18:{ 
        cost_function13_1(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 19:{ 
        cost_function13_2(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 20:{ 
        cost_function13_3(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    }  
    case 21:{ 
        cost_function14(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    } 
    case 22:{ 
        cost_function15(HostVector, objective_value);
        NFEval++;
        if (isnan(objective_value[0]))
            objective_value[0] = 3.0e31;
        return objective_value[0];
    }                        
    }
}
void Optimizer::Initialize(int newNInds, int newNVars, int newfunc_num,
	double NewArchSizeParam, double NewArchiveProbParam, double NewPSize, double* CurRight, double* CurLeft) {
	FitNotCalculated = true;
	NInds = newNInds;
	NIndsMax = NInds;
	NIndsMin = 4;
	NVars = newNVars;
	//Left = -100;
	//Right = 100;
	Cr = 0.5;
	F = 0.8;
	besti = 0;
	Generation = 0;
	TheChosenOne = 0;
	CurrentArchiveSize = 0;
	psizeParam = NewPSize;
	ArchiveSizeParam = NewArchSizeParam;
	Int_ArchiveSizeParam = ceil(ArchiveSizeParam);
	ArchiveSize = NIndsMax * ArchiveSizeParam;
	ArchiveProb = NewArchiveProbParam;
	func_num = newfunc_num;

	Popul = new double* [NIndsMax];
	for (int i = 0; i != NIndsMax; i++)
		Popul[i] = new double[NVars];
	PopulTemp = new double* [NIndsMax];
	for (int i = 0; i != NIndsMax; i++)
		PopulTemp[i] = new double[NVars];
	Archive = new double* [NIndsMax * Int_ArchiveSizeParam];
	for (int i = 0; i != NIndsMax * Int_ArchiveSizeParam; i++)
		Archive[i] = new double[NVars];
	FitMassArch = new double[NIndsMax * Int_ArchiveSizeParam];
	FitMass = new double[NIndsMax];
	FitMassTemp = new double[NIndsMax];
	FitMassCopy = new double[NIndsMax];
	Indexes = new int[NIndsMax];
	BestInd = new double[NVars];

	for (int i = 0; i < NIndsMax; i++)
		for (int j = 0; j < NVars; j++)
			Popul[i][j] = Random(CurLeft[j], CurRight[j]);

	Donor = new double[NVars];
	Trial = new double[NVars];
	Rands = new int[NIndsMax];

	tempSuccessCr = new double[NIndsMax];
	tempSuccessF = new double[NIndsMax];
	FitDelta = new double[NIndsMax];
	deltadiv = new double[10];

	for (int i = 0; i != NIndsMax; i++) {
		tempSuccessCr[i] = 0;
		tempSuccessF[i] = 0;
	}

	MemorySize = 5;
	MemoryIter = 0;
	SuccessFilled = 0;

	MemoryCr = new double[MemorySize];
	MemoryF = new double[MemorySize];
	for (int i = 0; i != MemorySize; i++) {
		MemoryCr[i] = 0.8 + 0.0 * Random(0, 1);
		MemoryF[i] = 0.3 + 0.0 * Random(0, 1);
	}
}
void Optimizer::SaveSuccessCrF(double Cr, double F, double FitD) {
	tempSuccessCr[SuccessFilled] = Cr;
	tempSuccessF[SuccessFilled] = F;
	FitDelta[SuccessFilled] = FitD;
	SuccessFilled++;
}
void Optimizer::UpdateMemoryCrF() {
	if (SuccessFilled != 0) {
		double Old_F = MemoryF[MemoryIter];
		double Old_Cr = MemoryCr[MemoryIter];
		double tempmax = tempSuccessCr[0];
		for (int i = 0; i != SuccessFilled; i++)
			if (tempSuccessCr[i] > tempmax)
				tempmax = tempSuccessCr[i];
		if (MemoryCr[MemoryIter] == -1 || tempmax == 0)
			MemoryCr[MemoryIter] = -1;
		else
		{
			MemoryCr[MemoryIter] = (MeanWL(tempSuccessCr, FitDelta, SuccessFilled) + Old_Cr) / 2.0;  // strategy  5
			MemoryF[MemoryIter] = (MeanWL(tempSuccessF, FitDelta, SuccessFilled) + Old_F) / 2.0;
		}
		MemoryIter++;
		if (MemoryIter >= MemorySize)
			MemoryIter = 0;
	}
}
double Optimizer::MeanWL(double* Vector, double* TempWeights, int Size) {
	double SumWeight = 0;
	double SumSquare = 0;
	double Sum = 0;
	for (int i = 0; i != SuccessFilled; i++)
		SumWeight += TempWeights[i];
	double* Weights = new double[SuccessFilled];

	for (int i = 0; i != SuccessFilled; i++)
		Weights[i] = TempWeights[i] / SumWeight;
	for (int i = 0; i != SuccessFilled; i++)
		SumSquare += Weights[i] * Vector[i] * Vector[i];
	for (int i = 0; i != SuccessFilled; i++)
		Sum += Weights[i] * Vector[i];
	delete Weights;
	if (fabs(Sum) > 0.000001)
		return SumSquare / Sum;
	else
		return 0.5;
}


void Optimizer::CopyToArchive(double* RefusedParent, double RefusedFitness) {
	if (CurrentArchiveSize < ArchiveSize) {
		for (int i = 0; i != NVars; i++)
			Archive[CurrentArchiveSize][i] = RefusedParent[i];
		FitMassArch[CurrentArchiveSize] = RefusedFitness;
		CurrentArchiveSize++;
	}
	else {
		int RandomNum = IntRandom(ArchiveSize);
		for (int i = 0; i != NVars; i++)
			Archive[RandomNum][i] = RefusedParent[i];
		FitMassArch[RandomNum] = RefusedFitness;
	}
}
void Optimizer::FindNSaveBest(bool init) {
	if (FitMass[TheChosenOne] <= bestfit || init) {
		bestfit = FitMass[TheChosenOne];
		besti = TheChosenOne;
		for (int j = 0; j != NVars; j++)
			BestInd[j] = Popul[besti][j];
	}

	if (bestfit < globalbest){
		globalbest = bestfit;
		gbi = besti;
	}
}
void Optimizer::RemoveWorst(int NInds, int NewNInds) {
	int PointsToRemove = NInds - NewNInds;
	for (int L = 0; L != PointsToRemove; L++) {
		double WorstFit = FitMass[0];
		int WorstNum = 0;
		for (int i = 1; i != NInds; i++) {
			if (FitMass[i] > WorstFit) {
				WorstFit = FitMass[i];
				WorstNum = i;
			}
		}
		for (int i = WorstNum; i != NInds - 1; i++) {
			for (int j = 0; j != NVars; j++)
				Popul[i][j] = Popul[i + 1][j];
			FitMass[i] = FitMass[i + 1];
		}
	}
}
//void Optimizer::MainCycle(ofstream& outFile, ofstream& outFile1) {
void Optimizer::MainCycle(ofstream& outFile, Info return_info) {
	for (int TheChosenOne = 0; TheChosenOne != NInds; TheChosenOne++)
	{
		FitMass[TheChosenOne] = CEC11(Popul[TheChosenOne], func_num);
		FindNSaveBest(TheChosenOne == 0);
		if (!globalbestinit || bestfit < globalbest) {
			globalbest = bestfit;
			globalbestinit = true;
		}
		if (NFEval % 100 == 0) {
			double temp = globalbest - fopt[0];
			if (temp <= 10E-8)
				temp = 0;
			outFile << temp << ",";
		}
	}
//	outFile1 << divv << ",";
	
	do {
		Generation++;
		double minfit = FitMass[0];
		double maxfit = FitMass[0];
		int prand;
		minfit = FitMass[0];
		maxfit = FitMass[0];
		for (int i = 0; i != NInds; i++) {
			FitMassCopy[i] = FitMass[i];
			Indexes[i] = i;
			if (FitMass[i] >= maxfit)
				maxfit = FitMass[i];
			if (FitMass[i] <= minfit)
				minfit = FitMass[i];
		}
		if (minfit != maxfit)
			qSort2int(FitMassCopy, Indexes, 0, NInds - 1);
		FitTemp.resize(NInds);
    	for (int i = 0; i != NInds; i++){
    		FitTemp[i] = 3.0 * (NInds - i); //  strategy  1
    	}
		std::discrete_distribution<int> ComponentSelector(FitTemp.begin(), FitTemp.end());

		psize = psizeParam; //  strategy  C3

		int psizeval = NInds * psize;
		if (psizeval <= 1)
			psizeval = 2;

		deltafit = 0;
		for (int TheChosenOne = 0; TheChosenOne != NInds; TheChosenOne++) {
			MemoryCurrentIndex = IntRandom(MemorySize + 1);
			do
				prand = Indexes[IntRandom(psizeval)];
			while (prand == TheChosenOne && (double)NFEval / (double)MaxFEval < 0.5);

			int Rand1;
			int Rand2;
			do{
				Rand1 = Indexes[ComponentSelector(generator_uni_i_2)];    //  strategy  1
			
			}while (Rand1 == prand);
			do
				Rand2 = Indexes[ComponentSelector(generator_uni_i_2)];
			while (Rand2 == prand || Rand2 == Rand1);
			do {
				if (MemoryCurrentIndex < MemorySize)
					F = CachyRand(MemoryF[MemoryCurrentIndex], 0.1);
				else
				{
					F = CachyRand(0.9, 0.1);   // strategy  3
				}
			} while (F < 0.0);
			if (F > 1.0)
				F = 1.0;

			 	if ((double)NFEval / (double)MaxFEval < 0.6 && F > 0.7)  // streagy  4
			         F = 0.7;
				

			F2 = 1.0 * F;


			if (Random(0, 1) < (double)CurrentArchiveSize / ((double)CurrentArchiveSize + (double)NInds)) {
				Rand2 = IntRandom(CurrentArchiveSize);
				for (int j = 0; j != NVars; j++) {
					Donor[j] = Popul[TheChosenOne][j] +
						F2 * (Popul[prand][j] - Popul[TheChosenOne][j]) +
						F * (Popul[Rand1][j] - Archive[Rand2][j]);
				}
			}
			else {
				for (int j = 0; j != NVars; j++) {
					Donor[j] = Popul[TheChosenOne][j] +
						F2 * (Popul[prand][j] - Popul[TheChosenOne][j]) +
						F * (Popul[Rand1][j] - Popul[Rand2][j]);
				}
			}
			

			int WillCrossover = IntRandom(NVars);
			if (MemoryCurrentIndex < MemorySize) {
				if (MemoryCr[MemoryCurrentIndex] < 0)
					Cr = 0;
				else
					Cr = NormRand(MemoryCr[MemoryCurrentIndex], 0.1);
			}
			else
			{
                Cr = NormRand(0.9, 0.1);  // strategy  3
			}
			if (Cr >= 1)
				Cr = 1;
			if (Cr <= 0)
				Cr = 0;
			if ((double)NFEval / (double)MaxFEval < 0.25)  // strategy  4
			    Cr = max(Cr, 0.7);
			if ((double)NFEval / (double)MaxFEval < 0.5)
			    Cr = max(Cr, 0.6);
				   //iSHADE_RSP
				jumping_rate = 0.2;

				bool perturbation = rand() / (double)RAND_MAX < jumping_rate;  // strategy  2
			
            //**对头部个体进行交叉因子的自适应放大处理，以减少最优个体陷入局部最优的可能
			if(TheChosenOne == gbi){
				double a = NFEval;
				double b = 2*MaxFEval;
				Cr = Cr*a/b;
			}	

			for (int j = 0; j != NVars; j++) {
				if (Random(0, 1) < Cr || WillCrossover == j)
					PopulTemp[TheChosenOne][j] = Donor[j];
				else
					PopulTemp[TheChosenOne][j] = perturbation ? CachyRand(Popul[TheChosenOne][j], 0.1) : Popul[TheChosenOne][j];
			}

			FindLimits(PopulTemp[TheChosenOne], Popul[TheChosenOne], NVars, return_info.CurLeft, return_info.CurRight);
			FitTemp[TheChosenOne] = CEC11(PopulTemp[TheChosenOne], func_num);
			if (FitTemp[TheChosenOne] <= globalbest){
				globalbest = FitTemp[TheChosenOne];
                GBI = TheChosenOne;//**记录最优个体序号
            }
			if (FitTemp[TheChosenOne] <= FitMass[TheChosenOne]){
				SaveSuccessCrF(Cr, F, fabs(FitMass[TheChosenOne] - FitTemp[TheChosenOne]));
				deltafit = deltafit + 1;
			}
			if (NFEval % 100 == 0) {
				double temp = globalbest - fopt[0];
				//if (temp <= 10E-8)
				//	temp = 0;
				outFile << temp << ",";
			}
		}
		gbi = GBI;//**记录最优个体序号
		
	//	cout << divvts << endl;
	//	outFile1 << divv << ","; 

		for (int TheChosenOne = 0; TheChosenOne != NInds; TheChosenOne++) {
			if (FitTemp[TheChosenOne] <= FitMass[TheChosenOne]) {
				CopyToArchive(Popul[TheChosenOne], FitMass[TheChosenOne]);
				for (int j = 0; j != NVars; j++){
					Popul[TheChosenOne][j] = PopulTemp[TheChosenOne][j];
				}
				FitMass[TheChosenOne] = FitTemp[TheChosenOne];
			}
		}

		int newNInds = int(double(NIndsMin - NIndsMax) / MaxFEval * NFEval + NIndsMax);
		if (newNInds < NIndsMin)
			newNInds = NIndsMin;
		if (newNInds > NIndsMax)
			newNInds = NIndsMax;
		int newArchSize = double(MaxFEval - NFEval) / (double)MaxFEval * (ArchiveSizeParam * (NIndsMax - NIndsMin));
		if (newArchSize < NIndsMin)
			newArchSize = NIndsMin;
		ArchiveSize = newArchSize;
		if (CurrentArchiveSize >= ArchiveSize)
			CurrentArchiveSize = ArchiveSize;
		RemoveWorst(NInds, newNInds);
		NInds = newNInds;
		UpdateMemoryCrF();
		SuccessFilled = 0;
	} while (NFEval < MaxFEval);
}
void Optimizer::Clean() {
	delete Donor;
	delete Trial;
	delete Rands;
	for (int i = 0; i != NIndsMax; i++) 
	{
		delete Popul[i];
		delete PopulTemp[i];
	}
	for (int i = 0; i != NIndsMax * Int_ArchiveSizeParam; i++)
	{
		delete Archive[i];
	}
	delete Archive;
	delete Popul;
	delete PopulTemp;
	delete FitMass;
	delete FitMassTemp;
	delete FitMassCopy;
	delete BestInd;
	delete Indexes;
	delete tempSuccessCr;
	delete tempSuccessF;
	delete MemoryCr;
	delete MemoryF;
}
int main() {
	if(Initial_CEC2011_Cost_Function() != _NO_ERROR){
       	cout<<"Error for initial CEC2011"<<endl;
        return 0;
    }
	cout << "Random seeds are:" << endl;
	cout << seed1 << "\t" << seed2 << "\t" << seed3 << "\t" << seed4 << "\t" << seed5 << "\n";
	clock_t starttime,endtime;

	//for (int GNVarsIter = 0; GNVarsIter != 4; GNVarsIter++) {
	//int GNVarsIter = 0; {

		/*if (GNVarsIter == 0)
			GNVars = 10;
		if (GNVarsIter == 1)
			GNVars = 30;
		if (GNVarsIter == 2)
			GNVars = 50;
		if (GNVarsIter == 3)
			GNVars = 100;
		MaxFEval = GNVars * 10000;
		cout << "Run D_" << GNVars << "\n";
		Optimizer OptZ;
		double* xopt = new double[GNVars];*/

		starttime = clock();
		for (int func_num = 1; func_num < 23; func_num++) {
            Info return_info;
            Optimizer OptZ;
            return_info = GetInfo(func_num);
            int GNVars = return_info.Dim;
            MaxFEval = return_info.Dim * 10000;
			stringstream ss;
			string pro;
			pro = to_string(func_num);
			ss << GNVars;
			string tmp(ss.str());
			string fileNameStr = "SMLDE_F" + pro + ".csv";
		//	string fileNameStr1 = "Div_D" + tmp + "p" + pro + ".csv";
			char fileName[500];
			strcpy(fileName, fileNameStr.c_str());
		//	strcpy(fileName, fileNameStr1.c_str());
			cout << fileNameStr << "" << fileName;
		//	cout << fileNameStr1 << "" << fileName;
			ofstream outFile;
			outFile.open(fileNameStr, ios::app);
		//	ofstream outFile1;
		//	outFile1.open(fileNameStr1, ios::app);


			ofstream fout(buffer);
			for (int RunN = 0; RunN != 51; RunN++) {
				cout << RunN << "\t";
				//GetOptimum(func_num, xopt, fopt);
				globalbestinit = false;
				initfinished = false;
				LastFEcount = 0;
				NFEval = 0;
				double NewPopSize = int(18 * GNVars);  // strategy  B1
				double NewArchSize = 1.0;
				double NewArchProb = 0.25;
				double NewPsize = 0.11;  // strategy  C3
				OptZ.Initialize(NewPopSize, GNVars, func_num, NewArchSize, NewArchProb, NewPsize, return_info.CurRight, return_info.CurLeft);
		//		OptZ.MainCycle(outFile, outFile1);
				OptZ.MainCycle(outFile, return_info);
				OptZ.Clean();
			}
			cout << endl;
		}
		endtime = clock();
		ofstream fout_t("time.txt", ios::app);
		fout_t <<" D" << GNVars <<" Algorithm complexity is " << (double)(endtime - starttime) / CLOCKS_PER_SEC << "s" << endl;
		//fout_t << "fo_rate" << fo_rate <<" D" << GNVars <<" Algorithm complexity is " << (double)(endtime - starttime) / CLOCKS_PER_SEC << "s" << endl;
		cout << endl;
		//delete xopt;
	//}
	return 0;
}
