/*#Paper:  Serial Multilevel-learned Differential Evolution with Adaptive Control of Exploration and Exploitation
All the code of the SMLDE is contained in "SMLDE.cpp" file.
Compilation is simple using gcc/g++:
g++ SMLDE.cpp -o SMLDE.exe -std=c++11 -O3 -march=corei7-avx -fexpensive-optimizations -fomit-frame-pointer
Please note that the compilation requires support of C++11 standard. 
You may omit everything after "-O3", however, these options give a significant boost on most systems.
This will create SMLDE.exe, available for running.
Next, the main optimization loop will be started, writing data to "SMLDE_(DIM)_(F).csv", 
where F and DIM are the function number and problem dimension. */

#include <cmath>
#include <time.h>
#include <iomanip>
#include <vector>
#include <cstring>
#include <sstream>
#include <fstream>
#include <iostream>
#include <random>

#include "cec17_test_func.cpp"

using namespace std;//使用 using namespace std; 指令将 std 命名空间的所有内容引入到程序中，这样就可以直接使用 std 命名空间中的所有类型和函数了。
unsigned globalseed = unsigned(time(NULL));//定义了一个 unsigned 类型的全局变量 globalseed，并使用 time(NULL) 函数获取当前时间（以秒为单位）。其中，time 函数是 C 库中的一个函数，可以获取当前时间（以秒为单位）。
//unsigned globalseed = 2018;
unsigned seed1 = globalseed + 0;//定义五个随机种子
unsigned seed2 = globalseed + 100;
unsigned seed3 = globalseed + 200;
unsigned seed4 = globalseed + 300;
unsigned seed5 = globalseed + 400;
std::mt19937 generator_uni_i(seed1);//定义了五个 std::mt19937 类型的变量，并使用指定的随机数种子来初始化这些变量。
std::mt19937 generator_uni_r(seed2);//std::mt19937 是 C++ 标准库中的一个类型，表示用于生成伪随机数的生成器。
std::mt19937 generator_norm(seed3);
std::mt19937 generator_cachy(seed4);
std::mt19937 generator_uni_i_2(seed5);
std::uniform_int_distribution<int> uni_int(0, 32768);//生成整数的均匀分布随机数
std::uniform_real_distribution<double> uni_real(0.0, 1.0);//生成实数的均匀分布随机数。
std::normal_distribution<double> norm_dist(0.0, 1.0);//定义了一个 std::normal_distribution 对象 norm_dist，用于生成正态分布随机数
std::cauchy_distribution<double> cachy_dist(0.0, 1.0);//定义了一个 std::cauchy_distribution 对象 cachy_dist，用于生成柯西分布随机数 
double jumping_rate = 0.3;  // 设置跳跃率
double c = 0.5;  // 设置自适应比例

//返回一个在 [0, target) 范围内的整数均匀分布随机数
int IntRandom(int target) {
	if (target == 0)
		return 0;
	return uni_int(generator_uni_i) % target;
}
//返回一个在 [minimal, maximal] 范围内的实数均匀分布随机数
double Random(double minimal, double maximal) {
	return uni_real(generator_uni_r) * (maximal - minimal) + minimal;
}
//返回一个正态分布随机数,mu 参数指定正态分布的均值，sigma 参数指定正态分布的标准差
double NormRand(double mu, double sigma) {
	return norm_dist(generator_norm) * sigma + mu;
}
//返回一个柯西分布随机数。mu 参数指定柯西分布的中心位置，sigma 参数指定柯西分布的尖峰宽度
double CachyRand(double mu, double sigma) {
	return cachy_dist(generator_cachy) * sigma + mu;
}
//快速排序
void qSort2int(double* Mass, int* Mass2, int low, int high) {
	int i = low;
	int j = high;
	double x = Mass[(low + high) >> 1];
	do {
		while (Mass[i] < x) ++i;
		while (Mass[j] > x) --j;
		if (i <= j) {
			double temp = Mass[i];
			Mass[i] = Mass[j];
			Mass[j] = temp;
			double temp2 = Mass2[i];
			Mass2[i] = Mass2[j];
			Mass2[j] = temp2;
			i++;
			j--;
		}
	} while (i <= j);
	if (low < j) qSort2int(Mass, Mass2, low, j);
	if (i < high) qSort2int(Mass, Mass2, i, high);
}

void cec17_test_func(double*, double*, int, int, int);
double* OShift, * M, * y, * z, * x_bound;
int ini_flag = 0, n_flag, func_flag, * SS;
int GNVars;//记录当前问题的维度数
double ResultsArray[51][14];//用于存放记录结果的数组，一个运行51次，每次运行都会显示14个层阶的当前最优
int LastFEcount;
int NFEval = 0;//当前评价次数
int MaxFEval = 0;//最大评价次数
double tempF[1];//记录评价后的适应度
double fopt[1];
char buffer[30];
double globalbest;//记录全局最优
int gbi;//**记录全局最优个体的序号
int GBI;//**
bool globalbestinit;//判断是否是初始情况
bool initfinished;//初始化完成判断
vector<double> FitTemp;
//打开一个文件，读取该文件中的数据并将其存储到 xopt 数组中。然后调用评价函数来计算并返回 fopt
void GetOptimum(int func_num, double* xopt, double* fopt) {
	FILE* fpt;
	char FileName[30];
	sprintf(FileName, "input_data/shift_data_%d.txt", func_num);
	fpt = fopen(FileName, "r");
	if (fpt == NULL)
		printf("\n Error: Cannot open input file for reading \n");
	for (int k = 0; k < GNVars; k++)
		fscanf(fpt, "%lf", &xopt[k]);
	fclose(fpt);
	cec17_test_func(xopt, fopt, GNVars, 1, func_num);
}
//边界检测
void FindLimits(double* Ind, double* Parent, int CurNVars, double CurLeft, double CurRight) {
	for (int j = 0; j < CurNVars; j++) {
		if (Ind[j] < CurLeft)
			Ind[j] = (CurLeft + Parent[j]) / 2.0;
		if (Ind[j] > CurRight)
			Ind[j] = (CurRight + Parent[j]) / 2.0;
	}
}
class Optimizer {
public:
	bool FitNotCalculated;//不计算适应度？？
	double F;//扰动因子，用于控制变异的强度。
	double F2;
	double Ft;//最优个体的扰动因子，用于强化头部的开发效果
	double Cr;//交叉概率，用于控制来自父代个体的基因片段在新生成的个体中被保留的概率。
	int Int_ArchiveSizeParam;
	int MemorySize;
	int MemoryIter;
	int SuccessFilled;//成功记录次数
	int MemoryCurrentIndex;//当前内存索引

	int NVars;//维度
	int NInds;//种群中个体数量，中转变换用
	int NIndsMax;//种群中最大个体数量
	int NIndsMin;//最小种群个体数

	double bestfit;	   //最优适应度
	int besti;         //记录当前最优个体序号

	int func_num;      //测试问题序号
	int TheChosenOne;  //选择的个体序号
	int Generation;    //代数
	double ArchiveSizeParam;//档案尺寸参数
	double psize;      //种群尺寸
	double psizeParam; //种群尺寸参数
	int ArchiveSize;        //档案尺寸
	int CurrentArchiveSize; //当前存档大小
	double ArchiveProb;

	double* Donor;//记录每个个体的各个维度的数据
	double* Trial;
	int* Rands;

	double** Popul;//二维数组，记录种群所有个体信息,NIndsMax 行 NVars 列，初始化种群的存放数组
	double** PopulTemp;//二维数组，NIndsMax 行 NVars 列，记录种群所有个体信息
	double* FitMass;//保存种群个体的所有适应度
	double* FitMassTemp;//父子两代适应度交接过渡数组，保存变异交叉后的新个体
	double* FitMassCopy;//保存所有适应度的排序版本
	double* BestInd;//一维数组，保存当前最优个体信息
	int* Indexes;
	double** Archive;//外部存档。"NIndsMax * Int_ArchiveSizeParam" 行"NVars" 列
	double* FitMassArch;

	double* tempSuccessCr;
	double* tempSuccessF;

	double Right;
	double Left;

	double* MemoryCr;
	double* MemoryF;
	double* FitDelta;
//用来初始化优化器。
	void Initialize(int newNInds, int newNVars, int func_num,
		double NewArchSizeParam, double NewArchiveProbParam, double NewPSize);
	void Clean();//用来清空优化器的状态信息
	void MainCycle(ofstream& outFile);//是优化器的主循环，它在每一代中执行。
	void FindNSaveBest(bool init);//用来找到最优解并将其保存下来。

	void PSO_MoveP();//用来更新粒子的位置的。
	void PSO_UpdateBests(int TheChosenOne);//用来更新粒子的最优解

	void CopyToArchive(double* RefusedParent, double RefusedFitness);//用来将某一个解拷贝到存档。
	void SaveSuccessCrF(double Cr, double F, double FitD);//用来保存成功的 F 和 Cr 参数以及适应度差。
	void UpdateMemoryCrF();//用来更新 F 和 Cr 的内存。
	double MeanWL(double* Vector, double* TempWeights, int Size);//用来计算加权平均值。
	void RemoveWorst(int NInds, int NewNInds);//用来移除某一些解。

	int GetImprState();//返回优化器的改进状态
	bool GetFitState();//返回优化器的收敛状态。

	int SelectWorst();//用来选择最差的解
	int SelectBest();//用来选择最优的解。
};
//评价函数
double cec_17_(double* HostVector, int func_num) {
	cec17_test_func(HostVector, tempF, GNVars, 1, func_num);
	NFEval++;
	return tempF[0];
}
//这是 Optimizer 类的一个成员函数，用于初始化种群
void Optimizer::Initialize(int newNInds, int newNVars, int newfunc_num,
	double NewArchSizeParam, double NewArchiveProbParam, double NewPSize) {
	FitNotCalculated = true;
	NInds = newNInds;//中转获取新的种群个体数
	NIndsMax = NInds;//作为最大种群个体数
	NIndsMin = 4;//最小种群个体数
	NVars = newNVars;//记录维度数
	Left = -100;//左右边界值
	Right = 100;
	Cr = 0.5;
	F = 0.8;
	Ft=0.8;
	besti = 0;//记录当前最优个体序号
	Generation = 0;//代数
	TheChosenOne = 0;//选择的个体序号
	CurrentArchiveSize = 0;//当前档案使用了的尺寸
	psizeParam = NewPSize;//种群尺寸参数
	ArchiveSizeParam = NewArchSizeParam;//赋值档案尺寸参数
	Int_ArchiveSizeParam = ceil(ArchiveSizeParam);//档案尺寸参数向上取整
	ArchiveSize = NIndsMax * ArchiveSizeParam;//档案尺寸=最大种群数*档案参数
	ArchiveProb = NewArchiveProbParam;//记录新档案参数
	func_num = newfunc_num;//记录新函数序号
//为二维数组分配内存,这两个数组分别有 NIndsMax 行 NVars 列。然后使用一个循环为这两个数组的每一行分配内存
	Popul = new double* [NIndsMax];
	for (int i = 0; i != NIndsMax; i++)
		Popul[i] = new double[NVars];
	PopulTemp = new double* [NIndsMax];
	for (int i = 0; i != NIndsMax; i++)
		PopulTemp[i] = new double[NVars];

    //这段代码创建了一个二维数组 "Archive"，大小为 "NIndsMax * Int_ArchiveSizeParam" 行，"NVars" 列。每一行都是一个一维数组，用 "new double[NVars]" 分配内存。
	Archive = new double* [NIndsMax * Int_ArchiveSizeParam];
	for (int i = 0; i != NIndsMax * Int_ArchiveSizeParam; i++)
		Archive[i] = new double[NVars];
	FitMassArch = new double[NIndsMax * Int_ArchiveSizeParam];
	FitMass = new double[NIndsMax];
	FitMassTemp = new double[NIndsMax];
	FitMassCopy = new double[NIndsMax];
	Indexes = new int[NIndsMax];
	BestInd = new double[NVars];//创建数组保存当前最优个体的全部维度信息
//随机对初始种群赋值，这段代码使用两重循环对 Popul 数组的每一个元素进行赋值，赋的值是一个随机数，范围是从 Left 到 Right。
	for (int i = 0; i < NIndsMax; i++)
		for (int j = 0; j < NVars; j++)
			Popul[i][j] = Random(Left, Right);

	Donor = new double[NVars];//保存中转当前个体的所有维度信息
	Trial = new double[NVars];
	Rands = new int[NIndsMax];

	tempSuccessCr = new double[NIndsMax];
	tempSuccessF = new double[NIndsMax];
	FitDelta = new double[NIndsMax];
//初值赋0
	for (int i = 0; i != NIndsMax; i++) {
		tempSuccessCr[i] = 0;
		tempSuccessF[i] = 0;
	}

	MemorySize = 5;// H 记忆内存尺寸
	MemoryIter = 0;
	SuccessFilled = 0;//成功记录次数初始化

	MemoryCr = new double[MemorySize];//全是0.8
	MemoryF = new double[MemorySize];//全是0.3
	for (int i = 0; i != MemorySize; i++) {
		MemoryCr[i] = 0.8 + 0.0 * Random(0, 1);
		MemoryF[i] = 0.3 + 0.0 * Random(0, 1);
	}
}
//将成功时的参数 Cr、F 和 FitD（适应度差） 存储在三个临时数组中
void Optimizer::SaveSuccessCrF(double Cr, double F, double FitD) {
	tempSuccessCr[SuccessFilled] = Cr;
	tempSuccessF[SuccessFilled] = F;
	FitDelta[SuccessFilled] = FitD;
	SuccessFilled++;
}
//更新 MemoryCr 和 MemoryF 两个数组的值
void Optimizer::UpdateMemoryCrF() {//首先检查 SuccessFilled 变量是否等于 0。如果 SuccessFilled 不等于 0，则代码执行一些操作来更新 MemoryCr 和 MemoryF 数组的值。
	if (SuccessFilled != 0) {//存储 MemoryF 数组以及 MemoryCr 数组中当前元素的值
		double Old_F = MemoryF[MemoryIter];
		double Old_Cr = MemoryCr[MemoryIter];
		double tempmax = tempSuccessCr[0];//使用一个循环来找到 tempSuccessCr 数组中的最大值
		for (int i = 0; i != SuccessFilled; i++)//如果 MemoryCr 数组中当前元素的值为 -1 或者 tempSuccessCr 数组中的最大值为 0，则将 MemoryCr 数组中当前元素的值设置为 -1。
			if (tempSuccessCr[i] > tempmax)//否则，将 MemoryCr 数组中当前元素的值设置为 tempSuccessCr 数组的加权平均值。然后，将 MemoryF 数组中当前元素的值设置为 tempSuccessF 数组的加权平均值。
				tempmax = tempSuccessCr[i];
		if (MemoryCr[MemoryIter] == -1 || tempmax == 0)
			MemoryCr[MemoryIter] = -1;
		else
			MemoryCr[MemoryIter] = (MeanWL(tempSuccessCr, FitDelta, SuccessFilled) + Old_Cr) / 2.0;  // strategy  5
			MemoryF[MemoryIter] = (MeanWL(tempSuccessF, FitDelta, SuccessFilled) + Old_F) / 2.0;
		MemoryIter++;//最后，代码将 MemoryIter 变量加 1。如果 MemoryIter 大于等于 MemorySize，则将 MemoryIter 设置为 0。
		if (MemoryIter >= MemorySize)
			MemoryIter = 0;
	}
}
//计算 Vector 数组的加权平均值,其中 TempWeights 数组中的每个元素都是 Vector 数组中对应元素的权重。
double Optimizer::MeanWL(double* Vector, double* TempWeights, int Size) {
	double SumWeight = 0;
	double SumSquare = 0;
	double Sum = 0;
    //首先计算 TempWeights 数组中所有元素的和，然后使用一个循环来计算 TempWeights 数组中所有元素的相对权重
	for (int i = 0; i != SuccessFilled; i++)
		SumWeight += TempWeights[i];
	double* Weights = new double[SuccessFilled];

	for (int i = 0; i != SuccessFilled; i++)
		Weights[i] = TempWeights[i] / SumWeight;
	for (int i = 0; i != SuccessFilled; i++)
		SumSquare += Weights[i] * Vector[i] * Vector[i];
	for (int i = 0; i != SuccessFilled; i++)
		Sum += Weights[i] * Vector[i];
	delete Weights;//然后，它使用两个循环来计算加权平方和和加权和。最后，它使用这两个值来计算加权平均值。
	if (fabs(Sum) > 0.000001)//如果加权和的绝对值大于 0.000001，则函数返回加权平方和除以加权和的值。否则，函数返回 0.5。
		return SumSquare / Sum;
	else
		return 0.5;
}
//将 RefusedParent 和 RefusedFitness 拷贝到一个名为 Archive 的二维数组中。如果 CurrentArchiveSize 小于 ArchiveSize，那么就将 RefusedParent 和 RefusedFitness 添加到 Archive 的末尾，并将 CurrentArchiveSize 加 1。如果 CurrentArchiveSize 等于 ArchiveSize，那么就从 Archive 中随机选择一个位置进行覆盖
void Optimizer::CopyToArchive(double* RefusedParent, double RefusedFitness) {
	if (CurrentArchiveSize < ArchiveSize) {
		for (int i = 0; i != NVars; i++)
			Archive[CurrentArchiveSize][i] = RefusedParent[i];
		FitMassArch[CurrentArchiveSize] = RefusedFitness;
		CurrentArchiveSize++;
	}
	else {
		int RandomNum = IntRandom(ArchiveSize);
		for (int i = 0; i != NVars; i++)
			Archive[RandomNum][i] = RefusedParent[i];
		FitMassArch[RandomNum] = RefusedFitness;
	}
}
//查找并保存最优的解决方案。
//该函数首先检查当前选定个体的适应度是否小于等于当前最优的适应度，或者是否是初始化时的情况。如果是，那么就将当前选定的方案的适应度赋值给 bestfit，将当前选定个体的编号赋值给 besti，并将当前选定个体的信息拷贝到 BestInd 数组中
void Optimizer::FindNSaveBest(bool init) {//然后，函数会将当前最优的适应度与全局最优适应度进行比较。如果当前最优适应度小于全局最优适应度，那么就将当前最优适应度赋值给全局最优适应度
	if (FitMass[TheChosenOne] <= bestfit || init) {
		bestfit = FitMass[TheChosenOne];
		besti = TheChosenOne;
		for (int j = 0; j != NVars; j++)
			BestInd[j] = Popul[besti][j];
	}
	if (bestfit < globalbest){
		globalbest = bestfit;
		gbi = besti;
	}
		
}
//从一个名为 Popul 的二维数组中删除适应度最差的解决方案。
//该函数首先计算出需要删除的方案数量，即 NInds - NewNInds。然后，它会进行一个循环，在每一轮循环中找到适应度最差的方案，并将其从 Popul 中删除。为了找到适应度最差的方案，它会遍历 FitMass 数组，找到适应度最大的方案编号，然后将这个方案从 Popul 中删除。
void Optimizer::RemoveWorst(int NInds, int NewNInds) {
	int PointsToRemove = NInds - NewNInds;
	for (int L = 0; L != PointsToRemove; L++) {
		double WorstFit = FitMass[0];
		int WorstNum = 0;
		for (int i = 1; i != NInds; i++) {
			if (FitMass[i] > WorstFit) {
				WorstFit = FitMass[i];
				WorstNum = i;
			}
		}
		for (int i = WorstNum; i != NInds - 1; i++) {
			for (int j = 0; j != NVars; j++)
				Popul[i][j] = Popul[i + 1][j];
			FitMass[i] = FitMass[i + 1];
		}
	}
}
//算法主体
void Optimizer::MainCycle(ofstream& outFile) {
	//首先，在一个循环中遍历所有个体，对每个个体都计算它的适应度，并将其保存在数组 FitMass 中。然后使用函数 FindNSaveBest 更新最佳个体的值，并使用函数 SaveBestValues 保存最佳个体的值
    for (int TheChosenOne = 0; TheChosenOne != NInds; TheChosenOne++)
	{
		FitMass[TheChosenOne] = cec_17_(Popul[TheChosenOne], func_num);//计算当前代适应度,并保存
		FindNSaveBest(TheChosenOne == 0);
		if (!globalbestinit || bestfit < globalbest) {
			globalbest = bestfit;
			globalbestinit = true;
		}
		if (NFEval % 100 == 0) {
			double temp = globalbest - fopt[0];
			if (temp <= 10E-8)
				temp = 0;
			outFile << temp << ",";
		}
	}
    //接下来进入一个无限循环，在循环内部，首先会对数组 FitMass 中的所有元素求最小值和最大值，并将数组 FitMassCopy 和数组 Indexes 赋值为 FitMass 的副本。然后使用快速排序算法将数组 FitMassCopy 按升序排序，同时记录下排序后数组中每个元素的原始下标
	do {
		double minfit = FitMass[0];
		double maxfit = FitMass[0];
		int prand;
		minfit = FitMass[0];
		maxfit = FitMass[0];
        //复制FitMass数组中的值到FitMassCopy数组，并将索引值存放在Indexes数组中。
		for (int i = 0; i != NInds; i++) {
			FitMassCopy[i] = FitMass[i];
			Indexes[i] = i;
            //从FitMass数组中找出最大值和最小值，并将它们存放在minfit和maxfit变量中
			if (FitMass[i] >= maxfit)
				maxfit = FitMass[i];
			if (FitMass[i] <= minfit)
				minfit = FitMass[i];
		}
        //如果minfit和maxfit不同，调用 qSort2int() 函数对 Fitness Mass Copy 数组进行排序
		if (minfit != maxfit)
			qSort2int(FitMassCopy, Indexes, 0, NInds - 1);
		//接着，会定义一个名为 FitTemp 的数组，并将其初始化为所有元素的值都是 3。然后定义一个名为 ComponentSelector 的分布，它的参数是数组 FitTemp 的迭代器
        FitTemp.resize(NInds);
		for (int i = 0; i != NInds; i++)
			FitTemp[i] = 3.0 * (NInds - i);
        //FitTemp.begin()和FitTemp.end()是一个包含若干个整数的容器，用于在给定范围内随机抽取值
		std::discrete_distribution<int> ComponentSelector(FitTemp.begin(), FitTemp.end());

		psize = psizeParam; //  strategy  C3

		int psizeval = NInds * psize;
		if (psizeval <= 1)
			psizeval = 2;
        //此循环进行变异交叉操作
		for (int TheChosenOne = 0; TheChosenOne != NInds; TheChosenOne++) {
			MemoryCurrentIndex = IntRandom(MemorySize + 1);//生成一个随机整数，介于 0 到 MemorySize 之间的一个值，然后将其存储到 MemoryCurrentIndex 中
			do//从Indexes数组中随机取出一个元素保存到prand，一直循环，直到它与TheChosenOne的值不相等，或者当前评价次数已超过一半，即NFEval/ MaxFEval的值大于0.5为止
				prand = Indexes[IntRandom(psizeval)];
			while (prand == TheChosenOne && (double)NFEval / (double)MaxFEval < 0.5);

			int Rand1;//不等于prand
			int Rand2;//不等于prand或Rand1
			do//生成一个名为Rand1的随机数,从Indexes数组中通过ComponentSelector（generator_uni_li_2）函数获得
				Rand1 = Indexes[ComponentSelector(generator_uni_i_2)];    //  strategy  1
			while (Rand1 == prand);//如果Rand1的值与prand的值相同，则该操作将重复直到它生成一个不同的值。
			do//从数组Indexes中选择一个随机组件，使它不等于prand或Rand1
				Rand2 = Indexes[ComponentSelector(generator_uni_i_2)];
			while (Rand2 == prand || Rand2 == Rand1);//使用generator_uni_i_2作为随机数发生器，并将其结果分配给Rand2
			do {//如果当前内存索引（MemoryCurrentIndex）小于内存大小（MemorySize），就使用一个内存F数组（MemoryF）的元素作为门限，并且用0.1作为通常偏移量
				if (MemoryCurrentIndex < MemorySize)
					F = CachyRand(MemoryF[MemoryCurrentIndex], 0.1);
				else// 否则，使用0.9作为门限，用0.1作为通常偏移量
					F = CachyRand(0.9, 0.1);   // strategy  3
			} while (F < 0.0);//保障F大于0.0
			if (F > 1.0)//如果F的值高于1.0，则将它的值限制为1.0
				F = 1.0;
			     if ((double)NFEval / (double)MaxFEval < 0.6 && F > 0.7)  //在前期，设置最高值0.7，避免产生不变异的情况
			         F = 0.7;//如果NFEval和MaxFEval的比值小于0.6，且F的值高于0.7，就将F的值限制为0.7.
			
			/*对头部个体进行扰动因子的自适应缩小处理，以加强最优个体的开发能力
			if(TheChosenOne == gbi){
				double a = NFEval;
				double b = MaxFEval;
				Ft = 1-a/b;
				F = F*Ft;
			}	*/
			F2 = 1.0 * F;

//变异，如果随机数小于(当前存档数/(当前存档数+种群个体数))
			if (Random(0, 1) < (double)CurrentArchiveSize / ((double)CurrentArchiveSize + (double)NInds)) {
				Rand2 = IntRandom(CurrentArchiveSize);//随机生成一个（0~当前存档数）内的一个随机数
				for (int j = 0; j != NVars; j++) {
//变异后的新个体的第j个维度数据=上一代的数据 + F2*(随机挑选个体第j个维度数据-当前个体第j个维度数据) + F*(另一个随机个体第j个维度数据-外部存档的随机个体第j个维度数据)
					Donor[j] = Popul[TheChosenOne][j] +
						F2 * (Popul[prand][j] - Popul[TheChosenOne][j]) +
						F * (Popul[Rand1][j] - Archive[Rand2][j]);
				}
			}
			else {
				for (int j = 0; j != NVars; j++) {
//变异后的新个体的第j个维度数据=上一代的数据 + F2*(随机挑选个体第j个维度数据-当前个体第j个维度数据) + F*(R1个体第j个维度数据-R2个体第j个维度数据)
					Donor[j] = Popul[TheChosenOne][j] +
						F2 * (Popul[prand][j] - Popul[TheChosenOne][j]) +
						F * (Popul[Rand1][j] - Popul[Rand2][j]);
				}
			}
			FindLimits(Donor, Popul[TheChosenOne], NVars, Left, Right);//边界检测

			int WillCrossover = IntRandom(NVars);//随机挑选交叉序号，避免没有交叉情况
			if (MemoryCurrentIndex < MemorySize) {//如果还在索引范围内
				if (MemoryCr[MemoryCurrentIndex] < 0)//限制边界
					Cr = 0;
				else
					Cr = NormRand(MemoryCr[MemoryCurrentIndex], 0.1);//交叉因子选取正态分布随机数
			}
			else
				Cr = NormRand(0.9, 0.1);  //交叉因子选取正态分布随机数
            //限制边界
			if (Cr >= 1)
				Cr = 1;
			if (Cr <= 0)
				Cr = 0;

			      if ((double)NFEval / (double)MaxFEval < 0.25)  //运行前四分之一时Cr不小于0.7
			         Cr = max(Cr, 0.7);
			      if ((double)NFEval / (double)MaxFEval < 0.5)   //运行四分之一到前一半时Cr不小于0.6
			         Cr = max(Cr, 0.6);
				   //iSHADE_RSP
			bool perturbation = rand() / (double)RAND_MAX < jumping_rate;  //定义一个布尔变量perturbation，它的值由一个随机数除以RAND_MAX，再和jumping_rate进行比较，如果随机数小于jumping_rate则为true，否则为false
			
			/*对头部个体进行交叉因子的自适应放大处理，以减少最优个体陷入局部最优的可能
			if(TheChosenOne == gbi){
				double a = NFEval;
				double b = MaxFEval;
				Cr = Cr*(a/b)*c;
				
			}	*/

			//开始进行交叉操作
			for (int j = 0; j != NVars; j++) {
				if (Random(0, 1) < Cr || WillCrossover == j)//当随机数小于 Cr 或者 WillCrossover 等于 j 时，防止没有交叉
					PopulTemp[TheChosenOne][j] = Donor[j];//用PopulTemp记录变异后的个体
				else// 否则，如果 perturbation 为 true，PopulTemp记录柯西分布随机数；如果 perturbation 为 false，PopulTemp记录Popul[TheChosenOne][j]即原种群个体。
					PopulTemp[TheChosenOne][j] = perturbation ? CachyRand(Popul[TheChosenOne][j], 0.1) : Popul[TheChosenOne][j];
			}
			FitTemp[TheChosenOne] = cec_17_(PopulTemp[TheChosenOne], func_num);//评价次数加一，计算新一代的适应度，并保存在FitTemp
			if (FitTemp[TheChosenOne] <= globalbest)//将新生代的适应度和全局最优解做比较
			{
				globalbest = FitTemp[TheChosenOne];//若优，则取代全局最优解,记录序号
				GBI = TheChosenOne;//**记录最优个体序号
			}
				
			if (FitTemp[TheChosenOne] <= FitMass[TheChosenOne])//将新生代的适应度和前代适应度做比较
				SaveSuccessCrF(Cr, F, fabs(FitMass[TheChosenOne] - FitTemp[TheChosenOne]));//若优，则将Cr，F，这两代的适应度差的绝对值保存起来，说明本次优化成功，成功次数加一
			if (NFEval % 100 == 0) {
				double temp = globalbest - fopt[0];
				if (temp <= 10E-8)
					temp = 0;
				outFile << temp << ",";
			}
		}
		gbi = GBI;//**记录最优个体序号
        //选择层，保存更优个体，将淘汰个体存入外部存档
		for (int TheChosenOne = 0; TheChosenOne != NInds; TheChosenOne++) {
			if (FitTemp[TheChosenOne] <= FitMass[TheChosenOne]) {//若新生代的适应度优于父代适应度
				CopyToArchive(Popul[TheChosenOne], FitMass[TheChosenOne]);//则保存淘汰的父代个体和适应度到外部存档中
				for (int j = 0; j != NVars; j++)//新生更优个体更替父代淘汰的个体
					Popul[TheChosenOne][j] = PopulTemp[TheChosenOne][j];
				FitMass[TheChosenOne] = FitTemp[TheChosenOne];//更替适应度
			}
		}
        //减少种群个体数，但不小于最小种群数，不大于最大种群数
		int newNInds = int(double(NIndsMin - NIndsMax) / MaxFEval * NFEval + NIndsMax);
		if (newNInds < NIndsMin)
			newNInds = NIndsMin;
		if (newNInds > NIndsMax)
			newNInds = NIndsMax;
        //改变存档尺寸
		int newArchSize = double(MaxFEval - NFEval) / (double)MaxFEval * (ArchiveSizeParam * (NIndsMax - NIndsMin));
		if (newArchSize < NIndsMin)
			newArchSize = NIndsMin;
		ArchiveSize = newArchSize;
        //当前的存档数不得大于存档尺寸
		if (CurrentArchiveSize >= ArchiveSize)
			CurrentArchiveSize = ArchiveSize;
		RemoveWorst(NInds, newNInds);//删除最差的多余的种群个体，再更新种群个体数
		NInds = newNInds;
		UpdateMemoryCrF();
		SuccessFilled = 0;//本次迭代的成功次数归零，准备下一次迭代
		Generation++;//代数加1，准备下一次迭代
	} while (NFEval < MaxFEval);
}
//这段代码是清理Optimizer类的部分，也就是在每次优化过程之前把内存中的变量回收，以避免可能的内存泄漏。 具体地，它释放了所有分配给Donor，Trial，Rands和Popul， PopulTemp，Archive，FitMass，FitMassTemp，FitMassCopy，BestInd，Indexes，tempSuccessCr， tempSuccessF，FitDelta，MemoryCr和MemoryF的内存
void Optimizer::Clean() {
	delete Donor;
	delete Trial;
	delete Rands;
	for (int i = 0; i != NIndsMax; i++) {
		delete Popul[i];
		delete PopulTemp[i];
	}
	for (int i = 0; i != NIndsMax * Int_ArchiveSizeParam; i++)
		delete Archive[i];
	delete Archive;
	delete Popul;
	delete PopulTemp;
	delete FitMass;
	delete FitMassTemp;
	delete FitMassCopy;
	delete BestInd;
	delete Indexes;
	delete tempSuccessCr;
	delete tempSuccessF;
	delete FitDelta;
	delete MemoryCr;
	delete MemoryF;
}
//主程序
int main() {
	cout << "Random seeds are:" << endl;//首先输出了一行文本 "Random seeds are:" 和 5 个随机数种子 seed1、seed2、seed3、seed4 和 seed5 的值
	cout << seed1 << "\t" << seed2 << "\t" << seed3 << "\t" << seed4 << "\t" << seed5 << "\n";
	clock_t starttime,endtime;
	
    //循环4次，分别是10，30，50，100三个维度时的情况
	for (int GNVarsIter = 1; GNVarsIter != 2; GNVarsIter++) {
	//int GNVarsIter = 1; {

		if (GNVarsIter == 0)
			GNVars = 10;
		if (GNVarsIter == 1)
			GNVars = 30;
		if (GNVarsIter == 2)
			GNVars = 50;
		if (GNVarsIter == 3)
			GNVars = 100;
		MaxFEval = GNVars * 10000;//最大评价次数
		cout << "Run D_" << GNVars << "\n"; //输出运行的信息，当前的问题维度
		Optimizer OptZ;                     //创建一个 Optimizer 类的对象 OptZ
		double* xopt = new double[GNVars];  //根据 GNVars 的值动态分配内存并初始化 xopt 数组，表示优化的结果

		starttime = clock();
        //一共30个测试问题，分别进行优化测试
		for (int func_num = 1; func_num < 3; func_num++) {

			stringstream ss;
			string pro;
			pro = to_string(func_num);
			ss << GNVars;
			string tmp(ss.str());
			string fileNameStr = "SMLDE_D" + tmp + "_F" + pro + ".csv";
			char fileName[500];
			strcpy(fileName, fileNameStr.c_str());
			cout << fileNameStr << "" << fileName;
			ofstream outFile;
			outFile.open(fileNameStr, ios::app);

			ofstream fout(buffer);
			for (int RunN = 0; RunN != 3; RunN++) {
				cout << RunN << "\t";               //输出当前次数
				GetOptimum(func_num, xopt, fopt);   //获取数据信息保存到数组中
				globalbestinit = false;
				initfinished = false;
				LastFEcount = 0;
				NFEval = 0;
				double NewPopSize = int(18 * GNVars);  // strategy  B1
				double NewArchSize = 1.0;
				double NewArchProb = 0.25;
				double NewPsize = 0.11;  // strategy  C3
				OptZ.Initialize(NewPopSize, GNVars, func_num, NewArchSize, NewArchProb, NewPsize);
				OptZ.MainCycle(outFile);//优化主体
				OptZ.Clean();//清空
			}
			cout << endl;
		}
		endtime = clock();
		ofstream fout_t("time.txt", ios::app);
		fout_t <<" D" << GNVars <<" Algorithm complexity is " << (double)(endtime - starttime) / CLOCKS_PER_SEC << "s" << endl;
		//fout_t << "fo_rate" << fo_rate <<" D" << GNVars <<" Algorithm complexity is " << (double)(endtime - starttime) / CLOCKS_PER_SEC << "s" << endl;
		cout << endl;
		delete xopt;//清空数组准备下次循环
	}
	return 0;
}