  % the main.m
clc
clear
format compact;
%%
% Global parameters setting

D = 30;
FES = 1 * 10^4 * D;
val_2_reach = 10^(-8);
%CEC2005 include 25 functions
%CEC2011 include 22 functions
%CEC2013 include 28 functions
%CEC2014 include 30 functions
%CEC2017 include 30 functions
benchmark = 2017;
problemIndex = [1];

runTime = 2;
analysisChart = [];
addpath('../');
for f = problemIndex
    resultChart = [];
    problem = f;
    func_flag = f ;
    t = 1;
    nFES = 0;
    optimum = f * 100.0;
    while t <= runTime
        optimalChart = [];
        ProblemSize = D;
        PbestRate = 0.1;
        popuSize = 18*ProblemSize;
        rd = 0.5;
        c = 0.7;
        Ar = 1.4;
        Ms = 5;
        l = 2;
        wn1 = 0;
        wn2 = 0;
        wn3 = 0;
        
        % program start here
        MAX_PopSize = popuSize;
        MIN_PopSize = 4.0;
        nFES = 0;
        % Population initialization
        [popu, lu, o, A, M, a, alpha, b] = Initialization(popuSize, D, benchmark, f);% inicialize a new popu
        D = size(popu,2);
        [popu2, lu, o, A, M, a, alpha, b] = Initialization(popuSize, D, benchmark, f);% inicialize a new popu
        D = size(popu2,2);  % find the D through sizing popu
        PopOld = popu;
        Pop = PopOld;
        PopOld2 = popu2;
        % Population evaluation
        [popuFitness] = Evaluation(Pop, benchmark, f);                              
        Fitness = popuFitness;
        Fitness = Fitness';        
        popuFitness = popuFitness';
        gBestFit = 1e+30;
        BciSolution = zeros(1, ProblemSize);
        for i = 1 : popuSize
            nFES = nFES + 1;
            if Fitness(i) < gBestFit
                gBestFit = Fitness(i);
                BciSolution = Pop(i, :);
            end
        end
        optimal = min(popuFitness);
        optimalChart = [optimalChart;repmat(optimal,popuSize,1)]; 
        record(1) = min(popuFitness);
        %==========================================================================
        MemCI = c .* ones(Ms, 1);
        MemRD = rd .* ones(Ms, 1);
        MemI = 1;
        Arch.NP = Ar * popuSize;
        Arch.Pop = zeros(0, ProblemSize);
        Arch.OF = zeros(0, 1);
        %==========================================================================
        mkdir traj
        
        G=1;
        tic
        while nFES < FES               
             G = G + 1;
            %% Search machine
            algorithmDir = 'SSAP';
            searchMachine = @SSAP;
            [PopOld2, Pop, popu, ci, Arch, MemI, rd,ks,n,p] = searchMachine(PopOld, PopOld2, Fitness, MemCI, MemRD, MemI, popuSize, PbestRate, Ms, Arch, ProblemSize,l);
            
            
            %% Boundary detection
            [popu] = BoundaryDetection(popu,lu);
            
            
            %% Population evaluation
            [popuFitness] = Evaluation(popu, benchmark, f);
            popuFitness = popuFitness';

            
            
            %% Update pBest
             i1BestFit = 1e+30;
             i2BestFit = 1e+30;   
            for w = 1 : size(ks,1)
                if popuFitness(ks) < i1BestFit
                    i1BestFit = popuFitness(ks);
                end
            end
            
            same_p1Fitness = popuFitness;
            popuFitness(ks) = 0;
            p1Fitness = find(popuFitness); 
            notks_size = popuSize -  size(ks,1);
            for k = 1 : notks_size
                if p1Fitness(k) < i2BestFit
                    i2BestFit = p1Fitness(k);
                end
            end
            if i2BestFit < i1BestFit
                wn1 = wn1 + 1;
            else 
                wn1 = wn1 - 1;
            end

                ei1 = 30 + wn2*wn2;

                ei2 = -30 - wn3*wn3;

            if wn1 == ei1
                l = l+1;
                wn2 = wn2 + 1;
                wn1 = 0;
            elseif wn1 == ei2
                if l <= 2
                    l = (l+1)/l;
                    l = vpa(l,2);
                    wn3 = wn3 + 1;
                    wn1 = 0;
                else
                    l = l-1;
                    wn3 = wn3 + 1;
                    wn1 = 0;
                end
            end

          popuFitness = same_p1Fitness;
            
            for i = 1 : popuSize
                nFES = nFES + 1;
                if popuFitness(i) < gBestFit
                    gBestFit = popuFitness(i);
                    BciSolution = popu(i, :);
                    optimal = gBestFit;
                end           
                if nFES == FES; break; end
            end
            optimalChart = [optimalChart;repmat(optimal,popuSize,1)];
             i1BestFit = 1e+30;
             i2BestFit = 1e+30; 
            %%===================================================================
            dif = abs(Fitness - popuFitness);
            I = (Fitness > popuFitness);%
            GdRD = rd(I == 1);
            GdCI = ci(I == 1); 
            DiffVal = dif(I == 1); 
            Arch = UpdArch(Arch, PopOld(I == 1, :), Fitness(I == 1)); 
            %%===================================================================
            [Fitness, I] = min([Fitness, popuFitness], [], 2);
            PopOld = Pop;
            PopOld(I == 2, :) = popu(I == 2, :);
            PopOld2(I == 2, :) = Pop(I == 2, :);
            %%==================================================================
            NumSucc = numel(GdRD); 
            if NumSucc > 0 
                SumDif = sum(DiffVal); 
                DiffVal = DiffVal / SumDif; 
                MemCI(MemI) = (DiffVal' * (GdCI .^ 2)) / (DiffVal' * GdCI); 
                if max(GdRD) == 0 || MemRD(MemI)  == -1
                    MemRD(MemI)  = -1;
                else
                    MemRD(MemI) = (DiffVal' * (GdRD .^ 2)) / (DiffVal' * GdRD);
                end
                MemI = MemI + 1;
                if MemI > Ms
                    MemI = 1;
                end
            end
            %%===================================================================
            Plan_PopSize = round((((MIN_PopSize - MAX_PopSize) /FES) * nFES) + MAX_PopSize);
            if popuSize > Plan_PopSize
                RedPop = popuSize - Plan_PopSize;
                if popuSize - RedPop <  MIN_PopSize
                    RedPop = popuSize - MIN_PopSize;
                end
                popuSize = popuSize - RedPop;
                for r = 1 : RedPop
                    [valBest, indBest] = sort(Fitness, 'ascend');
                    worst_ind = indBest(end);
                    PopOld(worst_ind,:) = [];
                    PopOld2(worst_ind,:) = [];
                    Pop(worst_ind,:) = [];
                    Fitness(worst_ind,:) = [];
                end
                Arch.NP = round(Ar * popuSize);
                if size(Arch.Pop, 1) > Arch.NP
                    rndPos = randperm(size(Arch.Pop, 1));
                    rndPos = rndPos(1 : Arch.NP);
                    Arch.Pop = Arch.Pop(rndPos, :);
                end
            end
            
            
            %% Survival
            % For minimization problems
            optimal = min(Fitness);
            record(G)=min(Fitness);
            fprintf('%s problem %5.0f time %5.0f |%5.0f -----> %9.16f\n', algorithmDir, f,t,nFES,optimal);
        end
        toc
        optimalChart = optimalChart(1:100:FES);
        fitnessRecord{problem,t}=optimalChart;
        optimalChart = optimalChart - optimum;
        optimalChart(optimalChart <= val_2_reach) = 0;
        resultChart = [resultChart,optimalChart];
        best_index = find(min(Fitness)==Fitness);
        best_individual{problem,t} = PopOld(best_index(1),:);
        outcome(problem, t) = min(Fitness);
        Record{problem,t}=record;
        optimalRecord{problem,t}=optimalChart;
        t = t + 1;
        nFES = 0;
        l = 2;
        wn1 = 0;
        wn2 = 0;
        wn3 = 0;
        ei1 = 0;
        ei2 = 0;
    end
    analysisChart = [analysisChart;resultChart(end,:)];    
    path = ['./',algorithmDir,'_CEC',num2str(benchmark),'_D',num2str(D)];
    sheetName = ['CEC_' num2str(benchmark) '_F'];
    xlswrite(path,resultChart,[sheetName,num2str(f)]);
    mean_value=mean(outcome(problem,:),2);
    std_value = std(outcome(problem,:),0,2);
end
mean_ = mean(analysisChart,2);
std_ = std(analysisChart,0,2);
analysisChart = [analysisChart,mean_];
analysisChart = [analysisChart,std_];
xlswrite(path,analysisChart,['CEC',num2str(benchmark),'_Statistic']);
switch benchmark
    case 2013
        rmdir('input_data', 's');
    case 2014
        rmdir('input_data', 's');
    case 2017
        rmdir('input_data', 's');
end
% save('SSAP_CEC2017_D30','outcome','Record','best_individual','final_data','fitnessRecord','optimalRecord')

