
function [PopOld2, Pop, popu, ci, Arch, MemI, rd,ks,n,p] = SSAP(PopOld, PopOld2, Fitness, MemCI, MemRD, MemI, PopSize, PbestRate, Ms, Arch, ProblemSize,l)

    %% calculation of z for every individuals

        rand('seed', sum(100 * clock));
        
        n = ceil(PopSize/l);
        p = PopSize - n;
        PopOld2 = PopOld2(randperm(PopSize),:);
        Pop = PopOld; 
         [~, SortedIndex] = sort(Fitness, 'ascend');
        ks = SortedIndex(1:n);
        mem_rand_index = ceil(Ms * rand(PopSize, 1));
        MUci = MemCI(mem_rand_index);
        MUrd = MemRD(mem_rand_index);
        rd = normrnd(MUrd, 0.1);

        Term_Pos = find(MUrd == -1);
        rd(Term_Pos) = 0;
        rd = min(rd, 1);
        rd = max(rd, 0);
        ci = MUci + 0.1 * tan(pi * (rand(PopSize, 1) - 0.5));
        Pos = find(ci <= 0);
        while ~ isempty(Pos)  
             ci(Pos) = MUci(Pos) + 0.1 * tan(pi * (rand(length(Pos), 1) - 0.5));
             Pos = find(ci <= 0);
        end
        ci = min(ci, 1);
        r0 = 1 : PopSize;
        PopAll = [Pop; Arch.Pop];
        [r1, r2, r3] = genR1R2R3(PopSize, size(PopAll, 1), r0);
        pNP = max(round(PbestRate * PopSize), 2); 
        randindex = ceil(rand(1, PopSize) .* pNP); 
        randindex = max(1, randindex); 
        pbest = Pop(SortedIndex(randindex), :); 
        tep = pbest;
        tep(ks,:)=Pop(r3(ks),:);
        PopA = PopOld2(r1,:);PopA(ks,:)=PopAll(r2(ks),:);
        zi = tep - Pop(r0,:) + Pop(r1, :) - PopA;
  
        %% calculation of Orthogonal matrix
        A = RandOrthMat(ProblemSize,1e-12);
        %% calculation of yi = Pop + ci.A.diag(bi).A'zi in parallel
          zi = zi*A;
          Ur = zeros(PopSize, ProblemSize);
          J = (mod(floor(rand(PopSize, 1)*ProblemSize), ProblemSize))*PopSize + (1:PopSize)';
          bi = rand(PopSize, ProblemSize) < rd .* (ones(PopSize, ProblemSize));
          Ur(J) = zi(J);
          Ur(bi) = zi(bi);
          yi = Pop(r0,:) + ci(:, ones(1, ProblemSize)) .* Ur*A';    
          popu = yi;
end     
     

function [r1, r2, r3] = genR1R2R3(NP1, NP2, r0)
NP0 = length(r0);
r3 = randperm(NP0);
for i = 1: 99999999
    Pos = (r3 == r0);
    if sum(Pos) == 0
        break;
    else
        r3 = randperm(NP0);
    end
     if i > 1000
        error('Can not genrate r3 in 1000 iterations');
     end
end
r1 = floor(rand(1, NP0) * NP1) + 1;

for i = 1 : 99999999
    Pos = (r1 == r0)|(r3 == r0);
    if sum(Pos) == 0
        break;
    else 
        r1(Pos) = floor(rand(1, sum(Pos)) * NP1) + 1;
    end
    if i > 1000
        error('Can not genrate r1 in 1000 iterations');
    end
end

r2 = floor(rand(1, NP0) * NP2) + 1;

for i = 1 : 99999999
    Pos = ((r2 == r1) | (r2 == r0)) | (r2 == r0);
    if sum(Pos)==0
        break;
    else 
        r2(Pos) = floor(rand(1, sum(Pos)) * NP2) + 1;
    end
    if i > 1000
        error('Can not genrate r2 in 1000 iterations');
    end
end
end
function zi = BoundConstraint (zi, Pop, LU)
[NP, ~] = size(Pop); 
xl = repmat(LU(1, :), NP, 1);
Pos = zi < xl;
zi(Pos) = (Pop(Pos) + xl(Pos)) / 2;
xu = repmat(LU(2, :), NP, 1);
Pos = zi > xu;
zi(Pos) = (Pop(Pos) + xu(Pos)) / 2;
end
function R = RandOrthMat(n, t)
    % orthogonal matrix approx
    R = eye(n);
    l = randperm(n);
    % t = 1e-8;
    for ii = 1:floor(n/2)
        i = 2*(ii-1)+1;
        R(l(i),l(i)) = sin(t);
        R(l(i+1),l(i+1)) = sin(t);
        R(l(i),l(i+1)) = cos(t);
        R(l(i+1),l(i)) = -cos(t);
    end 
end 

