% the main.m
clear all
% the name of algorithm
algorithmDir = 'TDSD';
%% experimental condition
% population size
popuSize = 100;
% dimension
D = 30;
% the max number of FES
FES = 10^4 * D;
% benchmark function
benchmark = 2017;
%CEC2005 include 25 functions
%CEC2011 include 22 functions
%CEC2013 include 28 functions
%CEC2014 include 30 functions
%CEC2017 include 30 functions
problemIndex = [1:30];
% max iteration number
maxIter = 3000;
% max run number
runTime = 1;
analysisChart = [];
addpath('../../');
totalMap = [1];
for selection = totalMap
    %% init table
    boxPlotChart = [];
    convergenceChart = [];
    pathOfBoxPlot = ['./',algorithmDir,'_chaos_',num2str(selection),'_CEC',num2str(benchmark),'_D',num2str(D),'_Mean&Std_and_Box-Plot.xls'];
    pathOfConvergence = ['./',algorithmDir,'_chaos_',num2str(selection),'_CEC',num2str(benchmark),'_D',num2str(D),'_Convergence.xls'];
    tableOfBoxPlot = initTableforBoxPlot(length(problemIndex),runTime);
    tableOfConvergence = initTableforConvergence(length(problemIndex));
    %% loop start
    for f = problemIndex
        resultChart = [];
        % run count
        t = 1;
        tic
        while t <= runTime
            %chaos

            %% init of each run
            % FES count
            nFES = 0;
            % iteration count
            iter = 0;
            optimalChart = [];
            %Population initialization
            [popu, lu, rgo, o, A, M, a, alpha, b] = Initialization(popuSize, D, benchmark, f);
            %
            if rgo ~= 0
                rgo = rgo(problemIndex);
            end
            % dimension for certain problem
            D = size(popu,2);
            radius = 0.05;
            z1=0.152;
            a=4.0;
            Chaos = z1;
%             Chaos_p=GenerateChaos(maxIter*50*popuSize);
%             Chaos=zeros(1,maxIter*50*popuSize);
            %Population evaluation
            [popuFitness] = Evaluation(popu, benchmark, f);
            [optimalFit,optI] = min(popuFitness);
            
            % best and worst individual
            optimal = popu(optI,:);
            nFES = nFES + popuSize;
            iter = iter + 1;
            optimalChart = [optimalChart;optimalFit];
            %% algorithm parameters setting
            type = 6;
            % please setting here

            %% start to search
            popuOld = popu;
            fitOld = popuFitness;
            flag = zeros(1,popuSize);
            direct = zeros(popuSize,D);
            F0 = 2 ;
            F = F0 * ones(1,popuSize);
            mu = zeros(1,popuSize);
            sigma0 = 0.5;
            sigma = sigma0 * ones(1,popuSize);
            while iter <= maxIter
                %% Search machine
                [~,I] = sort(fitOld);
                SF = zeros(1,popuSize);
                DSF = zeros(1,popuSize);
                gauss = mvnrnd(mu,sigma);
                for i = 1:popuSize
                    SF(I(i)) = i / popuSize + gauss(i);
                    if SF(I(i)) > 1
                        SF(I(i)) = 1;
                    elseif SF(I(i)) < 0
                        SF(I(i)) = i / popuSize;
                    end
                    if D >= 10
                        DSF(i) = 5 + randperm(5,1);
                    else
                        DSF(i) = 2;
                    end
                end
                
                for i = 1:popuSize
                    if flag(i)
                        popu(i,:) = popu(i,:) + F(i) * direct(i,:);
                    else
                        randPopuList = setdiff(randperm(popuSize),i,'stable');
                        indiR1 = popu(randPopuList(1),:);
                        indiR2 = popu(randPopuList(2),:);
                        indiR3 = popu(randPopuList(3),:);
                        indiR4 = popu(randPopuList(4),:);
                        indiR5 = popu(randPopuList(5),:);
                        
                        randDimList = randperm(D);
                        randDSFList = randperm(DSF(i));
                        
                        seleDim = sort(randDimList(1:randDSFList(1)));
                        
                        seleDimLen = length(seleDim);
                        if seleDimLen == 1
                            s1= SF(i)*HyperSphereTransform_1D(indiR1,indiR2,seleDim);
                            s2= SF(i)*HyperSphereTransform_1D(indiR3,indiR4,seleDim);
                            s3= SF(i)*HyperSphereTransform_1D(popu(i,:),optimal,seleDim);
                        elseif seleDimLen == 2
                            s1= SF(i)*HyperSphereTransform_2D(indiR1,indiR2,seleDim);
                            s2= SF(i)*HyperSphereTransform_2D(indiR3,indiR4,seleDim);
                            s3= SF(i)*HyperSphereTransform_2D(popu(i,:),optimal,seleDim);
                        else
                            s1= SF(i)*HyperSphereTransform(indiR1,indiR2,seleDim);
                            s2= SF(i)*HyperSphereTransform(indiR3,indiR4,seleDim);
                            s3= SF(i)*HyperSphereTransform(popu(i,:),optimal,seleDim);
                        end
                        
                        switch type
                            case 1%SE/current-to-best/1
                                popu(i,seleDim) = popu(i,seleDim) + s3 + s2;
                            case 2%SE/best/1
                                popu(i,seleDim) = optimal(seleDim) + s1;
                            case 3%SE/best/2
                                popu(i,seleDim) = optimal(seleDim) + s1 + s2;
                            case 4%SE/rand/1
                                
                                popu(i,seleDim) = indiR5(seleDim) + s1;
                            case 5%SE/rand/2
                                popu(i,seleDim) = indiR5(seleDim) + s1 + s2;
                            case 6 %SE/current/1
                                popu(i,seleDim) = popu(i,seleDim) + s1;
                            case 7 %SE/current/2
                                popu(i,seleDim) = popu(i,seleDim) + s1  + s2 ;
                        end
                    end
                    
                    %% Boundary detection
                    [popu(i,:)] = BoundaryDetection(popu(i,:),lu);
                    %% Population evaluation
                    
                    [popuFitness(i)] = Evaluation(popu(i,:), benchmark, f);
                    nFES = nFES + 1;
                    %% Update pBest
                    % for globa population
                    if popuFitness(i) < fitOld(i)
                        if flag(i)
                            F(i) = F(i) + 0.1 * rand;
                        else
                            flag(i) = 1;
                            F(i) = F(i) - 0.1 * rand;
                            sigma(i) = sigma0;
                        end
                        direct(i,:) = popu(i,:) - popuOld(i,:);
                        fitOld(i) = popuFitness(i);
                        popuOld(i,:) = popu(i,:);
                    else
                        if flag(i)
                            F(i) = F0;
                            succ = false;
                            for k = 1:50
                                Chaos=a*Chaos-Chaos*a*Chaos;
                                indCLS = popu(i,:) + radius .* (lu(2,:) - lu(1,:)) .* (Chaos - 0.5);
                                [indCLS] = BoundaryDetection(indCLS,lu);
                                [FitindCLS] = Evaluation(indCLS, benchmark, f);
                                nFES = nFES + 1;
                                if FitindCLS < fitOld(i)
                                    succ = true;
                                    direct(i,:) = indCLS - popuOld(i,:);
                                    popuOld(i,:) = indCLS;
                                    fitOld(i) = FitindCLS;
                                    break;
                                end
                            end
                            if succ
                                flag(i) = 1;
                            else
                                flag(i) = 0;
                            end
                            sigma(i) = sigma(i) - 0.1 * rand;
                            if sigma(i) < 0
                                sigma(i) = 0.001;
                            end
                        else
                            sigma(i) = sigma(i) + 0.1 * rand;
                        end
                    end
                end
                [optimalFitNew,optI] = min(fitOld);
                if optimalFitNew < optimalFit
                    optimalFit = optimalFitNew;
                    optimal = popuOld(optI,:);
                end
                %% Survival
                % For minimization problems
                %%
                % For minimization problems
                optimalChart = [optimalChart;optimalFit];%% Chaotic local search
                
                
                radius = radius - 0.04 * iter / maxIter;
                fprintf('%s problem %5.0f time %5.0f |%5.0f -----> %9.16f\n', algorithmDir, f,t,iter,optimalFit);
                popu = popuOld;
                iter = iter + 1;
            end
            %%
%             optimalChart = optimalChart(1:popuSize:FES);
            resultChart = [resultChart,optimalChart];
            t = t + 1;
            toc
        end
        resultChart = resultChart - f * 100;
        boxPlotChart = [boxPlotChart;resultChart(maxIter,:)];
        convergenceChart = [convergenceChart,mean(resultChart,2)];
        path = ['./TDSD_',algorithmDir,'_chaos_',num2str(selection),'_CEC',num2str(benchmark),'_D',num2str(D)];
        sheetName = ['CEC_' num2str(benchmark) '_F'];
        xlswrite(path,resultChart,[sheetName,num2str(f)]);
    end
    %% save result
    updateTableforBoxPlot(tableOfBoxPlot,boxPlotChart,pathOfBoxPlot,rgo);
    updateTableforConvergence(tableOfConvergence,convergenceChart,pathOfConvergence,rgo)
    %% delete file
end
function tableB = initTableforBoxPlot(problemNum, runNum)
row = 3 + problemNum;
col = 1 + runNum;
tableB = cell(row, col);
tableB{1,2} = 'mean';
tableB{1,3} = 'std';
for i = 1:problemNum
    tableB{i+1,1} = ['F' num2str(i)];
end
end

function tableC = initTableforConvergence(problemNum)
col = problemNum;
tableC = cell(1,col);
for i = 1:col
    tableC{1,i} = ['F' num2str(i)];
end
end


function updateTableforBoxPlot(tableB,data,path,rgo)
[row,col] = size(data);
rgo = repmat(rgo,1,col);
data = data - rgo;
dataMean = mean(data,2);
dataStd = std(data,0,2);
Dcol = ones(1,col);
Drow = ones(1,row);
dataMean = mat2cell(dataMean,Drow,[1]);
dataStd = mat2cell(dataStd,Drow,[1]);
tableB(2:row+1,2) = dataMean;
tableB(2:row+1,3) = dataStd;
for i = 1:row
    dataCol = mat2cell(data(i,:),[1],Dcol);
    tableB(i+1,4:3+col) = dataCol;
end
xlswrite(path,tableB);
end

function updateTableforConvergence(tableC,data,path,rgo)
[row,col] = size(data);
rgo = repmat(rgo',row,1);
data = data - rgo;
Drow = ones(1,row);
for i = 1:col
    dataCol = mat2cell(data(:,i),Drow,[1]);
    tableC(2:row+1,i) = dataCol;
end
xlswrite(path,tableC);
end

function ss = HyperSphereTransform(c,d,pp)
D=length(pp);
A=c(pp)-d(pp);
R=norm(A,2);
O(D-1)=  2*pi*rand ;
for i=1:D-2
    O(i)=  rand*pi  ;
end
% תֱ
C(1)=R*prod(sin(O));
for i=2:D-1
    C(i)= R*cos(O(i-1)) *prod(sin(O(i:D-1)));
end
C(D)=R*cos(O(D-1));
ss=C;
end

function ss = HyperSphereTransform_1D(c,d,pp)
R=  abs(c(pp)-d(pp));
C = R*cos(2*pi*rand);
ss=C;
end

function ss = HyperSphereTransform_2D(c,d,pp)
A=c(pp)-d(pp);
R=norm(A,2);
o1=2*pi*rand;
C=zeros(1,2);
C(1) =R*sin(o1);
C(2) =R*cos(o1);
ss=C;
end

