from pandas import read_csv
from matplotlib import pyplot

#设置全局字体为Times New Roman
pyplot.rcParams['font.family'] = 'Times New Roman'

# load dataset
dataset = read_csv('power.csv', header=0, index_col=0)
values = dataset.values
# specify columns to plot
groups = [0, 1, 2, 3, 4, 5]
i = 1
# plot each column
pyplot.figure(figsize=(12, 15))  # 增加图形宽度以容纳右侧标签
for group in groups:
    ax = pyplot.subplot(len(groups), 1, i)
    pyplot.plot(values[:, group])

    # 将标题移到右侧空白处，靠左对齐
    ax.text(1.01, 0.6, dataset.columns[group],
            verticalalignment='top',
            horizontalalignment='left',
            transform=ax.transAxes,
            rotation=0,
            fontsize=16)

    # 隐藏除最后一个子图外的所有x轴刻度
    if i < len(groups):
        ax.xaxis.set_visible(False)
    else:
        ax.xaxis.set_visible(True)
        # 为最后一个子图添加X轴标签
        ax.set_xlabel('Time (h)', fontsize=16)

    # 移除y轴标签
    ax.set_ylabel('')

    # 调整子图边距，为右侧标签留出空间
    pyplot.subplots_adjust(right=0.85)

    i += 1

# pyplot.tight_layout()  # 调整子图之间的间距
pyplot.show()
