% ----------------------------------------------------------------------------
% Title: [Towards Explicit Control between Exploration and Exploitation in Evolutionary Algorithms: A Case Study on Differential Evolution]
% Authors: [Zonghui Cai; Xiao Yang; MengChu Zhou; Zhi-Hui Zhan; Shangce Gao]
%
% This code is used to implement the algorithms and methods from the paper and provides
%
% Citation:
% If you use this code for your research, please cite the following paper:
% Zonghui Cai, Xiao Yang, MengChu Zhou, Zhi-Hui Zhan, Shangce Gao, "Towards Explicit Control between Exploration and Exploitation in Evolutionary Algorithms: A Case Study on Differential Evolution," Information Sciences, 2023.
%
% Note: This code is protected by copyright and is intended for academic research
% and non-commercial use only. Please adhere to relevant copyright regulations.
% ----------------------------------------------------------------------------

% the main.m
clear all
clc


rand ('state', sum(100*clock));
%% experimental condition
runMax = 51;
fhd = @cec17_func;
Cluster = parcluster('local');
Cluster.NumWorkers = 4;
% the name of algorithm
algorithmDir = 'TRADE';
%% loop start
    for Dim = [10 30 50 100]
        FES = 10^4 * Dim;
        for func = 1:30
            fprintf('\n-------------------------------------------------------\n')
            fprintf('Function = %d, Dimension size = %d\n', func, Dim)
            % table of final result
            funvals=[];
            totalGpopSize = [];
            % count of runtimes
            optima = func * 100;
            %% indenpendented run
            parfor run = 1:runMax
                
                run_funcvals = [];
                %% initialization
                % record the result
                optimalChart = [];
                tgps = [];
                % population size
                popSize = 100;
                % count of function evaluation
                nFES = 0;
                % lower and upper bound
                lu = [-100 * ones(1,Dim); 100 * ones(1,Dim)];
                % random initialization
                Pop = repmat(lu(1, :), popSize, 1) + rand(popSize, Dim) .* (repmat(lu(2, :) - lu(1, :), popSize, 1));
                popFit = feval(fhd,Pop',func);
                popFit = popFit';
                nFES = nFES + popSize;
                % best so far solution
                [bsff,bsfi] = min(popFit);
                bsfp = Pop(bsfi,:);
                run_funcvals = [run_funcvals;bsff];
                % all best so far position
                lPopSize = 0.5 * popSize;
                gPopSize = popSize - lPopSize;
                gFlag = zeros(gPopSize,1);
                gR = ones(gPopSize,1);
                lSeed = randperm(popSize,lPopSize);
                gSeed = setdiff(randperm(popSize),lSeed);
                lPop = Pop(lSeed,:);
                lPopFit = popFit(lSeed,:);
                gPop = Pop(gSeed,:);
                
                gPopFit = popFit(gSeed,:);
                subSize = ones(lPopSize,1);
                flag = zeros(lPopSize,1);
                theta = 1.5 * Dim;
                if theta < 30
                    theta = 30;
                end
                gTh = popSize;
                
                %% parameters of local search
                CR = 0.9;
                F = 0.5;
                %% start to search
                while nFES < FES
                    remove = [];
                    improve = [];
                    change = 0;
                    %% DE/rand/1
                    newFit = zeros(lPopSize,1);
                    newPop = zeros(lPopSize,Dim);
                    if lPopSize > 3
                        for i = 1:lPopSize
                            Offs = zeros(subSize(i),Dim);
                            for j = 1:subSize(i)
                                rnd = randperm(lPopSize);
                                rnd(rnd == i) = [];
                                r1 = rnd(1);
                                r2 = rnd(2);
                                r3 = rnd(3);
                                mutate =  lPop(r1,:) + F * (lPop(r2,:)-lPop(r3,:));
                                sd = ceil(rand * Dim);
                                sds = rand(1, Dim) < CR;
                                sds(1, sd) = 1;
                                sds_ = 1 - sds;
                                Offs(j,:) = sds .* mutate + sds_ .* lPop(i,:);
                            end
                            Offs = boundConstraint(Offs, repmat(lPop(i,:),subSize(i),1), lu);
                            OffsFit = feval(fhd,Offs',func);
                            OffsFit = OffsFit';
                            [newFit(i),pos] = min(OffsFit);
                            newPop(i,:) = Offs(pos,:);
                            nFES = nFES + subSize(i);
                        end
                    else
                        for i = 1:lPopSize
                            Offs = zeros(subSize(i),Dim);
                            for j = 1:subSize(i)
                                Offs(j,:) = lPop(i,:) + randn(1,Dim);
                            end
                            Offs = boundConstraint(Offs, repmat(lPop(i,:),subSize(i),1), lu);
                            OffsFit = feval(fhd,Offs',func);
                            OffsFit = OffsFit';
                            [newFit(i),pos] = min(OffsFit);
                            newPop(i,:) = Offs(pos,:);
                            nFES = nFES + subSize(i);
                        end
                    end
                    
                    
                    for i = 1:lPopSize
                        if newFit(i) <= lPopFit(i)
                            flag(i) = 0;
                            lPopFit(i) = newFit(i);
                            lPop(i,:) = newPop(i,:);
                            improve = [improve,i];
                        else
                            flag(i) = flag(i) + 1;
                            if flag(i) >=  theta
                                flag(i) = 0;
                                if i ~= bsfi
                                    change = change + subSize(i);
                                    remove = [remove,i];
                                else
                                    if subSize(i) > 1
                                        subSize(i) = subSize(i) - 1;
                                        change = change + 1;
                                    end
                                end
                            end
                        end
                    end
                    
                    if ~isempty(improve)
                        if  gPopSize > gTh && sum(subSize) < popSize
                            assign = improve(randperm(length(improve),1));
                            change = change - 1;
                            subSize(assign) = subSize(assign) + 1;
                        end
                    end
                    
                    [minSf,minSi] = min(lPopFit);
                    if minSf < bsff
                        bsff = minSf;
                        bsfp = lPop(minSi(1),:);
                    end
                    subSize(remove) = [];
                    lPop(remove,:) = [];
                    lPopFit(remove) = [];
                    flag(remove) = [];
                    lPopSize = lPopSize - length(remove);
                    %% random search
                    if gPopSize > 0
                        gOffs = zeros(gPopSize,Dim);
                        for i = 1:gPopSize
                            if gFlag(i) 
                                gOffs(i,:) = lu(1,:) + (lu(2,:) - lu(1,:)) .* rand(1,Dim);
                            else
                                gOffs(i,:) = gPop(i,:) + gR(i) * randn(1,Dim);
                            end
                        end
                        gOffs = boundConstraint(gOffs, gPop, lu);
                        gOffsFit = feval(fhd,gOffs',func);
                        gOffsFit = gOffsFit';
                        nFES = nFES + gPopSize;
                        
                        for i = 1:gPopSize
                            if gFlag(i) == 1
                                gFlag(i) = 0;
                                gPop(i,:) = gOffs(i,:);
                                gPopFit(i,:) = gOffsFit(i,:);
                            else
                                if gOffsFit(i,:) <= gPopFit(i,:)
                                    gPopFit(i,:) = gOffsFit(i,:);
                                    gPop(i,:) = gOffs(i,:);
                                    gR(i) = 1.1 * gR(i);
                                    if gR(i) > 20
                                        gR(i) = 1;
                                    end
                                else
                                    gR(i) = 0.9 * gR(i);
                                    if gR(i) < 10e-8
                                        gR(i) = 1;
                                    end

                                end
                            end
                        end
                        [sFit , sI] = min(gPopFit);
                        if sFit(1) < bsff
                            bsff = sFit(1);
                            bsfp = gPop(sI(1),:);
                        end
                        
                        if rand < gPopSize / popSize
                            if sum(subSize) < popSize
                                lPopSize = lPopSize + 1;
                                subSize = [subSize;1];
                                gPopSize = gPopSize - 1;
                                lPop = [lPop;gPop(sI(1),:)];
                                lPopFit = [lPopFit;sFit(1)];
                                flag = [flag;0];
                                gPop(sI(1),:) =[];
                                gPopFit(sI(1)) = [];
                                gFlag(sI(1)) = [];
                                gR(sI(1)) = [];
                            end
                        end
                    end
                    gPopSize = gPopSize + change;
                    if change >= 0
                        gFlag = [gFlag;ones(change,1)];
                        gR = [gR;ones(change,1)];
                        gPop = [gPop;zeros(change,Dim)];
                        gPopFit = [gPopFit;inf*ones(change,1)];
                    else
                        for i = 1:abs(change)
                            [~,sortIndex] = sort(gPopFit,'ascend');
                            deleIndex = sortIndex(end);
                            gPopFit(deleIndex) = [];
                            gPop(deleIndex,:) =[];
                            gFlag(deleIndex) = [];
                            gR(deleIndex) = [];
                        end
                    end
                    
                    gTh = popSize * exp(1-FES/(FES+1-nFES));
                    tgps = [tgps;gPopSize];
                    run_funcvals = [run_funcvals;bsff];
%                                     fprintf('%s problem %5.0f time %5.0f gPopS:%5.0f lPopS:%5.0f |%5.0f -----> %9.16f\n', algorithmDir, func,run,gPopSize,sum(subSize),nFES,bsff);
                end
                %%
                run_funcvals = run_funcvals - optima;
                run_funcvals(run_funcvals <= 10^-8) = 0;
                funcval_out(run) = run_funcvals(end);
                fprintf('%d th run, best-so-far error value = %1.8e\n', run , funcval_out(run))
                funvals(run,:)=run_funcvals;
                totalGpopSize(run,:) = tgps;
            end
            path = ['./' algorithmDir '_CEC2017_D', num2str(Dim),'.xls'];
            xlswrite(path,funvals',['F',num2str(func)]);
            path2 = ['./' algorithmDir '_CEC2017_D', num2str(Dim),'_gPopSizeVar.xls'];
            xlswrite(path2,totalGpopSize',['F',num2str(func)]);
        end
    end