prompt --application/deployment/install/install_gallery
begin
--   Manifest
--     INSTALL: INSTALL-gallery
--   Manifest End
wwv_flow_imp.component_begin (
 p_version_yyyy_mm_dd=>'2022.04.12'
,p_release=>'22.1.3'
,p_default_workspace_id=>30040104978234657984
,p_default_application_id=>63416
,p_default_id_offset=>67776734671150896252
,p_default_owner=>'WKSP_JAPANCOMMUNITY'
);
wwv_flow_imp_shared.create_install_script(
 p_id=>wwv_flow_imp.id(33905677131147404962)
,p_install_id=>wwv_flow_imp.id(101663286329717675738)
,p_name=>'gallery'
,p_sequence=>10
,p_script_type=>'INSTALL'
,p_script_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'-- create tables',
'create table gallery_custom_apps (',
'    id                             number generated by default on null as identity ',
'                                   constraint gallery_custom_app_id_pk primary key,',
'    internal_name                  varchar2(80 char)',
'                                   constraint gallery_custom_internal_n_unq unique not null,',
'    author                         varchar2(160 char) not null,',
'    version                        varchar2(20 char) not null,',
'    icon                           varchar2(400 char),',
'    url                            varchar2(400 char),',
'    source                         varchar2(400 char),',
'    zip                            varchar2(400 char) not null,',
'    license                        varchar2(80 char),',
'    apex_version                   varchar2(8 char),',
'    created                        date not null,',
'    created_by                     varchar2(255 char) not null,',
'    updated                        date not null,',
'    updated_by                     varchar2(255 char) not null',
')',
';',
'',
'create table gallery_custom_apps_lang (',
'    id                             number generated by default on null as identity ',
'                                   constraint gallery_custom_app_id_pk2 primary key,',
'    custom_app_id                  number',
'                                   constraint gallery_custom_custom_app_fk',
'                                   references gallery_custom_apps on delete cascade not null,',
'    language                       varchar2(2 char) not null,',
'    name                           varchar2(160 char) not null,',
'    description                    varchar2(800 char),',
'    created                        date not null,',
'    created_by                     varchar2(255 char) not null,',
'    updated                        date not null,',
'    updated_by                     varchar2(255 char) not null',
')',
';',
'',
'-- table index',
'create index gallery_custom_app_i1 on gallery_custom_apps_lang (custom_app_id);',
'',
'',
'-- triggers',
'create or replace trigger gallery_custom_apps_biu',
'    before insert or update ',
'    on gallery_custom_apps',
'    for each row',
'begin',
'    if inserting then',
'        :new.created := sysdate;',
'        :new.created_by := coalesce(sys_context(''APEX$SESSION'',''APP_USER''),user);',
'    end if;',
'    :new.updated := sysdate;',
'    :new.updated_by := coalesce(sys_context(''APEX$SESSION'',''APP_USER''),user);',
'    :new.internal_name := upper(:new.internal_name);',
'end gallery_custom_apps_biu;',
'/',
'',
'create or replace trigger gallery_custom_apps_lang_biu',
'    before insert or update ',
'    on gallery_custom_apps_lang',
'    for each row',
'begin',
'    if inserting then',
'        :new.created := sysdate;',
'        :new.created_by := coalesce(sys_context(''APEX$SESSION'',''APP_USER''),user);',
'    end if;',
'    :new.updated := sysdate;',
'    :new.updated_by := coalesce(sys_context(''APEX$SESSION'',''APP_USER''),user);',
'    :new.language := lower(:new.language);',
'end gallery_custom_apps_lang_biu;',
'/',
'',
'-- load data',
''))
);
wwv_flow_imp.component_end;
end;
/
