# Magento 2 GDPR FREE by Mageplaza (EU)

## What is GDPR? - Help Your Magento 2 Store Protect Customers
GDPR stands for General Data Protection Regulation issued by EU, starting on May 25, 2018. This is a new set of data privacy regulations giving an important impact not only on European countries but also on all over the world.

There are many important rules that firms have to obey from June 2018, these rules help protect customers’ data from being stolen and misused (the data can be traded without permission or customers can be overwhelmed by complicated or incomprehensible terms). We recommend that you should go through all terms and conditions [here](https://www.eugdpr.org/); this is especially important if you are expertised in IT or if you are a Magento 2 store owner.

To help Magento 2 stores which are directly affected by GDPR, Mageplaza is about to release an extension called Mageplaza GDPR for Magento 2. This module is to supports online stores to comply those data privacy regulations.


## How to install GDPR for Magento 2


### ✓ Install via composer (recommend)
Run the following command in Magento 2 root folder:

```
composer require mageplaza/module-gdpr
php bin/magento setup:upgrade
php bin/magento setup:static-content:deploy
```
### ✓ Install ready-to-paste package (not recommend)

- Download the latest version [here](https://github.com/mageplaza/magento-2-gdpr/releases)
-  [Installation guide](https://www.mageplaza.com/install-magento-2-extension/)

## Documentations
- [Mageplaza](https://www.mageplaza.com)
- [User guide](http://docs.mageplaza.com/gdpr/)

## Mageplaza GDPR Standard Edition - Highlights

### Delete accounts
![magento 2 gdpr](https://i.imgur.com/5DYdNyN.png)

Magento 2 GDPR by Mageplaza supports customers in permanently deleting their accounts on your e-website. All related information including one which is considered private data will be completely removed along with customers’ accounts. This helps the buyers make sure that their personal information is protected by GDPR.

### Delete default addresses

![delete default addresses for gdpr](https://i.imgur.com/rlbuMfk.png)

Default addresses including Billing and Shipping addresses are seen as private data of a human being according to GDPR. Hence, allowing buyers to delete these information is an action which proves that you are making a strong commitment to protect your users. With Magento 2 GDPR, this is easily performed by your customers with only few easy and clear steps.



## Mageplaza GDPR Pro Edition - An Innovative Version

### Manage billing information (coming soon)
Billing information including data featured in customers’ orders, invoices, credit memos and shipments is seriously important which needs protecting. Your online shoppers, for sure, have rights to manage it themselves, and also, have rights to become anonymous. To support online stores in solving this issue, Mageplaza GDPF Pro version allows customers to anonymize their private information such as names, phone number or addresses by replacing these data by a random string.

Also, customers’ private information on subscribing requests and abandoned carts will become anonymous.  

### Cookie restriction (coming soon)
Online stores often use cookies to enhance customer experience. However, through this, a customer can be identified and this is why you need to concern about this. Mageplaza GDPR extension allow store admins to design the Cookie message by using HTML; also, the position to feature the message can be configured to be at the top or bottom of your webpage. Cookie can be restricted in specific countries based on your settings in the backend also.



## Why do we need the GDPR?
It is obviously easy to understand, the regulation has been adopted as data protection and privacy issues are increasingly becoming a serious concern. In recent decades, the internet growth has continued increasing so does the frequency and effect of data breaches. According to the [Breach Level Index](https://breachlevelindex.com/assets/Breach-Level-Index-Report-H1-2017-Gemalto.pdf), by the first half of 2017, the number of data breaches had risen from above 575 million in 2013 to more than 1,9 billion over the 2-year period. Shockingly, over 95% of these breaches including unencrypted data were not protected properly. The point here is that the total global annual cost of all data breaches, according to [a Juniper’s research](https://www.juniperresearch.com/press/press-releases/cybercrime-cost-businesses-over-2trillion), is forecasted to reach above $2.1 trillion in damages by 2019. You can imagine how severely consumers and organizations can be affected.

That is why GDPR needs to appear as soon as possible with an aim to eliminate and reduce possible harms and threats for both businesses and online shopping doers. The regulations play a role as data security standards which organizations have to follow. 

## Why Mageplaza GDPR is your must-have extension
Your Magento 2 store, no matter where you are based, is not out of GDPR effects. As long as you are processing and storing data about European citizens, your business will be under the control of GDPR. [In the Art. 3 GDPR, chapter 1](https://gdpr-info.eu/art-3-gdpr/), we can find: 

![gdpr for magento 2](https://i.imgur.com/9tp5P7q.png)

So, it’s high time to concern about your Magento 2 store and prepare for it now no matter where you are located before your organization is in compliance on May 25th, 2018.



### People also search for
- Magento 2 GDPR module
- GDPR for Magento 2
- GDPR extension for Magento 2
- Magento 2 GDPR extension
- Magento 2 GDPR Free
