<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://www.mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category  Mageplaza
 * @package   Mageplaza_GdprPro
 * @copyright Copyright (c) Mageplaza (https://www.mageplaza.com/)
 * @license   https://www.mageplaza.com/LICENSE.txt
 */

namespace Mageplaza\GdprPro\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

/**
 * Class CountryType
 *
 * @package Mageplaza\GdprPro\Model\Config\Source
 */
class CountryType implements ArrayInterface
{
    const ALL      = 0;
    const EU       = 1;
    const SPECIFIC = 2;

    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::ALL, 'label' => __('All Allowed Countries')],
            ['value' => self::EU, 'label' => __('All EU Countries')],
            ['value' => self::SPECIFIC, 'label' => __('Specific Countries')]
        ];
    }
}
