# -*- coding: utf-8 -*-
# Licence: GPL v.3: http://www.gnu.org/copyleft/gpl.html

from __future__ import unicode_literals

import sys, os
import re
import urllib

import xbmc
import xbmcaddon
import xbmcgui

from totam import getKodiInfo
from findvideo import find_video
from errors import log


ADDON = xbmcaddon.Addon()

PATTERNS_FOR_DELETE = ADDON.getSetting('patterns_delete') if ADDON.getSetting('patterns_delete') else "[(].+?[)],[[][^\[\]]+?[]],[[].+?[]],SE?\d\dEP?\d\d[ |]+?,[|]"
US = ADDON.getSetting('us') == 'true'


def get_iddb():
    iddb = xbmc.getInfoLabel("ListItem.DBID")
    return iddb if iddb and (iddb != "-1") else ""


def get_id():
    iddb = get_iddb()
    id = xbmc.getInfoLabel("ListItem.Property(id)")
    return iddb if iddb else id


def decode_(s):
    try:
        return s.decode('utf-8')
    except:
        return s


extVideo = ["3g2", "3gp", "aaf", "asf", "avchd", "avi", "drc", "flv", "iso", "m2v", "m2ts", "m4p", "m4v", "mkv",
            "mng", "mov", "mp2", "mp4", "mpe", "mpeg", "mpg", "mpv", "mxf", "nsv", "ogg", "ogv", "ts", "qt",
            "rm", "rmvb", "roq", "svi", "vob", "webm", "wmv", "yuv"]

def isFile(file):
    ext = file.lower()[file.rfind(".")+1:]
    if extVideo.count(ext):
        return True
    return False

def clear_file(name, year=None):
    if isFile(name):
        name = name[:name.rfind(".")]
        name = name.replace('.',' ').replace('_', ' ')
        match = re.compile(r"([Ss]\d+[ ]{0,1}[Ee]\d+)").search(name)
        if match: name = name.split(match.group(1))[0]
        if year:  name = name.split(year)[0]
    return name

def clear_tc(title):
    match = re.compile(r"(\[B\]\[COLOR.+\[/COLOR\]/\[/B\])").search(title)
    if match:
        if title.startswith(match.group(1)): title = title.replace(match.group(1), '')
    return title

def get_year(title):
    title = clear_tc(title)
#    xbmcgui.Dialog().textviewer('year title', title)
    patterns = [r"\(([12][90]\d\d)[),-]", r"\.([12][90]\d\d)\.", r"(?:, |,)([12][90]\d\d),",
                r"(?: \[|\]|\]\[)([12][90]\d\d)", r"   ([12][90]\d\d)  "]
    for pattern in patterns:
        match = re.compile(pattern).search(title)
        year = match.group(1) if match else ""
        if match: break
#    xbmcgui.Dialog().textviewer('year', year)
    if year == "" or (year.isdigit() and int(year) < 1900):
        fyear = re.compile(r" / ([12][90]\d\d) / ").findall(title)
        if fyear: year = fyear[-1]
    return year if year.isdigit() and int(year) > 1900 else ""

def clear_title(title, year=None):
    title = clear_tc(title)
    if year:
        title = title.split(' (%s' % year)[0].strip()
        title = title.split(' [%s' % year)[0].strip()
    patterns = decode_(PATTERNS_FOR_DELETE).split(",") if PATTERNS_FOR_DELETE else []
    for pattern in patterns:
        title = re.compile(pattern).sub("", title).strip()
    if '.' in title: title = clear_file(title, year)
    if title.strip() != year and year and title.find('-'+year) == -1: title = title.replace(year,'')
    return title.strip()


def main():
    info = getKodiInfo(True)
    label = decode_(xbmc.getInfoLabel("ListItem.Label"))
    year = get_year(label)
    name = info.get('title', label)
    cl_name = clear_title(name, year)
    if ' / ' in cl_name: title = cl_name.split(" / ")
    elif '   ' in cl_name: title = cl_name.split("   ")
    else: title = cl_name
    if isinstance(title, list):
        for i in range(title.count("")): title.remove('')
    find_video(title, info.get('originaltitle'), info.get('year', year), name=name, cl_name=cl_name, us=US )


if __name__ == '__main__':
    try:
        main()
    except Exception as e:
        log(e)
