# -*- coding: utf-8 -*-

def executeJSONRPC(q):
	import json, xbmc
	s = json.dumps(q)
	res = xbmc.executeJSONRPC(s)
	return json.loads(res)

class JSONRPC_API(object):
	def __init__(self, name):
		self._name = name

	def __getattribute__(self, name):
		_name = object.__getattribute__(self, '_name')
		def run(limits={}, sort={}, filter={}, error=True, **params):
			q = {	"jsonrpc": "2.0",
				"method": _name + "." + name,
				"params": params,
				"id": "JSONRPC_API"
			}

			if limits:
				q['params']['limits'] = limits
			if sort:
				q['params']['sort'] = sort
			if filter:
				q['params']['filter'] = filter

			try:
				res = executeJSONRPC(q)
				return res['result']
			except KeyError as e:
				if error:
					from errors import log
					log(e, 'JSONRPC error')
				return res
		return run

VideoLibrary = JSONRPC_API('VideoLibrary')
JSONRPC	= JSONRPC_API('JSONRPC')
GUI = JSONRPC_API('GUI')
Files = JSONRPC_API('Files')
Addons = JSONRPC_API('Addons')


def getAddons():
	res = Addons.GetAddons(type='xbmc.addon.video', content='video', enabled=True, properties=['name'])
	return res['addons']
