# -*- coding: utf-8 -*-

__all__ = ['_de', '_en', '_de3', '_en3', 'PY2', 'quote', 'quote_plus', 'urlencode', 'unquote', 'unquote_plus']

import sys
PY2 = sys.version_info.major == 2
if PY2:
    from urllib import quote, quote_plus, urlencode, unquote, unquote_plus
else:
    from urllib.parse import quote, quote_plus, urlencode, unquote, unquote_plus
    unicode = str
    basestring = str
    __all__.extend(['unicode', 'basestring'])

def _de(s):
    return s.decode('utf8') if PY2 else s

def _en(s):
    return s.encode('utf8') if PY2 else s


def _de3(s):
    return s if PY2 else s.decode('utf8')

def _en3(s):
    return s if PY2 else s.encode('utf8')
