# -*- coding: utf-8 -*-
import os, sys
PY2 = sys.version_info.major == 2
import xbmc

if not PY2:
       unicode = str

def _de(s):
    return s.decode('utf8') if PY2 else s

def _en(s):
    return s.encode('utf8') if PY2 else s

def _der(s):
    return s.decode('utf8', 'replace') if PY2 else s

__id_plugin__ = sys.argv[0].replace('plugin://','').replace('/','') if sys.argv[0].replace('plugin://','').replace('/','') else __import__('xbmcaddon').Addon().getAddonInfo('id')
__plugin_name__ = _de(xbmc.getInfoLabel('System.AddonTitle(%s)' % __id_plugin__))
__plugin_version__ = _de(xbmc.getInfoLabel('System.AddonVersion(%s)' % __id_plugin__))

def iteritems(d):
    return d.iteritems() if PY2 else d.items()

def _decode(s):
        try:
                return s.decode('utf8')
        except:
                return s


def _encode(s):
        try:
                return s.encode('utf8')
        except:
                return s


def message(title, msg, times=5000, icon=None):
        if isinstance(title, unicode):
                title = _en(title)
        if isinstance(msg, unicode):
                msg = _en(msg)
        if icon and isinstance(icon, unicode):
                icon = _en(icon)
        if icon is None:
                icon = xbmc.getInfoLabel('System.AddonIcon(%s)' % __id_plugin__)
        try:
                xbmc.executebuiltin('XBMC.Notification("%s", "%s", %s, "%s")' % (title, msg, times, icon))
        except Exception as e:
                xbmc.log('Message: ' + str(e), xbmc.LOGERROR)


def log(e, msgerror=None, logger=None, msgwarning=True):
        #global pformat
        from pprint import pformat
        def _format_vars(variables):
                var_list = [(var, val) for var, val in iteritems(variables)]
                lines = []
                for var, val in sorted(var_list, key=lambda i: i[0]):
                        if not (var.startswith('__') or var.endswith('__')):
                                lines.append('{0} = {1}'.format(var, pformat(val)))
                return '\n'.join(lines)

        #def logger(s):
                #print(s)
        if isinstance(e, BaseException):
                #global uname, inspect, traceback
                from platform import uname
                import inspect, traceback
                if logger is None:
                        logger = lambda msg: xbmc.log(_encode(msg), xbmc.LOGERROR)
                frame_info = inspect.trace(5)[-1]
                logger('Unhandled exception detected!')
                logger('*** Start diagnostic info ***')
                logger(u'Plugin name: {0}'.format(__plugin_name__))
                logger(u'Plugin version: {0}'.format(__plugin_version__))
                logger('System info: {0}'.format(uname()))
                logger(u'OS info: {0}'.format(_de(xbmc.getInfoLabel('System.OSVersionInfo'))))
                logger('Kodi version: {0}'.format(xbmc.getInfoLabel('System.BuildVersion')))
                logger('Python version: {0}'.format(sys.version.replace('\n','')))
                logger('File: {0}'.format(frame_info[1]))
                context = ''
                if frame_info[4] is not None:
                        for i, line in enumerate(frame_info[4], frame_info[2] - frame_info[5]):
                                if i == frame_info[2]:
                                        context += '{0}:>{1}'.format(str(i).rjust(5), line)
                                else:
                                        context += '{0}: {1}'.format(str(i).rjust(5), line)
                logger(u'Code context:\n' + _de(context))
                logger('Global variables:\n' + _format_vars(frame_info[0].f_globals))
                logger('Local variables:\n' + _format_vars(frame_info[0].f_locals))
                logger('**** End diagnostic info ****')
                if msgerror:
                        logger('**** Start traceback info ****')
                        exc_type, exc_val, exc_tb = sys.exc_info()
                        lines = traceback.format_exception(exc_type, exc_val, exc_tb, limit=30)
                        logger(str(e))
                        context = ''
                        for line in lines:
                                context += '{0}'.format(line)
                        logger(_der(context))
                        logger('**** End traceback info ****')
                        logger(_decode(msgerror))
                        if msgwarning: message(_decode(msgerror), str(e))
                else:
                        raise
        else:
                if msgerror is None: msgerror = ''
                if logger:
                        logger(u'{0}:{1} {2}'.format(__plugin_name__, _decode(msgerror), _decode(e)))
                else:
                        try:
                                xbmc.log(u'{0}:{1} {2}'.format(__plugin_name__, _decode(msgerror), _decode(e)).encode('utf8'))
                        except:
                                xbmc.log(u'{0}:{1} {2}'.format(__plugin_name__, _decode(msgerror), pformat(e)).encode('utf8'))

