# -*- coding: utf-8 -*-

import os
import sys
import re
import time

try:
    from sqlite3 import dbapi2 as sqlite
except:
    from pysqlite2 import dbapi2 as sqlite

from xbmcup.app import Handler, Link, Lang
from xbmcup.errors import _decode

import xbmc, xbmcgui, xbmcplugin, xbmcvfs


class HistoryDB:
    def __init__(self, filename):
        self.filename = filename
        
        if not xbmcvfs.exists(self.filename):
            self._connect()
            self.cur.execute('pragma auto_vacuum=1')
            self.cur.execute('create table history(addtime integer, content varchar(32), id varchar(500))')
            self.cur.execute('create index time on history(addtime desc)')
            self.db.commit()
            self._close()
    
    def get(self):
        self._connect()
        self.cur.execute('select content,id from history order by addtime desc')
        res = [{'content': x[0], 'id': x[1]} for x in self.cur.fetchall()]
        self._close()
        return res
        
    def add(self, content, id):
        self.delete(content, id)
        self._connect()
        self.cur.execute('insert into history(addtime,content,id) values(?,?,?)', (int(time.time()), content, id))
        self.db.commit()
        self._close()
    
    def delete(self, content, id):
        self._connect()
        self.cur.execute('delete from history where content=? and id=?', (content, id))
        self.db.commit()
        self._close()
    
    def _connect(self):
        self.db = sqlite.connect(self.filename)
        self.cur = self.db.cursor()
    
    def _close(self):
        self.cur.close()
        self.db.close()


class History(Handler):
    def handle(self):
        history = HistoryDB(self.path('history.db'))
        
        if 'content' in self.argv:
            history.delete(self.argv['content'], self.argv['id'])
            xbmcgui.Dialog().ok(self.nameaddon, 'Поисковая фраза удалена')
        
        
        data = history.get()
        if not data:
            xbmcgui.Dialog().ok(self.nameaddon, 'История поиска пока пуста')
            return True
        else:

            
            total = len(data)

            for d in data:
                
                # поиск по имени
                popup =[ (Link('catalog', {'search': True, 'textsearch': d['id']}, True), 'Поиск') ]

                
                # удалить из истории
                popup.append( (Link('history', {'content': d['content'], 'id': d['id']}), 'Удалить из истории поиска', True, True) )

                # настройки плагина
                popup.append( self.popup[1] )

                self.item(Link('catalog', {'search': d['id'], 's_kbd': True}), title=d['id'], media='video', popup=popup, popup_replace=True, total=total)
        

def HistoryAdd(search):
        HistoryDB(Handler().path('history.db')).add('megapeer', _decode(search))
        return True


