# -*- coding: utf-8 -*-

import sys
import os
sys.path.append(os.path.dirname(__file__))
import time
import hashlib
import threading
import bencode
import json
from config import TORRSERVED_HOST, TORRSERVED_SUBS, TORRSERVED_SAVE, PY2
from client import client, touch, MyHandler, getTSVer, Mto1
if PY2:
       from urllib import urlencode, quote_plus
       from urllib2 import build_opener
else:
       unicode = str
       from urllib.parse import urlencode, quote_plus
       from urllib.request import build_opener

try:
    import xbmcplugin
    import xbmc
except:
    class xbmc:
        @staticmethod
        def sleep(t):
            time.sleep(t/1000)

        @staticmethod
        def executebuiltin(s):
            pass

try:
    import xbmcgui
except:
    class xbmcgui:
        class DialogProgress:
            def __init__(self):
                self._is = False

            def create(self, *argvs):
              pass

            def update(self, *argvs):
              pass

            def iscanceled(self):
              return self._is

            def close(self):
              self._is = True


def _en(s):
   return s.encode('utf8') if PY2 else s


def no_log(s):
   pass


def humanizeSize(size):
        B = u"б"
        KB = u"Кб"
        MB = u"Мб"
        GB = u"Гб"
        TB = u"Тб"
        UNITS = [B, KB, MB, GB, TB]
        HUMANFMT = "%.2f %s"
        HUMANRADIX = 1024.

        for u in UNITS[:-1]:
                if size < HUMANRADIX : return HUMANFMT % (size, u)
                size /= HUMANRADIX

        return HUMANFMT % (size,  UNITS[-1])


class Engine(object):

    def __init__(self, path=None, index=None, data=None, host=None, port=None, subtitles=None, save=None, log=no_log):
        self.log = log
        self.log('---start---')
        self.magneturi = None
        self.hash = None
        self.metainfo = None
        self.filestats = None
        self.fileid = None
        self.files = None
        self.index = None
        self.subtitles = None
        self.findsubtitles = False
        self.save = None
        self.tsv = getTSVer()

        if index: self.fileid = int(index)
        else: self.fileid = 0
        self.index = self.fileid

        if save is None: self.save = TORRSERVED_SAVE
        else: self.save = save

        if path:
           data = open(path, 'rb').read()

        if data:
           self.metainfo = metainfo = bencode.bdecode(data)
           self.hash = infohash = hashlib.sha1(bencode.bencode(metainfo['info'])).hexdigest()
           tr = [metainfo['announce']]
           if 'announce-list' in metainfo:
                for t in metainfo['announce-list']:
                    if t: tr.append(t.pop())
           params = {
             'dn': metainfo['info']['name'],
             'tr': tr,
           }
           self.magneturi = 'magnet:?xt=urn:btih:{0}&{1}'.format(str(infohash).upper(), urlencode(params, True))
           self.log(self.magneturi)
           info = metainfo['info']
           def _decode(s):
               try:
                        return s.decode('utf8','replace')
               except:
                        return s

           def _encode(s):
               if isinstance(s, unicode): return s.encode('utf8')
               return s

           def _encode_path(p):
               for i in range(len(p)):
                  if isinstance(p[i], unicode): p[i] = p[i].encode('utf8')
               return p

           def _path(x):
               return x.get('path.utf-8', x['path'])

           t_name = info.get('name.utf-8', info['name'])
           if 'files' in info:
                 files = [dict(id=i, fullname=_decode('/'.join([t_name, '/'.join(_path(x))])), path=_encode_path(x['path']), name=_decode(_path(x)[-1]), size=x['length']) for i, x in enumerate(info['files'])]
                 self.tname = info['name'].encode('utf8') if isinstance(info['name'], unicode) else info['name']
           else:
                 files = [dict(id=0, fullname=_decode(t_name), path=[_encode(t_name)], name=_decode(t_name), size=info['length'])]
                 self.tname = '' if PY2 else b''
           self.files = files
           #self.log(self.files)
           #self.log(self.tname)

        if subtitles:
           if subtitles == True:
                self.findsubtitles = True
           elif isinstance(subtitles, list):
                self.subtitles = subtitles
        else:
           self.findsubtitles = TORRSERVED_SUBS


    def gotinfo(self):
        xbmc.executebuiltin('Dialog.Close(busydialog)')
        pDialog = xbmcgui.DialogProgress()
        pDialog.create("TorrServer", "Ждём получение информации о раздаче...")
        tInfo = []
        listing = []
        success = False
        i = 0
        while not pDialog.iscanceled() and not success:
            xbmc.sleep(500)
            if self.tsv == 2:
                 stat = Mto1(client("/stream", get_data={"stat": "true", "link": self.magneturi}))
            else:
                 stat = client("/torrent/play", get_data={"stat": "true", "link": self.magneturi})
            self.log(stat)
            self.log(' ')
            if stat is None or len(stat['FileStats']) == 0:
                xbmc.sleep(500)
                i += 1
                m = 0
                s = 0
                if i > 59:
                    m = i / 60
                s = i - (m*60)
                if i > 100:
                    if stat is None:
                        pDialog.update(i, 'Служба Torrserver не отвечает.', ' Проверьте её настройки.')
                    else:
                        pDialog.update(i, '[CR]'.join(['Информация о [B]{2}[/B] не получена за {0:02d} : {1:02d} с.'.format(m, s, _en(stat.get('Name', u'раздаче'))), 'Видимо это мертвая раздача и отсутствуют пиры.']) )
                else:
                    pDialog.update(i, 'Пытаемся подключиться к раздаче [B]{0:02d} : {1:02d}[/B] с.'.format(m, s))
                continue
            elif stat and len(stat['FileStats']) > 0:
                if self.tsv ==2:
                      tInfo = stat
                else:
                      tInfo = client("/torrent/stat", post_data={"Hash": stat['Hash']})
                self.log('---')
                self.log(tInfo)
                self.filestats = tInfo['FileStats']
                tsname = tInfo['FileStats'][self.fileid]['Path']
                dname = self.files[self.fileid]['fullname']
                if PY2: dnameold = '/'.join([self.tname, '/'.join(self.files[self.fileid]['path'])]).decode('utf8', 'replace').strip('/')
                else: dnameold = b'/'.join([self.tname, b'/'.join(self.files[self.fileid]['path'])]).decode('utf8', 'replace').strip('/')
                self.log(tsname)
                self.log(dname)
                self.log(dnameold)
                if dname == tsname or dnameold == tsname:
                     self.log('fileid ok!')
                     if self.tsv == 2: self.fileid = self.fileid + 1
                else:
                    tsid = -1
                    index = 0
                    for i in tInfo['FileStats']:
                         self.log(i)
                         if dname == i['Path'] or dnameold == i['Path']:
                                 tsid = int(i['Id'])
                                 self.log('fileid found!')
                                 break
                         index += 1
                    if tsid >= 0:
                                 self.fileid = tsid
                                 self.index = index
                pDialog.close()
                success = True
        return success

    def makePreloadDialog(self, url, hash=None, fileId=None):

        if hash is None: hash = self.hash
        if fileId is None: fileId = self.fileid
        global _stop_preload_
        _stop_preload_ = False

        def preload(url):
            try:
                o = build_opener(MyHandler())
                o.open(url)
            except BaseException as e:
                self.log(e)
            self.log('--preloaded stop--')
            global _stop_preload_
            _stop_preload_ = True

        t = threading.Thread(target=preload, args=(url, ))
        t.start()

        pDialog = xbmcgui.DialogProgress()
        pDialog.create("TorrServer", '[CR]'.join(["Ждём получение информации о раздаче...", "Подключено: {0} | Активных: {1} | Всего: {2}".format(0, 0, 0)]) )
        success = False
        counter = 0
        name = ""
        while not pDialog.iscanceled() and not success:
            if pDialog.iscanceled():
                pDialog.close()
                if self.tsv == 2:
                     client("/torrents", post_data={"action":"drop", "Hash": hash})
                else:
                     client("/torrent/drop", post_data={"Hash": hash})
                break
            time.sleep(0.5)
            if self.tsv == 2:
                  stat = Mto1(client("/stream", get_data={"link": hash, 'stat':'true'}))
            else:
                  stat = client("/torrent/stat", post_data={"Hash": hash})
            self.log('--preload start--')
            #self.log(stat)
            if stat is None:
                counter += 1
                if counter < 60:
                    time.sleep(0.5)
                    continue
                else:
                    #notify("Time is over")
                    pDialog.close()
                    break
            else:
                if name == "":
                    if stat['FileStats']:
                        for f in stat['FileStats']:
                            if int(f['Id']) == int(fileId):
                                name = f['Path'][f['Path'].rfind('/')+1:]
                    else:
                         name = stat['Name']
                self.log('--calculate preload--')
                downSpeed = humanizeSize(stat.get('DownloadSpeed', 0))
                preloadedBytes = stat.get('PreloadedBytes', 0)
                preloadSize = stat['PreloadSize']
                self.log(preloadedBytes)
                line2 = "Подключено: {0} | Активных: {1} | Всего: {2}".format(stat.get('ConnectedSeeders', 0), stat.get('ActivePeers', 0), stat.get('TotalPeers', 0))
                line3 = u"D: {0}/сек [{1}/{2}]".format(downSpeed, humanizeSize(preloadedBytes), humanizeSize(preloadSize))
                if preloadSize > 0 and preloadedBytes < preloadSize:
                    prc = preloadedBytes * 100 / preloadSize
                    if prc > 100:
                        prc = 100
                    pDialog.update(int(prc), '[CR]'.join([_en(name), line2, _en(line3)]) )
                if preloadedBytes >= preloadSize or (self.tsv == 2 and _stop_preload_): #preloadedBytes >= preloadSize*0.5):
                    success = True
                    pDialog.close()
                    break
        #t.join()
        return success

    def loadsubtitles(self):
        if self.findsubtitles and self.filestats:
                self.log('-- loadsubtitles start --')
                success = True
                self.prev_name = ''
                self.rus = ''
                def cfname(name, rus=''):
                        if '/' in name: name = name.split('/')[-1]
                        if (name == self.prev_name) and (rus == self.rus): name = name[:name.rfind('.')] + u'_2_' + name[name.rfind('.'):]
                        self.prev_name = name
                        self.rus = rus
                        if rus and (rus.lower() not in name.lower()): name = name[:name.rfind('.')] + rus + name[name.rfind('.'):]
                        elif rus and (rus.lower() in name.lower()): name = name.replace(rus.lower(), rus).replace(rus.upper(), rus)
                        return name
                findfullname = self.filestats[self.index]['Path']
                findname = findfullname
                if '/' in findname:
                                findname = findname.split('/')[-1]
                findname = findname[:findname.rfind('.')]
                self.log(findname)
                index = 0
                temp_list = []
                for i in self.filestats:
                        name = i['Path']
                        if findname in name:
                                if index != self.index:
                                        if '.' in name:
                                                ext = name.split('.')[-1]
                                                if ext in ('srt', 'ass', 'ssa', 'smi'):
                                                        fileid = int(i['Id'])
                                                        temp_list.append( (index, fileid, name) )
                        index += 1
                self.log(temp_list)
                self.log('---')
                if temp_list !=[]:
                        temp_rus = []
                        temp_eng = []
                        temp_other = []
                        del_list = []
                        for f in range(len(temp_list)):
                                i = temp_list[f]
                                n = i[2].lower()
                                if '/rus/' in n:
                                        if ('.forc' in n) or ('_forc' in n) or ('rus forc' in n):
                                                temp_rus.insert( 0, (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                        else:
                                                temp_rus.append( (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                        del_list.insert(0, f)
                                elif '/eng/' in n:
                                        temp_eng.append( (i[0], i[1], cfname(i[2], '.Eng'), i[2] ) )
                                        del_list.insert(0, f)
                        for i in del_list: del temp_list[i]
                        for i in temp_list:
                                n = i[2].lower()
                                if ('.rus' in n) or ('_rus' in n) or ('_ru.' in n):
                                        if ('.forc' in n) or ('_forc' in n) or ('rus forc' in n):
                                                temp_rus.insert( 0, (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                        else:
                                                temp_rus.append( (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                elif ('.eng' in n) or ('_eng' in n): temp_eng.append( (i[0], i[1], cfname(i[2], '.Eng'), i[2] ) )
                                elif 'rus ' in n:
                                        if ('.forc' in n) or ('_forc' in n) or ('rus forc' in n):
                                                temp_rus.insert( 0, (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                        else:
                                                temp_rus.append( (i[0], i[1], cfname(i[2], '.Rus'), i[2] ) )
                                elif 'eng ' in n: temp_eng.append( (i[0], i[1], cfname(i[2], '.Eng'), i[2] ) )
                                else: temp_other.append( (i[0], i[1], cfname(i[2]), i[2] ) )
                        if temp_rus == [] and temp_other:
                                i = temp_other[0]
                                temp_rus.append( (i[0], i[1], cfname(i[3], '.Rus'), i[3] ) )
                                del temp_other[0]
                        temp_l = []
                        temp_l.extend(temp_rus)
                        temp_l.extend(temp_eng)
                        temp_l.extend(temp_other)
                        self.log(temp_l)
                        subtitles = []
                        for i in temp_l:
                                        if self.tsv == 2:
                                           uname = "/stream?link="+str(self.hash).lower()+"&index="+str(i[1])+"&play"
                                        else:
                                           uname = "/torrent/view/"+str(self.hash).lower()+"/"+quote_plus(i[3].replace('/','_').replace('(','_').replace(')','_').replace('[','_').replace(']','_').replace(',','_').replace('+','_').replace("'","_").replace('!','_').replace('&','_').encode('utf8')).replace('+','_').replace('__','_')
                                        self.log(uname)
                                        data = client(uname)
                                        #self.log(data)
                                        if data:
                                                try:
                                                        from xbmcup.app import Handler
                                                except:
                                                        class Handler:
                                                                @staticmethod
                                                                def path(*path):
                                                                        p = [os.path.dirname(__file__)]
                                                                        p.extend(path)
                                                                        print(p)
                                                                        return os.path.join(*p)
                                                sdir = Handler().path('subtitles')
                                                if not os.path.isdir(sdir): os.mkdir(sdir)
                                                fname = Handler().path('subtitles', i[2])
                                                open(fname, 'wb').write(data)
                                                subtitles.append(fname)
                                        else:
                                                self.log('error loading subtitles!')
                                                success = False
                                                break
                        if subtitles !=[]: self.subtitles = subtitles
                else:
                        self.log('subtitles not found!')
                self.log('-- loadsubtitles stop --')
                return success
        return False

    def play(self):
        if self.tsv == 2:
             playuri = TORRSERVED_HOST + "/stream?link="+self.magneturi+"&index="+str(self.fileid)+"&preload"
        else:
             playuri = TORRSERVED_HOST + "/torrent/play?link="+self.magneturi+"&file="+str(self.fileid)
        if self.save: playuri += "&save=true"
        #touch(playuri)
        self.log(playuri)
        if self.makePreloadDialog(url=playuri):
            self.log('--play--')
            if self.tsv == 2: playuri = playuri.replace('&preload','&play')
            self.log(playuri)
            from xplayer import xPlayer, abortRequested
            Player = xPlayer(hash=self.hash, index=self.index)
            item = xbmcgui.ListItem(path=playuri)
            if self.subtitles:
                   item.setSubtitles(self.subtitles)
            xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, item)
            while not xbmc.Player().isPlaying() and not abortRequested():
               xbmc.sleep(100)
            # Wait until playing finished or abort requested
            while not abortRequested() and xbmc.Player().isPlaying():
                    xbmc.sleep(500)

#            if self.tsv == 2:
#               client("/torrents", post_data={"action":"drop", "Hash": self.hash})
#            client("/torrent/drop", post_data={"Hash": self.hash})
            return True
        if self.tsv == 2:
             client("/torrents", post_data={"action":"drop", "Hash": self.hash})
        else:
             client("/torrent/drop", post_data={"Hash": self.hash})
        return False

    def add(self, title=None, info=None, poster=None):
        if isinstance(info, dict):
                if poster is None:
                   poster = info.get('poster_path', info.get('kodi',{}).get('info',{}).get('cover'))
                info = json.dumps(info)
        if self.tsv == 2:
             res = client('/torrents', post_data={'action':'add', 'Link':self.magneturi, 'save_to_db':True, 'Title':title, 'Poster':poster, 'Data':info})
        else:
             res = client('/torrent/add', post_data={'Link':self.magneturi, 'Title':title, 'Info':info})
        return res


def play(path=None, index=None, data=None, subtitles=None, save=None, log=no_log):
    ts = Engine(path=path, data=data, index=index, subtitles=subtitles, save=save, log=log)
    r = ts.gotinfo()
    if r:
       s = ts.loadsubtitles()
    if r:
       r = ts.play()
    return r

def add(path=None, index=None, data=None, subtitles=None, save=None, title=None, info=None, poster=None, log=no_log):
    ts = Engine(path=path, data=data, index=index, subtitles=subtitles, save=save, log=log)
    r = ts.add(title, info, poster)
    return r


if __name__ == '__main__':

        path = '/home/osmc/.kodi/temp/plugin_rutracker_cache.torrent'
        file_id = 0 #3 #0

        def log(s):
                print(s)

                with open('engine.log', 'a') as f:
                        try:
                                f.write(unicode(s).encode('utf-8'))
                        except:
                                f.write(str(s))
                        f.write('\n')


        ######
        #
        play(path, file_id, subtitles=True, log=log)
        #info = {'originaltitle':u'test 2 первый второй', 'year': 1999}
        #print add(path, title='test tttttttttttttttttttttaaaaaaaaaaaaaaaaaaaa2', info={'poster_path':'/home/osmc/.kodi/addons/plugin.video.rutor.audio/icon.png', 'descript': u'test test1 тест', 'kodi':{'info':info}})

        #e = Engine(path=path, index=file_id, log=log)
        #e.gotinfo()
        #e.play()

#        z = client('/torrent/shortlist', post_data={'Info': 1, 'Request': 0})
#        print z
#        print z[0]
#        for t in z:
#                if t['Status'] > 0: print t
        #        if t['Hash'] == e.hash:
        #                print t['Files']
#        while True:
#        z = client('/torrent/stat', post_data={'Hash': 'a123456789abcdef0123456789ABCDEF0123456F'})
#        z = client('/torrent/stat', post_data={'Hash': ''})
#        z = client('/torrent/preload/b123456789abcdef0123456789ABCDEF0123456F/test.jpeg', get_data={})
#        z = client('/torrent/view/1a23456789abcdef0123456789ABCDEF0123456F/test.jpeg', get_data={})
#        print z
#        z = client('/torrent/viewed/shortlist', post_data='')
#        print z
#        z = client('/torrent/info/shortlist', post_data='')
#        print z
#        x = client('/torrent/info/add', post_data={'hash': '1234567890abcdef1234567890abcdef12345678', 'info': json.dumps({'test4':'tyt'}) })
#        print x
#        for i in z[5:7]:
#                print(i)
#                f = i #'1234567890abcdef1234567890abcdef12345678'
#                y = client('/torrent/viewed/get', post_data={'hash': f})
#                print(y)
#                print z[i]
#                break
#                if i =='1234567890abcdef1234567890abcdef12345678':
#                        y = client('/torrent/info/get', post_data={'hash': i})
#                        print(y)
#                        z = client('/torrent/info/remove', post_data={'hash': i})
#                z = client('/torrent/viewed/add', post_data={'hash': i, 'title': 'test.avi'})
#                z = client('/torrent/viewed/drop', post_data={'hash': i, 'title': 'test.avi'})
#        print(len(z))

        

#        z = client('/torrents', post_data={'action': 'list'})
#        print z
#        x = client('/torrents', post_data={'action': 'get', 'hash':z[0]['hash']})
#        print x

#        x = client('/playlistall/all.m3u', get_data={})
#        print x


#        x = client('/stream', get_data={'link': z[0]['hash'], 'stat':''})
        print()
#        print x

        print(getTSVer())

