# -*- coding: utf-8 -*-

import sys, os
import re
import socket
import random, time
from xbmcup.utils23 import *
socket.setdefaulttimeout(20)

site_url = 'http://megapeer.ru'

COOKIE = 'megapeer.moz'

try:
	from xbmcup.app import _setting
	#_quality_ = _setting['quality']
	_domain_ = _setting['site_domain']
	_proxytype_ = int(_setting['proxy_type'])
	#_subtitles_ = bool(_setting['view_subtitles'] == 'true')
	_get_domain_ = bool(_setting['get_domain'] == 'true')
	_kodi_ = True
	if _domain_:
		_domain_ = _domain_.replace('https://', '').replace('http://', '').strip('/').strip()
		if _domain_:
			if _setting['use_https'] == 'true': site_url = 'https://' + _domain_
			else: site_url = 'http://' + _domain_
except Exception:
	_get_domain_ = False
	_kodi_ = False
	#_subtitles_ = True
	_proxytype_ = 0
	#_setting = {}
	sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'script.module.beautifulsoup4', 'lib'))


headers = {
	'User-Agent': 'Mozilla/5.0 (Android 8.1.0; Mobile; rv:67.0) Gecko/67.0 Firefox/67.0',
	#'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:67.0) Gecko/20100101 Firefox/67.0',
	#'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; rv:10.0.2) Gecko/20100101 Firefox/10.0.2',
	'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
	'Accept-Language': 'ru-ru,ru;q=0.8,en-us;q=0.5,en;q=0.3',
	'Accept-Encoding': 'gzip',
	'Cache-Control': 'no-cache',
	'Referer': site_url
	}


class Error(Exception):
	def __init__(self, msg):
		self.msg = msg

	def __str__(self):
		return '{}'.format(self.msg)

def urlp(url):
	try:
		return url.decode('ascii')
	except:
		if isinstance(url, unicode):
			url = url.encode('cp1251')
		url = quote(url, ':/?&=%+')
		return url


def getUrl(url, rurl=False, rheaders=False, referer=None, proxy=None):
	from xbmcup.net import HTTP
	http = HTTP()
	url = urlp(url)
#	if isinstance(url, unicode):
#		url = url.encode('utf8')
	if referer: headers['Referer'] = referer
	if not proxy and _proxytype_ and url.startswith(site_url):
		proxy = _setting['proxy_serv']
	if proxy:
		response = http.fetch(url, headers=headers, cookies=COOKIE, proxy_protocol=url.split(':')[0], proxy_host=proxy.split(':')[0], proxy_port=proxy.split(':')[1])
	else:
		response = http.fetch(url, headers=headers, cookies=COOKIE)
	if response.code == 200:
		if rurl:
			return response.url , response.body
		elif rheaders:
			return response.headers, response.body
		else:
			return response.body
	else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def postUrl(url, param, proxy=None):
	from xbmcup.net import HTTP
	http = HTTP()
	if isinstance(url, unicode):
		url = url.encode('utf8')
	if not proxy and _proxytype_ and url.startswith(site_url):
		proxy = _setting['proxy_serv']
	if proxy:
		response = http.fetch(url, method='POST', params=param, headers=headers, cookies=COOKIE, proxy_protocol=url.split(':')[0], proxy_host=proxy.split(':')[0], proxy_port=proxy.split(':')[1])
	else:
		response = http.fetch(url, method='POST', params=param, headers=headers, cookies=COOKIE)
	if response.code == 200:
			return response.url , response.body
	else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def GetProxyList():
	import httplib
	conn = httplib.HTTPConnection("antizapret.prostovpn.org")
	conn.request("GET", "/proxy.pac", headers={"User-Agent": 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)'})
	r1 = conn.getresponse()
	data = r1.read()
	conn.close()
	proxylist = re.compile('PROXY (.+?); DIRECT').findall(data)
	#print proxylist
	return proxylist

def proxy_update():
	return GetProxyList()[0]

if _proxytype_ == 1:
		try: pt=float(_setting['proxy_time'])
		except: pt=0
		if time.time()-pt > 86000:
			proxy1 = proxy_update()
			try:
				_setting['proxy_time'] = str(time.time())
				_setting['proxy_serv'] = proxy1
			except:
				#print proxy1
				pass


def r_u(url):
	if url.startswith(site_url): return url.replace(site_url,'')
	else: return url

def n_u(url):
	if ('://' in url) or (url is None): return url
	elif (url[0] != '/'): return site_url + '/' + url
	else: return site_url + url

def strtonumb(s):
	if 'kB' in s: return int(float(s.replace('kB', '').strip())*1024)
	if 'MB' in s: return int(float(s.replace('MB', '').strip())*1024*1024)
	if 'GB' in s: return int(float(s.replace('GB', '').strip())*1024*1024*1024)

def pars(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser', from_encoding='windows-1251')

	c = soup.findAll('h2')
	genres = []
	category = []
	for i in c:
		uc = i.find('a')
		if uc:	url_cat = uc['href']
		else: url_cat = 0
		category.append( (i.text, url_cat ) )
		genres.append( ( '[COLOR gold]'+i.text+':[/COLOR]', url_cat ) )
		a = i.findNext('h3')
		b = a.findAll('a')
		for j in b:
			text = j.text
			if text == '': text = j['href'].split('/')[-1]
			#if text == u'Софт': break
			genres.append( ( text, j['href'] ) )

	return { 'genres': genres, 'glav': category[2:] }


def pars2(data, is_sort=False):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser', from_encoding='windows-1251')
	from xbmcup.html import Clear

	i = soup.findAll('td', 'torrents')
	v_temp_list = []
	podbor_list = []
	ni = None
	#i = v[0]
	#print i
	#for i in v:
	if i:
		#x = i.findAll('tr', re.compile('(?:tum|gai)'))
		#n = i[0]
		#print n
		ni = i[-1]
		for n in i:
		#if n:
			comments = None
			img = None
			magnet = None
			date = None
			seeders = None
			leechers = None
			yqt = ''
			info = {}

			p = n.find('a')
			tsize = p.text.split('[')[1].split(']')[0]
			info['size'] = strtonumb(tsize)
#			print tsize
			torrent = r_u( p['href'] )
#			print torrent
			b = p.findNext('a')
			url = r_u( b['href'] )
#			print url_s
			im = b.find('img')
			if im:	img = im['src']
			c = b.findNext('a')
			url_f = r_u( c['href'] )
			info['title'] = c.text
			yr = re.compile('(\d{4})',re.U|re.S).search(c.text)
			if yr: info['year'] = int(yr.group(1))
#			print url, info
			v_temp_list.append( {'url': url, 'thumb': img, 'info': info, 'yq': yqt, 'date': date, 'tsize': tsize, 'torrent': torrent, 'magnet': magnet, 'seed': seeders, 'leech': leechers, 'comment': comments} )
		#print v_temp_list

	i = soup.find('tbody')
	if i:
		ni = i
		#n = i[0]
		#print n
		for n in i.findAll('tr', 'tCenter hl-tr'):
		#if n:
			comments = None
			img = None
			magnet = None
			date = None
			seeders = None
			leechers = None
			yqt = ''
			info = {}

			im = n.find('img')
			if im:	img = im['src']
			p = n.find('p')
			date = p.text
#			print date
			a = p.findNext('a', 'online')
			if a:
				category = (a.text, r_u(a['href']) )
#				print category
			else: a = p
			c = a.findNext('a')
			url = r_u( c['href'] )
			info['title'] = c.text
			yr = re.compile('(\d{4})',re.U|re.S).search(c.text)
			if yr: info['year'] = int(yr.group(1))
			d = c.findNext('a')
			torrent = r_u(d['href'])
#			print torrent
			tsize = d.text
			info['size'] = strtonumb(tsize)
#			print url, info
			e = d.findNext('div', 'torrent-info')
			fc = e.text.split('|')
			files = fc[0].strip()
			comments = fc[1].strip()
#			print comments
			v_temp_list.append( {'url': url, 'thumb': img, 'info': info, 'yq': yqt, 'date': date, 'tsize': tsize, 'torrent': torrent, 'magnet': magnet, 'seed': seeders, 'leech': leechers, 'comment': comments} )


	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	pg = None
	if ni: pg = ni.findNext('table')
#	print pg
	if pg:
		t = pg.findAll('a')
		cu = pg.findAll('b')
#		print t
#		print cu
		try: page['max'] = int(cu[-2].text)
		except:
			try: page['max'] = int(cu[-3].text)
			except:
				page['max'] = -1
		#try: page['current'] = int(cu[0].text.split('-')[1])/100
		#except: page['current'] = int(cu[1].text.split('-')[1])/100
		for i in t:
			if u'\xbb' in i.text:
				page['next'] = i['href']
				page['current'] = int(i['href'].split('page=')[1])
			if u'Прев' in i.text: page['prev'] = i['href']
#		print page

	""" #

	else:
		pg = soup.find('b')
		#print pg
		if pg:
			t = pg.findAll('a')
			try: page['max'] = int(t[-1].text)
			except: pass
			try:
				lp =  pg.text.split(':')[-1].strip().split(' ')
				ap = [n.text.strip() for n in t]
				#print lp
				#print ap
				for n in ap: lp.remove(n)
				page['current']  = int(lp[0])
			except: pass
			for i in t:
				if int(i.text) == page['current']+1: page['next'] = i['href']
				if int(i.text) == page['current']-1: page['prev'] = i['href']
			#print page
	"""

	sort_list = []
	if is_sort and (page['current'] == 1):
		names = []
		n = soup.findAll('span', 'dropdown-u')
		if n:
			for i in n:
				names.append( i.text )
			v = soup.findAll('ul', 'dropdown-menu')
			for i, name in zip(v, names):
				sort_name = name+u': '
				actives_name = []
				a = i.findAll('li', 'active')
				if a:
					for a1 in a:
						a2 = a1.find('a')
						if a2:
							actives_name.append( a2.text)
					sort_param = u', '.join(actives_name)
				else:
					sort_param = u'Все'
					a = i.findAll('a', 'active')
					if a:
						for a2 in a:
							actives_name.append( a2.text)
						sort_param = u', '.join(actives_name)
				sort_name = u''.join([u'[COLOR green]', sort_name, sort_param, u'[/COLOR]'])
				#print sort_name
				all_sort = []
				for j in i.findAll('a'):
					s_name = j.text
					if s_name in actives_name: s_name = u'[COLOR gold]' + s_name + u'[/COLOR]'
					all_sort.append( (s_name, j['href']) )
				#print all_sort
				sort_list.append( {'name': sort_name, 'sort': all_sort} )
	return {'data': v_temp_list, 'page': page, 'podbor': podbor_list, 'filter': sort_list}


def pars3(data):
	r = re.compile(b'<table id="detali"[^>]*?><tr>(.+?)</tr>',re.S).search(data) #фикс бага парсинга
	if r: data = r.group(1)
	#print r.group(1)
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser', from_encoding='windows-1251')
	from xbmcup.html import Clear

	#print soup
	#ur= soup.find('meta', property='og:url')
	#url = ur['content']

	p = soup
	#p = soup.find('table', id='detali')
	content_list = []
	podbor_list = []
	if p:
		#print p
		cover = None
		tr = p
		#tr = p.find('tr')
		img = tr.find('img')
		if img:
			cover = img['src']
			if 'rublacklist.net' in cover: img = img.findNext('img')
			if 'changecopyright.ru' in cover: img = img.findNext('img')
			if img: cover = img['src']
		text = Clear().text( unicode(tr).replace('<b>','[COLOR FF0DA09E]').replace('</b>','[/COLOR]') )
		return { 'text':  text, 'cover': cover }



		info = {}
		r = p.find('h1')
		if r: info['title'] = Clear().string(r.text.split(' ', 2)[2])
		t = r.findNext('img')
		if t: img = n_u( t['src'] )

		#print info['title'], url, img
		g = p.find('ul', 'reset full-items')
		if g:
			text = ''.join(g.findAll(text=True))
		strana = False
		for j in text.splitlines():
			#print j
			if u'Оригинальное название:' in j: info['originaltitle'] = j.split(':')[1].strip()
			#if strana:
			#	if j.strip() != u'':
			#		info['studio'] = j.strip()
			#		strana = False
			if u'Добавлено:' in j: info['studio'] = j[j.find(':')+1:].strip()   #strana = True
			if u'Жанр:' in j: info['genre'] = j.split(':')[1].strip()
			if u'Цикл:' in j: info['mpaa'] = j.split(':')[1].strip()
			if u'Автор:' in j:
				info['writer'] = j.split(':')[1].strip()
				info['album'] = info['writer']
			if u'Читает:' in j:
				info['director'] = j.split(':')[1].strip()
				info['artist'] = info['director']
			if u'Продолжительность:' in j:
					dc = re.compile(u'([\d+]+)',re.S).search(j)
					if dc:
						#ts = dc.group(1).split(':')
						#info['duration'] = int(ts[0])*60*60+int(ts[1])*60+int(ts[2])
						info['duration'] = int(dc.group(1))*60
			if u'Качество:' in j:
				info['plotoutline'] = j.split(':')[1].strip()
			if u'Длительность:' in j: info['tagline'] = j[j.find(':')+1:].strip()
			if u'Год:' in j:
					year = j.split(':')[1].strip()
					if year !='':
						if '-' in year: year = year.split('-')[1]
						info['year'] = int(year)
			if u'Актеры:' in j:
				info['cast'] = [i.strip() for i in j.split(':')[1].split(',') if i]


		#o = p.find('div','short-text')
		#if o:
		#print unicode(p)
		r = re.compile(u' mp3, прочти описание\:(.+?)<br>',re.S).search(unicode(p))
		if r:
				info['plot'] = Clear().text(r.group(1))
				info['comment'] = info['plot']
				#print info['plot']

		screenshot = None
		tempcastfull = None
		content_list.append( {'url': r_u(url), 'thumb': img, 'info': info, 'cast': tempcastfull, 'screenshot': screenshot} )

	g = soup.find('div', id='releative-slider')
	if g:
		c = g.findAll('a')
		podbor_list.append( {'url': 0, 'thumb': None, 'info':{'title': '[COLOR green]Смотрите также:[/COLOR]'} } )
		#i = c[0]
		for i in c:
		#if i:
			info = {}
			url = r_u( i['href'] )
			im = i.find('img')
			info['title'] = Clear().string(im['alt'])
			img = n_u( im['src'] )
			podbor_list.append( {'url': url, 'thumb': img, 'info': info} )

	comments_list = None
	c = soup.find('div', id='dle-comments-list')
	if c:
		comments_list = []
		for i in c.findAll('div', id=re.compile('comment\-id\-\d+')):
			au = i.find('div', 'comm-info')
			avtor = au.text.strip()
			#dc = au.findNext('span')
			#datacom = dc.text.strip()
			title = avtor #+ u' от ' + datacom
			textcom = i.find('div', id=re.compile('comm\-id\-\d+')).text
			comments_list.append( (title, textcom) )
		#print comments_list

	pr_list = None
	pr = p.find('div', style="background-color: #2d2f38;font-size: 1.5em;color:#fff;padding:50px 0px 50px 0px; height:;text-align: center; border-radius:8px") #><img src="/uploads/rkn.png"><br />Извините.<br />Материал удалён по запросу правообладателя!</div>
	if pr:
		img = pr.find('img')['src']
		pr_list ={'thumb': n_u(img), 'title': pr.text}
		#print pr_list

	torrent = None
	tu = p.find('a', target='_blank')
	if tu:
		if 'download&id=' in tu['href']:
			torrent = tu['href'].strip()

	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	return {'data': content_list, 'page': page, 'podbor2': podbor_list, 'comments': comments_list, 'pr': pr_list, 'torrent': torrent }


def pars_play(data):
	r = re.compile('Playerjs\(\{\s*id\:"[^"]+",\s*file\:(.+?)\}\);',re.S).search(data)
	if r:
		#import json
		#tmp = json.loads(r.group(1))
		tmp = eval(r.group(1).strip())
		for i in range(len(tmp)):
			t = tmp[i]
			t['index'] = i
			if b'\u0' in t['title']:
				t['title'] = t['title'].decode('unicode-escape')
			elif b'u0' in t['title']:
				t['title'] = t['title'].replace(b'u0',b'\u0').decode('unicode-escape')
			else:
				t['title'] = t['title'].decode('utf8')
			tmp[i] = t
		return tmp
	return None


def pars_glav(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser', from_encoding='utf-8')

	c = soup.find('div', 'menu')
	m = c.findAll('a')

	glav = []
	for i in m:
		glav.append( (i.text, i['href'] ) )
	return {'glav': glav[2:-7]}



def catalog(url=site_url):
	if not url: url = site_url
	data = getUrl(n_u(url))
#	file('/home/osmc/catalog.txt', 'wb').write( data.decode('cp1251').encode('utf8') )
	return pars2(data)

def genres():
	data = getUrl(site_url+'/tags')
#	file('/home/osmc/categories.txt', 'wb').write( data.decode('cp1251').encode('utf8') )
	return pars(data)

def glav():
	data = getUrl(site_url)
#	file('/home/osmc/glav.txt', 'wb').write( data )
	return pars_glav(data)

def genreaudiobook():
	data = getUrl(site_url+'/categories')
	genre = pars(data)['genres']
	agenre = []
	for i in genre:
		if u']' in i[0]: start = False
		if start and u'Аудиокниги' not in i[0]: agenre.append( (i[0], u'/search/0/11/110/0/Аудиокниг* '+i[0][:-1]+'*') )
		if u']Книги' in i[0]: start = True
	for i in u'Ужасы,Сказка,Готика,Классика,литРПГ'.split(','):
		agenre.append( (i, u'/search/0/11/110/0/Аудиокниг* '+i) )
	return agenre

def authors():
	data = getUrl(n_u('/authors.html'))
	#file('/home/osmc/authors.txt', 'wb').write( data )
	return pars_authors(data)

def readers():
	data = getUrl(n_u('/readers.html'))
	#file('/home/osmc/readers.txt', 'wb').write( data )
	return pars_authors(data)

def ar_rezult(url):
	data = getUrl(n_u(url))
	#file('/home/osmc/ar_rezult.txt', 'wb').write( data )
	return pars_ar_rezult(data)

def videoinfo(url):
	data = getUrl(n_u(url))
#	file('/home/osmc/videoinfo.txt', 'wb').write( data )
	res = pars3(data)
	#res['url'] = pars_play(data)
	return res

def search(text):
	if isinstance(text, str): text = _de(text)
	if isinstance(text, unicode): text = text.encode('cp1251')
	data = getUrl(site_url+'/browse.php?search='+quote_plus(text))
	#url, data = postUrl(site_url,{'do': 'search', 'subaction':'search', 'story': text, 'submit': r'Найти' } )
	#file('/home/osmc/search.txt', 'wb').write( data )
	#if site_url == url:
	return False, pars2(data)
	#else:
	#	return True, pars3(data)

def nextsearch(text, page):
	if isinstance(text, unicode): text = text.encode('utf8')
	url, data = postUrl(site_url+'/index.php?do=search',{'do': 'search', 'subaction':'search', 'search_start': str(page), 'result_from': str((page-1)*14+1) ,'story': text, 'submit': r'Найти' } )
	#file('/home/osmc/nextsearch.txt', 'wb').write( data )
	return False, pars2(data)


def play_link(url, index=None):
	try:
		from xbmcup.errors import log
		log(url,'url=')
	except: pass
	#data = file('/home/osmc/videoinfo.txt', 'rb').read()
	data = getUrl(n_u(url))
	#file('/home/osmc/videoinfo.txt', 'wb').write(data)
	d_play = pars_play(data)
	try:
		from xbmcup.errors import log
		log(d_play,'d_play=')
	except: pass
	opt = '|'+urlencode({ 'User-Agent': headers['User-Agent'], 'Referer': n_u('/player/player.js') })
	if index or index == 0:
		return  d_play[index]['file'] + opt, None
	else:
		return d_play['file'] + opt, None


def pars_filter(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser', from_encoding='utf-8')

	f = soup.find('div', 'filter-wrap')

	if f:
		''' ###
		c = f.find('select')
		characteristics = []
		for i in c.findAll('option'):
			characteristics.append( ( i['value'], i.text ) )
			#print i['value']

		s = c.findNext('select')
		subgenre = []
		for i in s.findAll('option'):
			subgenre.append( ( i['value'], i.text ) )
			#print i['value']

		sc = s.findNext('select')
		scene = []
		for i in sc.findAll('option'):
			scene.append( ( i['value'], i.text ) )
			#print i['value']

		t = sc.findNext('select')
		time = []
		for i in t.findAll('option'):
			time.append( ( i['value'], i.text ) )
			#print i['value']

		st = t.findNext('select')
		story = []
		for i in st.findAll('option'):
			story.append( ( i['value'], i.text ) )
			#print i['value']

		y = st.findNext('select')
		year = []
		for i in y.findAll('option'):
			year.append( ( i['value'], i.text ) )
			#print i['value']
		''' ###
		sort = []
		s = f.find('select')
		for i in s.findAll('option'):
			sort.append( ( i['value'], i.text ) )
		sort.reverse()

		#sort = [ ('date', 'По дате'), ('rating', 'По популярности'), ('news_read', 'По просмотрам'), ('comm_num', 'По комментариям'), ('title', 'По алфавиту')]
		order = [ ('desc', 'По убыванию'), ('asc', 'По возрастанию') ]
	return {'sort': sort, 'order': order}

def filter():
	data = getUrl(site_url)
	return pars_filter(data)


def pars_topweek(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser', from_encoding='utf-8')
	from xbmcup.html import Clear

	g = soup.find('div', id='top-slider')
	#print g
	topw = []
	if g:
		for i in g.findAll('div', 'item'):
			info = {}
			a = i.find('a')
			url = r_u( a['href'] )
			sp = i.find('span', 'item-bg')
			im = i.find('img')
			img = n_u( im['src'] )
			info['title'] = Clear().string(im['alt'])
			topw.append( { 'url': url, 'thumb': img, 'info':info } )
	return { 'topweek': topw }

def topweek():
	data = getUrl(site_url)
	return pars_topweek(data)

def get_torrent(url):
	data = getUrl(n_u(url))
	from xbmcup.torfiles import torrent_files
	filelist = torrent_files(data)
	return data, filelist

if __name__ == '__main__':
	#print	catalog()
	#data = open('/home/osmc/categories.txt', 'rb').read()
	#print	pars(data)
	#print genres()
	#print glav()
	#data = file('/home/osmc/glav.txt', 'rb').read()
	#data = open('/home/osmc/catalog.txt', 'rb').read()
	#print	pars_glav(data)
	#print(pars2(data))
	#print	pars_filter(data)
	#print pars_topweek(data)

	#print videoinfo(pars2(data)['data'][0]['url'])
	#data = open('/home/osmc/videoinfo.txt', 'rb').read()
	#print data
	#print 	pars3(data)
	#print pars_play(data)
	#print play_link('fff', 0)

	#from xbmcup.html import Clear
	#print getUrl(site_url+'/knigi')

	#d, f = get_torrent('https://baza-knig.ru/index.php?do=download&id=43592')
	#from xbmcup import torrserver
	#def __log(s):
	#	print s
	#torrserver.play(index=0, data=d, log=__log)

	#print readers()
	#print authors()
	#data = file('/home/osmc/authors.txt', 'rb').read()
	#print pars_authors(data)

	#data = file('/home/osmc/ar_rezult.txt', 'rb').read()
	#print pars_ar_rezult(data)
	#print	search('войны')
	#print nextsearch('толстой', 2)
	#print search('стивен кинг')

#	data = file('/home/osmc/search.txt', 'rb').read()
#	print pars2(data)
#	print	pars2(data)['page']['next']
#	print	urlp(pars2(data)['page']['next'])
	#print getUrl('https://baza-knig.ru')
	pass

