# -*- coding: utf-8 -*-
# ver 1.2

__all__ = ['UrlLink', 'Link', 'Handler', 'Plugin', 'Setting', 'Lang', '_setting', '_lang']

import sys
import os

try:
	import xbmcaddon
	__settings__ = xbmcaddon.Addon(id=sys.argv[0].replace('plugin://', '').replace('/', ''))
	__domain__ = __settings__.getSetting('rutracker_url')
except:
	__settings__ = __domain__ = ''
        
                
                
class Setting(object):
    def __init__(self):
        self._cache = {
        'rutracker_lostpic': '0',
        'rutracker_unblock':'0',
        'rutracker_domain':'rutracker.org' if __domain__ == '' else __domain__,
#        'rutracker_login':'***',
#        'rutracker_password':'***',
        }
        self._addon = __settings__

        
    def __getitem__(self, key):
        try:
            return self._cache[key]
        except KeyError:
            self._cache[key] = self._addon.getSetting(id=key)
            return self._cache[key]
        
    def __setitem__(self, key, value):
        self._cache[key] = value
        self._addon.setSetting(id=key, value=value)
    
    def dialog(self):
        self._cache = {}
        self._addon.openSettings()


_setting = Setting()
