# -*- coding: utf8 -*-
import os
import sys

import xbmc
import xbmcgui
from errors import log as _log

from config import TORRSERVED_HOST
from utils import plugin, isPicture, _en
from simpleplugin import parse_qs, translatePath

@plugin.action()
def pictures(params):
    win = xbmcgui.Window(xbmcgui.getCurrentWindowId())
    curctl = win.getFocus()
    if params.thumbcache == "clear":
        thumb = xbmc.getCacheThumbName(TORRSERVED_HOST+params.link)
        thumb = thumb.split('.')[0]
#        dialog = xbmcgui.Dialog()
#        dialog.ok('Thumb', thumb+'\n'+params.link+'\n'+translatePath('special://userdata'))
        pathThumbs = os.path.join(translatePath('special://userdata'), 'Thumbnails', thumb[0])
        for ext in ('.jpg', '.png'):
                path = os.path.join(pathThumbs, thumb+ext)
                if os.path.isfile(path):
                    os.remove(path)
                    break
    numitems = int(xbmc.getInfoLabel('Container().NumItems'))
    links = []
    images = []
    index = 0
    i = -1
    for f in range(1, numitems+1):
        name = xbmc.getInfoLabel('Container().ListItemAbsolute(%s).Label' % f)
        path = xbmc.getInfoLabel('Container().ListItemAbsolute(%s).FileNameAndPath' % f)
        l = parse_qs(path.split('/?')[1])
        if 'link' in l: link = l['link'][0]
        else: link = l
        links.append(link)
        if isPicture(name):
              images.append(TORRSERVED_HOST+link)
              i += 1
              if params.link == link: index = i
    if images:
         ind = openPictures(images, index)
         link = images[ind]
         preload = link.replace(TORRSERVED_HOST, '')
         i = -1
         for f in links:
             i += 1
             if preload == f:
                   break
#         dialog = xbmcgui.Dialog()
#         dialog.ok('Name', name+'\n'+str(i+1)+'\n'+xbmc.getInfoLabel('Container().NumItems')+' - '+xbmc.getInfoLabel('Container().CurrentItem'))
#         xbmc.sleep(500)
#         pos = int(xbmc.getInfoLabel('Container().CurrentItem'))
         i += 1 # учитывать ".."
         curctl.selectItem(i)


class SlideShow(xbmcgui.WindowXMLDialog):
    ACTION_PREVIOUS_MENU = [9, 92, 10, 13]
    ID_LIST_PICTURES = 5000

    def __init__(self, *args, **kwargs):
        self.images = kwargs.get('listitems')
        self.index = kwargs.get('index')
        self.image = kwargs.get('image')
        self.action = None

    def onInit(self):
        super(SlideShow, self).onInit()
        if not self.images:
            return None
        self.getControl(self.ID_LIST_PICTURES).addItems(self.create_listitems(self.images))
        self.getControl(self.ID_LIST_PICTURES).selectItem(self.index)
        self.setFocusId(self.ID_LIST_PICTURES)

    def onAction(self, action):
        if action in self.ACTION_PREVIOUS_MENU:
            self.position = self.getControl(self.ID_LIST_PICTURES).getSelectedPosition()
            self.close()

    def create_listitems(self, img):
        items = []
        _log(img)
        j = 1
        for i in img:
                if sys.version_info.major == 2:
                    li = xbmcgui.ListItem(label=str(j),
                              iconImage=i,
                              thumbnailImage=i,
                              path = i)
#                    li.setArt({'poster': i, 'fanart': i})
                else:
                    li = xbmcgui.ListItem(label=str(j),
                              path = i)
#                    li.setArt({'poster': i, 'fanart': i, 'icon': i, 'thumb': i})
                    li.setArt({'icon': i})
                li.setProperty('show_info', 'true')
                li.setProperty('show_info', 'photo')
#                li.setProperty('title', i)
                li.setProperty('aspectratio', 'keep')
                items.append(li)
                j += 1
        _log(items)
        return items


def openPictures(listitems, index=0):
    slideshow = SlideShow(u'script-script.module.kodi65-pictureviewer.xml',
                          os.path.join(os.path.dirname(__file__), "..", "..", ".."),
                          'default', '1080i',
                          listitems=listitems,
                          index=index)
    slideshow.doModal()
    return slideshow.position
