# -*- coding: utf-8 -*-

def executeJSONRPC(q):
	import json, xbmc
	s = json.dumps(q)
	res = xbmc.executeJSONRPC(s)
	return json.loads(res)

class JSONRPC_API(object):
	def __init__(self, name):
		self._name = name

	def __getattribute__(self, name):
		_name = object.__getattribute__(self, '_name')
		def run(limits={}, sort={}, filter={}, error=True, **params):
			q = {	"jsonrpc": "2.0",
					"method": _name + "." + name,
					"params": params,
					"id": "JSONRPC_API"
			}

			if limits:
				q['params']['limits'] = limits
			if sort:
				q['params']['sort'] = sort
			if filter:
				q['params']['filter'] = filter

			try:
				res = executeJSONRPC(q)
				return res['result']
			except KeyError as e:
				if error:
					from errors import log
					log(e, 'JSONRPC error')
				return res
		return run

VideoLibrary = JSONRPC_API('VideoLibrary')
JSONRPC	= JSONRPC_API('JSONRPC')
GUI = JSONRPC_API('GUI')
Files = JSONRPC_API('Files')


"""
	playcount, runtime, director, plot, rating, votes, lastplayed, writer,
	firstaired, productioncode, season, episode, originaltitle, thumbnail,
	fanart, art, resume, userrating, ratings, dateadded,
"""

# работает только если Kodi >= 19
def resetResumeTime():
	import xbmc
	from datetime import datetime
	lastplayed = str(datetime.now()).split('.')[0]
	fpath = xbmc.getInfoLabel('ListItem.FileNameAndPath')
	setResumeTimeZero(fpath)

def setResumeTimeZero(fpath):
	res = Files.GetFileDetails(file=fpath, media='video', properties=['resume', 'playcount', 'lastplayed'])
	if res.get('filedetails', {}).get('resume', {}).get('position', 0) > 0:
		resume = {'position': 0,'total': res['filedetails']['resume']['total']}
		res2 = Files.SetFileDetails(file=fpath, media='video', resume=resume)

def resetAllResumeTime():
	import xbmc
	numitems = int(xbmc.getInfoLabel('Container().NumItems'))
	for f in range(1, numitems+1):
		path = xbmc.getInfoLabel('Container().ListItemAbsolute(%s).FileNameAndPath' % f)
		setResumeTimeZero(path)
