# -*- coding: utf-8 -*-
import os

import xbmc

from utils import plugin, _T, settingsIsOpen, notify
from client import client, getTSVer

translate = _T

@plugin.action()
def settings(params):
    if params.mod == "read":
        tsv = getTSVer()
        if tsv == 2:
            # for MatriX torrserver
            resp = client("/settings", post_data={"action": "get"})
            #xbmcgui.Dialog().textviewer('abort', str(resp))
            for k, v in resp.items():
               if k == "CacheSize":
                    v = int(v / 1024 / 1024)
               if k == "TorrentsSavePath":
                    plugin.set_setting("MatriX_"+k, v)
               else:
                    plugin.set_setting("MatriX_"+k, str(v).lower())
            plugin.openSettings()
            while settingsIsOpen():
               continue
            jset = {}
            for i in list(resp):
               if i in resp:
                  if i == "CacheSize":
                       jset[i] = plugin.get_setting("MatriX_"+i, True) * 1024 * 1024
                  else:
                       jset[i] = plugin.get_setting("MatriX_"+i, True)
            #xbmcgui.Dialog().textviewer('abort', str(resp)+"[CR]"+str(jset))
            if not resp == jset:
               client("/settings", post_data={"action":"set", "sets":jset})
               notify(translate("Settings saved! Restart service"))
#               xbmc.executebuiltin("Container.Refresh")
            #
#            return

        elif tsv != 1:
            plugin.openSettings()
#            return

        else:
          resp = client("/settings/read", post_data={"read": 1})
          for k, v in resp.items():
            if k == "CacheSize" or k == "PreloadBufferSize" or k == "Readahead":
                v = int(v / 1024 / 1024)
            if k == "TorrentsDir":
                 plugin.set_setting(k, v)
            else:
                 plugin.set_setting(k, str(v).lower())
          plugin.openSettings()
          while settingsIsOpen():
            continue
          jset = {}
          for i in list(resp):
            if i in ("CacheSize", "PreloadBufferSize", "Readahead"): jset[i] = plugin.get_setting(i, True) * 1024 * 1024
            else: jset[i] = plugin.get_setting(i, True)
          if not resp == jset:
            resp = client("/settings/write", post_data=jset)
            if resp == "Ok":
                notify(translate("Settings saved! Restart service"))
                client("/torrent/restart")
#                xbmc.executebuiltin("Container.Refresh")
            else:
                notify(translate("Settings not saved!"))
                plugin.log_error(repr(resp))
    elif params.mod == "open":
        plugin.openSettings()

    if plugin.settingsChanged: container_refresh()


def container_refresh():
    xbmc.executebuiltin('RunScript(%s)' % (os.path.join(os.path.dirname(__file__), 'refresh.py')) )
