# -*- coding: utf-8 -*-
import sys
PY2 = sys.version_info.major == 2
import os
import xbmc
import xbmcgui
from collections import OrderedDict
from torrserve.config import ADDON_NAME, ADDON_ICON, ADDON_PATH
if not PY2:
    basestring = str
    unicode = str
    xrange = range

from simpleplugin import Plugin, _de, _en, quote_plus
plugin = Plugin(main_='main')
_T = plugin.initialize_gettext()

def _de3r(s):
    return s if PY2 else s.decode('utf8', 'replace')

resolutions = OrderedDict()
resolutions['[COLOR=FFFC3401]240p[/COLOR]'] = ['240p', u'240р']
resolutions['[COLOR=FFA56F01]480p[/COLOR]'] = ['480p', u'480р', 'XviD', 'SATRip']
resolutions['[COLOR=FF539A02]720p[/COLOR]'] = ['720p', u'720р', '720i']
resolutions['[COLOR=FF0166FC]1080p[/COLOR]'] = ['1080p', u'1080р', '1080i']
resolutions['[COLOR=FFF15052]2K[/COLOR]'] = ['2K', '1440p', u'1440р']
resolutions['[COLOR=FF6BB9EC]4K[/COLOR]'] = ['4K', '2160p', u'2160р']

proxy = ""
if plugin.get_setting("block_image", True): proxy = 'http://127.0.0.1:8095/proxy/'
_tvshowLocalizeTitle_ = plugin.get_setting("tvshow_localize_title", False)
_showRating_ = plugin.get_setting("show_rating_list_discover", True)
_showYear_ = plugin.get_setting("show_year_list_discover", True)
_showGenre_ = plugin.get_setting("show_genre_list_discover", True)
_showCountry_ = plugin.get_setting("show_country_list_discover", True)
_fixRatingKodi19_ = plugin.get_setting("fix_show_rating_list_discover", True)
_fixSeasonKodi19_ = plugin.get_setting("fix_show_season_list", True)
_image_tmdb_ = 'imagetmdb.com' if plugin.get_setting("alt_tmdb_image", True) else 'image.tmdb.org'
_language_ = plugin.get_setting("LanguageID")

def pNone(p):
    return p if p !='None' else None

def getHistory(mtype):
    with plugin.get_storage('historySearch'+mtype) as storage:
         new = storage.get('keywords', [])
         if new:
               return new
         for i in xrange(10):
               title = 'title{0}'.format(i)
               s = storage.get(title)
               if s:
                    new.append(s)
                    del storage[title]
         storage['keywords'] = new
    return new

def addHistory(mtype, query):
    with plugin.get_storage('historySearch'+mtype) as storage:
       keywords = storage.get('keywords', [])
       keywords.insert(0, query)
       lenKeywords = len(keywords)
       maxLenHistory = plugin.get_setting('max_len_history', True)
       maxLenHistory = 1 if not maxLenHistory else int(maxLenHistory)
       if lenKeywords > maxLenHistory: keywords = keywords[:maxLenHistory]
       storage['keywords'] = keywords

@plugin.action('history')
def history(params):
    if params.delete:
        with plugin.get_storage('historySearch'+params.type) as storage:
            keywords = storage['keywords']
            del keywords[int(params.delete)]
            storage['keywords'] = keywords
        xbmc.executebuiltin("Container.Refresh")
        return
    elif params.search:
        with plugin.get_storage('historySearch'+params.type) as storage:
            keywords = storage['keywords']
            query_old = keywords[int(params.search)]
        dialog = xbmcgui.Dialog()
        query = dialog.input(_T("Поиск"), defaultt=query_old, type=xbmcgui.INPUT_ALPHANUM)
        if query == "":
               return False
        if query != query_old: addHistory(params.type, query)
        purl = params.url.replace('=%7B%7D', '={}')
#        dialog.textviewer('debug', params.url+'\n\n'+query+'\n\n'+purl)
        purl = purl.format(quote_plus(_en(query)))
        xbmc.executebuiltin("Container.Update(%s)" % purl)


def showHistory(listing, mtype, func_url, func_url_filter=None):
    keywords = getHistory(mtype)
    if keywords:
              lenKeywords = len(keywords)
              for i in xrange(lenKeywords):
                        item = {
                            'label': keywords[i],
                            'url': func_url(keywords[i]),
                            'icon': os.path.join(ADDON_PATH, "resources", "img", "search.png"),
                            'is_playable': False,
                            'is_folder': True,
                            "context_menu": [(
                                _T("Поиск"),
                                "RunPlugin(%s)" % plugin.get_url(action="history", type=mtype, search=i, url=func_url("{}")),
                              ),(
                                _T("Remove query"),
                                "RunPlugin(%s)" % plugin.get_url(action="history", type=mtype, delete=i),
                              ),(
                                _T('Settings'),
                                'RunPlugin({0})'.format(plugin.get_url(action='settings', mod='read')),
                            )]
                        }
                        if func_url_filter:
                           item["context_menu"].insert(1, ( _T("Поиск с фильтром"),
                            "RunPlugin(%s)" % plugin.get_url(action="history", type=mtype, search=i, url=func_url_filter("{}")) ))
                        listing.append(item)
    return listing


def humanizeSize(size):
    B = u"б"
    KB = u"Кб"
    MB = u"Мб"
    GB = u"Гб"
    TB = u"Тб"
    UNITS = [B, KB, MB, GB, TB]
    HUMANFMT = "%.2f %s"
    HUMANRADIX = 1024.

    for u in UNITS[:-1]:
        if size < HUMANRADIX: return HUMANFMT % (size, u)
        size /= HUMANRADIX

    return HUMANFMT % (size, UNITS[-1])


def notify(message, header=ADDON_NAME, time=5000, image=ADDON_ICON):
    dialog = xbmcgui.Dialog()
    return dialog.notification(toUtf8(header), toUtf8(message), toUtf8(image), time, False)


def toUtf8(string):
    if isinstance(string, unicode):
        return string.encode('utf-8', 'ignore')
    return string


def settingsIsOpen():
    return xbmc.getCondVisibility('Window.IsVisible(10140)') or xbmc.getCondVisibility('Window.IsActive(10140)') or xbmc.getCondVisibility('Window.IsVisible(12002)')


def makeMovieItem(i, remDate=False, size=None, showRating=_showRating_, fixRatingKodi19=_fixRatingKodi19_, image=_image_tmdb_):
    trailer = id = studio = ""
    genre = []
    country = []
    casts = []
    directors = []
    writers = []
    if 'trailers' in i and len(i['trailers']['youtube']):
        try:
            id = i['trailers']['youtube'][1]['source']
        except:
            id = i['trailers']['youtube'][0]['source']
        finally:
            trailer = "plugin://plugin.video.youtube/play/?video_id={0}".format(id)

    rating = None
    try:
        for rat in i['release_dates']['results']:
            if rat['iso_3166_1'] == "RU":
                rating = rat['release_dates'][0]['certification']
                if rating: break
            elif rat['iso_3166_1'] == 'US':
                rating = rat['release_dates'][0]['certification']
    except:
        pass

    try:
        for genreName in i['genres']:
            genre.append(genreName['name'])
    except:
        try:
            for id in i['genre_ids']:
               genre.append(genres.get(id, str(id)))
        except:
            genre = []

    try:
        for cName in i['production_countries']:
            if _language_ == 'ru':
                 country.append(ruCountry(cName['iso_3166_1']))
            else:
                 country.append(cName['name'])
    except:
        country = []

    try:
        for c in i['credits']['cast']:
            casts.append({
                'name': c['name'],
                'role': c['character'],
                'order': c['order'],
                'thumbnail': "{1}https://{2}/t/p/w342{0}".format(c['profile_path'], proxy, image) if c['profile_path'] else '',
            })
    except:
        casts = []

    try:
        for dName in i['credits']['crew']:
            if dName['job'] == "Director":
                directors.append(dName['name'])
            elif dName['department'] == "Writing":
                writers.append(dName['name'])
    except:
        directors = []
        writers = []

    try:
        studio = i.get('production_companies')[0]['name']
    except:
        studio = ""
    duration = 0
    try:
        duration = int(i.get('runtime')) * 60
    except:
        duration = 0
    year = 0
    premiered = i.get('release_date', '')
    try:
        year = int(i.get('release_date')[:4])
    except:
        year = 0
    if remDate:
        year = 0
        premiered = ""

    item = {
        'label': i.get('title', ''),
        'art': {
            'thumb': "{1}https://{2}/t/p/w500{0}".format(i.get('poster_path'), proxy, image) if i.get('poster_path') else '',
            'poster': "{1}https://{2}/t/p/w500{0}".format(i.get('poster_path'), proxy, image) if i.get('poster_path') else '',
            'fanart': "{1}https://{2}/t/p/w1280{0}".format(i.get('backdrop_path'), proxy, image) if i.get('backdrop_path') else '',
        },
        'info': {
            'video': {
                'genre': genre,
                'country': country,
                'rating': i.get('vote_average', 0.0),
                'director': directors,
                'plot': i.get('overview', ''),
                'plotoutline': i.get('overview', ''),
                'title': i.get('title', ''),
                'originaltitle': i.get('original_title', ''),
                'duration': duration,
                'studio': studio,
                'tagline': i.get('tagline', ''),
                'writer': writers,
                'premiered': premiered,
                'imdbnumber': i.get('imdb_id', ''),
                'votes': i.get('vote_count', 0),
                'trailer': trailer,
                'mediatype': 'movie',
                'mpaa': rating,
            },
        },
        'cast': casts,
    }
    if size: item['info']['video']['size'] = int(size)
    if year: item['info']['video']['year'] = year
    if showRating:
        item['label'] = makeLabel(i.get('title', ''), i.get('vote_average'), year if _showYear_ else None,
                                  genre if _showGenre_ else None, country if _showCountry_ else None)
        if fixRatingKodi19: item['info']['video']['title'] = item['label']
    return item


def makeTvShowItem(i, types="tvshow", number=None, remDate=False, size=None, showRating=_showRating_, fixRatingKodi19=_fixRatingKodi19_, fixSeasonKodi19=_fixSeasonKodi19_, localizetitle=_tvshowLocalizeTitle_, image=_image_tmdb_):
    item = {}
    casts = []
    genre = []
    studio = []
    first_date = ""
    try:
        first_date = i.get('first_air_date')[:4]
    except:
        if remDate:
            first_date = ""
        else:
            first_date = ""
    duration = 0
    id = trailer = ""
    rating = ""
    country = ""

    try:
        if _language_ == 'ru':
             country = ruCountry(i.get('origin_country')[0])
        else:
             country = i.get('origin_country')[0]
    except:
        country = ""

    try:
        for rat in i['content_ratings']['results']:
            if rat['iso_3166_1'] == "RU":
                rating = rat['rating']
                if rating: break
            elif rat['iso_3166_1'] == 'US':
                rating = rat['rating']
    except:
        rating = "0"

    if 'videos' in i and len(i['videos']['results']):
        try:
            id = i['videos']['results'][1]['key']
        except:
            id = i['videos']['results'][0]['key']
        finally:
            trailer = "plugin://plugin.video.youtube/play/?video_id={0}".format(id)
    try:
        for genreName in i['genres']:
            genre.append(genreName['name'])
    except:
        try:
            for id in i['genre_ids']:
               genre.append(genres.get(id, str(id)))
        except:
            genre = []

    try:
        for c in i['credits']['cast']:
            casts.append({
                'name': c['name'],
                'role': c['character'],
                'thumbnail': "{1}https://{2}/t/p/w342{0}".format(c['profile_path'], proxy, image) if c['profile_path'] else '',
                'order': c['order']
            })
    except:
        pass

    try:
        duration = i.get('episode_run_time')[0]
    except:
        duration = 0

    try:
        studio = i.get('networks')[0]['name']
    except:
        studio = ""
    if types == "episode":
        pass
    elif types == "season":
        s = {}
        for season in i['seasons']:
            if season.get('season_number', 0) == number:
                s = season
        if number > 1 and not s: s = i['seasons'][number-1]
        ov = ''
        if s.get('overview'):
            ov = s.get('overview')
        else:
            ov = i.get('overview')
        air_date = s.get('air_date', '')
        if remDate:
            first_date = ""
            air_date = ""

        item = {
            'label': s.get('name', ''),
            'art': {
                'thumb': "{1}https://{2}/t/p/w500{0}".format(s.get('poster_path'), proxy, image) if i.get('poster_path') else '',
                'poster': "{1}https://{2}/t/p/w500{0}".format(s.get('poster_path'), proxy, image) if i.get('poster_path') else '',
                'fanart': "{1}https://{2}/t/p/w1280{0}".format(i.get('backdrop_path'), proxy, image) if i.get('backdrop_path') else '',
            },
            'info': {
                'video': {
                    'genre': genre,
                    'season': number,
                    'episode': s.get('episode_count', 0),
                    'tvshowtitle': s.get('name', ''),
                    'title': i.get('original_name'),
                    'plot': ov,
                    'plotoutline': ov,
                    'aired': air_date,
                    'status': i.get('status', ''),
                    'votes': i.get('vote_count', 0),
                    'mediatype': 'tvshow',
                    'originaltitle': i['original_name'],
                    'rating': i['vote_average'],
                    'duration': duration * 60,
                    'country': country,
                    'studio': studio,
                    'imdbnumber': i.get('external_ids', {}).get('imdb_id'),
                    'trailer': trailer,
                    'mpaa': rating,
                }
            },
            'cast': casts,
        }
    else:
        item = {
            'label': i.get('name', ''),
            'art': {
                'thumb': "{1}https://{2}/t/p/w500{0}".format(i.get('poster_path'), proxy, image) if i.get('poster_path') else '',
                'poster': "{1}https://{2}/t/p/w500{0}".format(i.get('poster_path'), proxy, image) if i.get('poster_path') else '',
                'fanart': "{1}https://{2}/t/p/w1280{0}".format(i.get('backdrop_path'), proxy, image) if i.get('backdrop_path') else '',
            },
            'info': {
                'video': {
                    'genre': genre,
                    'season': i.get('number_of_seasons', 0),
                    'episode': i.get('number_of_episodes', 0),
                    'tvshowtitle': i.get('name', ''),
                    'plot': i.get('overview', ''),
                    'plotoutline': i.get('overview', ''),
                    'aired': i.get('first_air_date', ''),
                    'status': i.get('status', ''),
                    'votes': i.get('vote_count', 0),
                    'mediatype': 'tvshow',
                    'title': i.get('original_name'),
                    'originaltitle': i['original_name'],
                    'rating': i['vote_average'],
                    'duration': duration * 60,
                    'country': country,
                    'studio': studio,
                    'imdbnumber': i.get('external_ids', {}).get('imdb_id'),
                    'trailer': trailer,
                    'mpaa': rating,
                }
            },
            'cast': casts,
        }
        if showRating: item['label'] = makeLabel(i.get('name', ''), i.get('vote_average'), first_date if _showYear_ else None, genre if _showGenre_ else None, country if _showCountry_ else None)
    if size: item['info']['video']['size'] = int(size)
    if first_date: item['info']['video']['year'] = int(first_date) # year
    if localizetitle == '0': item['info']['video']['title'] = i.get('name')
    elif localizetitle == '2' and i.get('name') != i.get('original_name'):
         item['info']['video']['title'] = '%s / %s' % (i.get('name', ''), i.get('original_name', ''))
    if types == 'tvshow' and showRating and fixRatingKodi19:
         item['info']['video']['title'] = makeLabel(item['info']['video']['title'], i.get('vote_average'), first_date, genre)
    elif types == 'season' and fixSeasonKodi19 and s.get('name'):
         item['info']['video']['title'] = '(%s) %s' % (s.get('name', ''), item['info']['video']['title'])
    return item


def parseName(torrentName):
    for k, values in resolutions.items():
        for v in values:
            torrentName = torrentName.replace(v, k)
    return torrentName


def checkMime(file):
    ext = file.lower()[file.rfind(".")+1:]
    if extVideo.count(ext):
        return "video/*"
    if extAudio.count(ext):
        return "audio/*"
    return "*/*"


def getGenres(id):
    return genres.get(id, "None "+str(id))


def FC(s, color="FFFFFF00"):
    s = "[COLOR "+color+"]"+s+"[/COLOR]"
    return s


def get_label(text):
    if 'Трейлер' in text: return FC('Трейлер', 'FFFF9999')
    if 'Тизер' in text: return FC('Тизер', 'FFFF9999')
    if ' Android' in text: return FC('КПК', 'FFF8888F')
    text = text.lower()
    if ' кпк' in text: return FC('КПК', 'FFF8888F')
    if 'tvrip' in text: return FC('TV', 'FEFFFF88')
    if 'satrip' in text: return FC('TV', 'FEFFFF88')
    if 'dvb ' in text: return FC('TV', 'FEFFFF88')
    if 'hdtv' in text: return FC('HDTV', 'FEFFFF88')
    if 'telesyn' in text: return FC('TS', 'FFFF2222')
    if 'telecin' in text: return FC('TS', 'FFFF2222')
    if 'camrip' in text: return FC('TS', 'FFFF2222')
    if ' ts' in text: return FC('TS', 'FFFF2222')
    if 'dvdscr' in text: return FC('Scr', 'FFFF2222')
    if ' 3d' in text: return FC('3D', 'FC45FF45')
    if '720' in text: return FC('720p', 'FBFFFF55')
    if '1080' in text: return FC('1080p', 'FAFF9535')
    if '1440' in text: return FC('1440p', 'FAFА90FF')
    if '2160' in text: return FC('2160p', 'FAFF3030')
    if ' 4k' in text: return FC('2160p', 'FAFF3030')
    if 'webrip' in text: return FC('WEB', 'FEFF88FF')
    if 'WEB' in text: return FC('WEB', 'FEFF88FF')
    if 'web-dl' in text: return FC('WEB', 'FEFF88FF')
    if 'hdrip' in text: return FC('HDRip', 'FE98FF98')
    if 'dvd5' in text: return FC('DVD', 'FE88FFFF')
    if 'xdvd' in text: return FC('DVD', 'FE88FFFF')
    if 'dvd-5' in text: return FC('DVD', 'FE88FFFF')
    if 'dvd-9' in text: return FC('DVD', 'FE88FFFF')
    if 'dvd9' in text: return FC('DVD', 'FE88FFFF')
    if 'dvdrip' in text: return FC('DVDRip', 'FE88FFFF')
    if 'dvd-rip' in text: return FC('DVDRip', 'FE88FFFF')
    if 'blu-ray' in text: return FC('BRay', 'FF5555FF')
    if 'bdremux' in text: return FC('BDRemux', 'FF5555FF')
    if 'bdrip' in text: return FC('BDRip', 'FE98FF98')
    if 'drip' in text: return FC('BDRip', 'FE98FF98')
    if ' flac' in text: return FC('FLAC', 'FFFFAA99')
    if '[flac' in text: return FC('FLAC', 'FFFFAA99')
    if ' mp3' in text or ' МР3' in text: return FC('MP3', 'FFFFCC99')
    if '[mp3' in text: return FC('MP3', 'FFFFCC99')
    return FC('[   ????  ]', 'FFFFFFFF')


def checkHEVC(text):
    if 'HEVC' in text or 'x265' in text or 'H265' in text or 'H.265' in text: return True
    return False

def checkHDR(text):
    fi = text.find('HDR')
    if fi != -1:
      if len(text) - (fi+3) > 0 and text[fi+3:fi+4].isalpha(): return False
      else: return True
    return False

def altTitle(i, select=False, head='Select alternative title:'):
    titles = i.get('alternative_titles')
    if titles:
         titlesList = titles.get('titles', titles.get('results'))
         if not select: return titlesList
         index = xbmcgui.Dialog().select(head, [u'[COLOR yellow]{1}[/COLOR] {0}'.format(t['title'],t['iso_3166_1']) for t in titlesList])
         if index < 0: return None
         return titlesList[index]['title']
    return None

def isPicture(file):
    ext = file.lower()[file.rfind(".")+1:]
    if extPicture.count(ext):
        return True
    return False

def getInfoAndItem():
    from totam import getKodiInfo
    kinfo = getKodiInfo()
    item = {
        'art': {
             'thumb' : kinfo.get('poster_path'),
             'poster': kinfo.get('poster_path'),
             'fanart': kinfo.get('backdrop_path'),
        },
        'info': {
             'video': dict(kinfo.get('kodi', {}).get('info', {})),
        },
    }
    return item, kinfo

def color_rating(rating):
    if not rating:
        return ''
    rating = float(rating)
    if 0 <= rating < 5:
        return '[COLOR=red][%.1f][/COLOR]' % rating
    elif 5 <= rating < 7:
        return '[COLOR=yellow][%.1f][/COLOR]' % rating
    elif 7 <= rating < 8:
        return '[COLOR=green][%.1f][/COLOR]' % rating
    elif rating >= 8:
        return '[COLOR=lightgreen][%.1f][/COLOR]' % rating

def makeLabel(title, rating, year, genre, studio=None, typ=None):
    out = ""
    if rating: out += " %s" % color_rating(rating)
    if genre or year or studio or typ:
        out += " [COLOR 55FFFFFF]("
        if year: out += "%s, " % year
        if typ: out += "%s, " % typ
        if studio:
              if isinstance(studio, basestring): out += studio.strip()+", "
              else:
                   for i in xrange(len(studio)): studio[i] = studio[i].strip()
                   out += ', '.join(studio)+", "
        if genre: out += _de(', '.join(genre))
        else: out = out[:-2]
        out += ')[/COLOR]'
        if PY2 and isinstance(out, str): out = out.decode('utf8')
    return '%s%s' % (title, out)

def ruCountry(code):
    for item in iso_3166:
        if code == item[1] or code == item[2]:
             return item[0]
    return code

genres = {
    12: "приключения",
    14: "фэнтези",
    16: "мультфильм",
    18: "драма",
    27: "ужасы",
    28: "боевик",
    35: "комедия",
    36: "история",
    37: "вестерн",
    53: "триллер",
    80: "криминал",
    99: "документальный",
    878: "фантастика",
    9648: "детектив",
    10402: "музыка",
    10749: "мелодрама",
    10751: "семейный",
    10752: "военный",
    10759: "Боевик и Приключения",
    10762: "Детский",
    10763: "Новости",
    10764: "Реалити-шоу",
    10765: "НФ и Фэнтези",
    10766: "Мыльная опера",
    10767: "Ток-шоу",
    10768: "Война и Политика",
    10770: "телевизионный фильм"
}

iso_3166 = [
[u"Австралия",				"AU",	"AUS"],
[u"Австрия",				"AT",	"AUT"],
[u"Азербайджан",			"AZ",	"AZE"],
[u"Аландские острова",			"AX",	"ALA"],
[u"Албания",				"AL",	"ALB"],
[u"Алжир",				"DZ",	"DZA"],
[u"США",				"VI",	"VIR"],
[u"Американское Самоа",			"AS",	"ASM"],
[u"Ангилья",				"AI",	"AIA"],
[u"Ангола",				"AO",	"AGO"],
[u"Андорра",				"AD",	"AND"],
[u"Антарктида",				"AQ",	"ATA"],
[u"Антигуа и Барбуда",			"AG",	"ATG"],
[u"Аргентина",				"AR",	"ARG"],
[u"Армения",				"AM",	"ARM"],
[u"Аруба",				"AW",	"ABW"],
[u"Афганистан",				"AF",	"AFG"],
[u"Багамы",				"BS",	"BHS"],
[u"Бангладеш",				"BD",	"BGD"],
[u"Барбадос",				"BB",	"BRB"],
[u"Бахрейн",				"BH",	"BHR"],
[u"Белиз",				"BZ",	"BLZ"],
[u"Белоруссия",				"BY",	"BLR"],
[u"Бельгия",				"BE",	"BEL"],
[u"Бенин",				"BJ",	"BEN"],
[u"Бермуды",				"BM",	"BMU"],
[u"Болгария",				"BG",	"BGR"],
[u"Боливия",				"BO",	"BOL"],
[u"Босния и Герцеговина",		"BA",	"BIH"],
[u"Ботсвана",				"BW",	"BWA"],
[u"Бразилия",				"BR",	"BRA"],
[u"Бруней",				"BN",	"BRN"],
[u"Буркина-Фасо",			"BF",	"BFA"],
[u"Бурунди",				"BI",	"BDI"],
[u"Бутан",				"BT",	"BTN"],
[u"Вануату",				"VU",	"VUT"],
[u"Ватикан",				"VA",	"VAT"],
[u"Великобритания",			"GB",	"GBR"],
[u"Венгрия",				"HU",	"HUN"],
[u"Венесуэла",				"VE",	"VEN"],
[u"Восточный Тимор",			"TL",	"TLS"],
[u"Вьетнам",				"VN",	"VNM"],
[u"Габон",				"GA",	"GAB"],
[u"Гаити",				"HT",	"HTI"],
[u"Гайана",				"GY",	"GUY"],
[u"Гамбия",				"GM",	"GMB"],
[u"Гана",				"GH",	"GHA"],
[u"Гваделупа",				"GP",	"GLP"],
[u"Гватемала",				"GT",	"GTM"],
[u"Гвиана",				"GF",	"GUF"],
[u"Гвинея",				"GN",	"GIN"],
[u"Гвинея-Бисау",			"GW",	"GNB"],
[u"Германия",				"DE",	"DEU"],
[u"Гернси",				"GG",	"GGY"],
[u"Гибралтар",				"GI",	"GIB"],
[u"Гондурас",				"HN",	"HND"],
[u"Гонконг",				"HK",	"HKG"],
[u"Гренада",				"GD",	"GRD"],
[u"Гренландия",				"GL",	"GRL"],
[u"Греция",				"GR",	"GRC"],
[u"Грузия",				"GE",	"GEO"],
[u"Гуам",				"GU",	"GUM"],
[u"Дания",				"DK",	"DNK"],
[u"Джерси",				"JE",	"JEY"],
[u"Джибути",				"DJ",	"DJI"],
[u"Доминика",				"DM",	"DMA"],
[u"Доминиканская Республика",		"DO",	"DOM"],
[u"Европейский союз",			"EU",	""],
[u"Египет",				"EG",	"EGY"],
[u"Замбия",				"ZM",	"ZMB"],
[u"САДР",				"EH",	"ESH"],
[u"Зимбабве",				"ZW",	"ZWE"],
[u"Израиль",				"IL",	"ISR"],
[u"Индия",				"IN",	"IND"],
[u"Индонезия",				"ID",	"IDN"],
[u"Иордания",				"JO",	"JOR"],
[u"Ирак",				"IQ",	"IRQ"],
[u"Иран",				"IR",	"IRN"],
[u"Ирландия",				"IE",	"IRL"],
[u"Исландия",				"IS",	"ISL"],
[u"Испания",				"ES",	"ESP"],
[u"Италия",				"IT",	"ITA"],
[u"Йемен",				"YE",	"YEM"],
[u"Кабо-Верде",				"CV",	"CPV"],
[u"Казахстан",				"KZ",	"KAZ"],
[u"Острова Кайман",			"KY",	"CYM"],
[u"Камбоджа",				"KH",	"KHM"],
[u"Камерун",				"CM",	"CMR"],
[u"Канада",				"CA",	"CAN"],
[u"Катар",				"QA",	"QAT"],
[u"Кения",				"KE",	"KEN"],
[u"Кипр",				"CY",	"CYP"],
[u"Киргизия",				"KG",	"KGZ"],
[u"Кирибати",				"KI",	"KIR"],
[u"Тайвань",				"TW",	"TWN"],
[u"КНДР", 				"KP",	"PRK"],
[u"Китай",				"CN",	"CHN"],
[u"Кокосовые острова",			"CC",	"CCK"],
[u"Колумбия",				"CO",	"COL"],
[u"Коморы",				"KM",	"COM"],
[u"Коста-Рика",				"CR",	"CRI"],
[u"Кот-д’Ивуар",			"CI",	"CIV"],
[u"Куба",				"CU",	"CUB"],
[u"Кувейт",				"KW",	"KWT"],
[u"Кюрасао",				"CW",	"CUW"],
[u"Лаос",				"LA",	"LAO"],
[u"Латвия",				"LV",	"LVA"],
[u"Лесото",				"LS",	"LSO"],
[u"Либерия",				"LR",	"LBR"],
[u"Ливан",				"LB",	"LBN"],
[u"Ливия",				"LY",	"LBY"],
[u"Литва",				"LT",	"LTU"],
[u"Лихтенштейн",			"LI",	"LIE"],
[u"Люксембург",				"LU",	"LUX"],
[u"Маврикий",				"MU",	"MUS"],
[u"Мавритания",				"MR",	"MRT"],
[u"Мадагаскар",				"MG",	"MDG"],
[u"Майотта",				"YT",	"MYT"],
[u"Макао",				"MO",	"MAC"],
[u"Македония",				"MK",	"MKD"],
[u"Малави",				"MW",	"MWI"],
[u"Малайзия",				"MY",	"MYS"],
[u"Мали",				"ML",	"MLI"],
[u"Мальдивы",				"MV",	"MDV"],
[u"Мальта",				"MT",	"MLT"],
[u"Марокко",				"MA",	"MAR"],
[u"Мартиника",				"MQ",	"MTQ"],
[u"Маршалловы Острова",			"MH",	"MHL"],
[u"Мексика",				"MX",	"MEX"],
[u"Микронезия",				"FM",	"FSM"],
[u"Мозамбик",				"MZ",	"MOZ"],
[u"Молдавия",				"MD",	"MDA"],
[u"Монако",				"MC",	"MCO"],
[u"Монголия",				"MN",	"MNG"],
[u"Монтсеррат",				"MS",	"MSR"],
[u"Мьянма",				"MM",	"MMR"],
[u"Намибия",				"NA",	"NAM"],
[u"Науру",				"NR",	"NRU"],
[u"Непал",				"NP",	"NPL"],
[u"Нигер",				"NE",	"NER"],
[u"Нигерия",				"NG",	"NGA"],
[u"Нидерланды",				"NL",	"NLD"],
[u"Никарагуа",				"NI",	"NIC"],
[u"Ниуэ",				"NU",	"NIU"],
[u"Новая Зеландия",			"NZ",	"NZL"],
[u"Новая Каледония",			"NC",	"NCL"],
[u"Норвегия",				"NO",	"NOR"],
[u"ОАЭ",				"AE",	"ARE"],
[u"Оман",				"OM",	"OMN"],
[u"Остров Буве",			"BV",	"BVT"],
[u"Остров Мэн",				"IM",	"IMN"],
[u"Острова Кука",			"CK",	"COK"],
[u"Остров Норфолк",			"NF",	"NFK"],
[u"Остров Рождества",			"CX",	"CXR"],
[u"Острова Питкэрн",			"PN",	"PCN"],
[u"Пакистан",				"PK",	"PAK"],
[u"Палау",				"PW",	"PLW"],
[u"Государство Палестина",		"PS",	"PSE"],
[u"Панама",				"PA",	"PAN"],
[u"Папуа — Новая Гвинея",		"PG",	"PNG"],
[u"Парагвай",				"PY",	"PRY"],
[u"Перу",				"PE",	"PER"],
[u"Польша",				"PL",	"POL"],
[u"Португалия",				"PT",	"PRT"],
[u"Пуэрто-Рико",			"PR",	"PRI"],
[u"Республика Конго",			"CG",	"COG"],
[u"Южная Корея",			"KR",	"KOR"],
[u"Реюньон",				"RE",	"REU"],
[u"Россия",				"RU",	"RUS"],
[u"Руанда",				"RW",	"RWA"],
[u"Румыния",				"RO",	"ROU"],
[u"Сальвадор",				"SV",	"SLV"],
[u"Самоа",				"WS",	"WSM"],
[u"Сан-Марино",				"SM",	"SMR"],
[u"Сан-Томе и Принсипи",		"ST",	"STP"],
[u"Саудовская Аравия",			"SA",	"SAU"],
[u"Свазиленд",				"SZ",	"SWZ"],
[u"Сейшельские Острова",		"SC",	"SYC"],
[u"Сен-Бартелеми",			"BL",	"BLM"],
[u"Сен-Мартен",				"MF",	"MAF"],
[u"Сен-Пьер и Микелон",			"PM",	"SPM"],
[u"Сенегал",				"SN",	"SEN"],
[u"Сент-Винсент и Гренадины",		"VC",	"VCT"],
[u"Сент-Китс и Невис",			"KN",	"KNA"],
[u"Сент-Люсия",				"LC",	"LCA"],
[u"Сербия",				"RS",	"SRB"],
[u"Сингапур",				"SG",	"SGP"],
[u"Синт-Мартен",			"SX",	"SXM"],
[u"Сирия",				"SY",	"SYR"],
[u"Словакия",				"SK",	"SVK"],
[u"Словения",				"SI",	"SVN"],
[u"Соломоновы Острова",			"SB",	"SLB"],
[u"Сомали",				"SO",	"SOM"],
[u"Судан",				"SD",	"SDN"],
[u"СССР",				"SU",	"SUN"],
[u"Суринам",				"SR",	"SUR"],
[u"США",				"US",	"USA"],
[u"Сьерра-Леоне",			"SL",	"SLE"],
[u"Таджикистан",			"TJ",	"TJK"],
[u"Таиланд",				"TH",	"THA"],
[u"Танзания",				"TZ",	"TZA"],
[u"Тёркс и Кайкос",			"TC",	"TCA"],
[u"Того",				"TG",	"TGO"],
[u"Токелау",				"TK",	"TKL"],
[u"Тонга",				"TO",	"TON"],
[u"Тринидад и Тобаго",			"TT",	"TTO"],
[u"Тувалу",				"TV",	"TUV"],
[u"Тунис",				"TN",	"TUN"],
[u"Туркмения",				"TM",	"TKM"],
[u"Турция",				"TR",	"TUR"],
[u"Уганда",				"UG",	"UGA"],
[u"Узбекистан",				"UZ",	"UZB"],
[u"Украина",				"UA",	"UKR"],
[u"Уоллис и Футуна",			"WF",	"WLF"],
[u"Уругвай",				"UY",	"URY"],
[u"Фареры",				"FO",	"FRO"],
[u"Фиджи",				"FJ",	"FJI"],
[u"Филиппины",				"PH",	"PHL"],
[u"Финляндия",				"FI",	"FIN"],
[u"Фолклендские острова",		"FK",	"FLK"],
[u"Франция",				"FR",	"FRA"],
[u"Французская Полинезия",		"PF",	"PYF"],
[u"Херд и Макдональд",			"HM",	"HMD"],
[u"Хорватия",				"HR",	"HRV"],
[u"ЦАР",				"CF",	"CAF"],
[u"Чад",				"TD",	"TCD"],
[u"Черногория",				"ME",	"MNE"],
[u"Чехия",				"CZ",	"CZE"],
[u"Чили",				"CL",	"CHL"],
[u"Швейцария",				"CH",	"CHE"],
[u"Швеция",				"SE",	"SWE"],
[u"Шри-Ланка",				"LK",	"LKA"],
[u"Эквадор",				"EC",	"ECU"],
[u"Экваториальная Гвинея",		"GQ",	"GNQ"],
[u"Эритрея",				"ER",	"ERI"],
[u"Эстония",				"EE",	"EST"],
[u"Эфиопия",				"ET",	"ETH"],
[u"ЮАР",				"ZA",	"ZAF"],
[u"Южный Судан",			"SS",	"SSD"],
[u"Ямайка",				"JM",	"JAM"],
[u"Япония",				"JP",	"JPN"],
]

extVideo = ["3g2", "3gp", "aaf", "asf", "avchd", "avi", "drc", "flv", "iso", "m2v", "m2ts", "m4p", "m4v", "mkv", "mng", "mov", "mp2", "mp4", "mpe", "mpeg", "mpg", "mpv", "mxf", "nsv", "ogg", "ogv", "ts", "qt", "rm", "rmvb", "roq", "svi", "vob", "webm", "wmv", "yuv"]
extAudio = ['mp3', 'flac', 'ape', 'ogg', 'ac3', 'dts', 'wma', 'wav', 'aac', 'mp2', 'mka', 'midi', 'aiff', 'it', 's3m', 'mod', 'm4a']
extPicture=['jpg', 'jpeg', 'png', 'gif', 'bmp', 'ico', 'tiff', 'tif', 'mng', 'tga', 'webp']
