# -*- coding: utf-8 -*-

import os
import sys
import xbmc

try:
   import pyxbmct
except ImportError:
   xbmc.executebuiltin('InstallAddon(script.module.pyxbmct)', wait=True)
   from settings import container_refresh
   container_refresh()
   sys.exit()

from config import ADDON_PATH
from utils import plugin, _T


@plugin.action()
def dpcontrol_run():
    global _check_icon, _uncheck_icon
    _check_icon = os.path.join(ADDON_PATH, "resources", "img", "cross.png")
    _uncheck_icon = os.path.join(ADDON_PATH, "resources", "img", "check-off.png")
    storage = plugin.get_mem_storage('ListCurrentTorrents')
    #items = [f"{key} {value}" for key, value in storage.items()]
    itemstouple = tuple(storage.items())
    dialog = MultiChoiceDialog(_T("Остановить загрузку для:"), itemstouple)
    dialog.doModal()
    #remove_list = [item.split()[0] for item in dialog.selected]
    for key in dialog.selected:
            del storage[key]
    #xbmcgui.Dialog().notification("Удалены", "Выбраны для остановки: {0}".format(str(dialog.selected)))
    del dialog


class MultiChoiceDialog(pyxbmct.AddonDialogWindow):

    def __init__(self, title="", items=None):
        super(MultiChoiceDialog, self).__init__(title)
        self.setGeometry(450, 300, 4, 4)
        self.selected = []
        self.set_controls()
        self.item_dpid = [x[0] for x in items]
        self.item_labels = [x[1] for x in items]
        self.connect_controls()
        self.listing.addItems(self.item_labels or [])
        self.set_navigation()
        self.connect(pyxbmct.ACTION_NAV_BACK, self.close)
        for index in range(self.listing.size()):
            self.listing.getListItem(index).setArt({'icon':_uncheck_icon})

    def set_controls(self):
        self.listing = pyxbmct.List(_imageWidth=15)
        self.placeControl(self.listing, 0, 0, rowspan=3, columnspan=4)
        self.ok_button = pyxbmct.Button(_T("Стоп"))
        self.placeControl(self.ok_button, 3, 1)
        self.cancel_button = pyxbmct.Button(_T("Отмена"))
        self.placeControl(self.cancel_button, 3, 2)

    def connect_controls(self):
        self.connect(self.listing, self.check_uncheck)
        self.connect(self.ok_button, self.ok)
        self.connect(self.cancel_button, self.close)

    def set_navigation(self):
        self.listing.controlUp(self.ok_button)
        self.listing.controlDown(self.ok_button)
        self.ok_button.setNavigation(self.listing, self.listing, self.cancel_button, self.cancel_button)
        self.cancel_button.setNavigation(self.listing, self.listing, self.ok_button, self.ok_button)
        if self.listing.size():
            self.setFocus(self.listing)
        else:
            self.setFocus(self.cancel_button)

    def check_uncheck(self):
        list_item = self.listing.getSelectedItem()
        if list_item.getLabel2() == "checked":
            list_item.setArt({'icon':_uncheck_icon})
            list_item.setLabel2("unchecked")
        else:
            list_item.setArt({'icon':_check_icon})
            list_item.setLabel2("checked")

    def ok(self):
        self.selected = [self.item_dpid[(index)] for index in range(self.listing.size())
                                if self.listing.getListItem(index).getLabel2() == "checked"]
        super(MultiChoiceDialog, self).close()

    def close(self):
        self.selected = []
        super(MultiChoiceDialog, self).close()
