# -*- coding: utf-8 -*-
import os
import sys
PY2 = sys.version_info.major == 2
if PY2:
       import urllib
else:
       import urllib.parse as urllib
       unicode = str
       basestring = str
       long = int
       xrange = range
import hashlib
import bencode

import xbmcgui
import xbmcplugin
import xbmcvfs
if PY2:
       from xbmc import translatePath
else:
       from xbmcvfs import translatePath
from config import ADDON_PATH
from utils import plugin, _T, _de, humanizeSize

translate = _T

#LABELMASK = "%L" if plugin.get_setting("use_label_for_sort_kodi19", True) else "%T"


def del_mem_info():
    ms = plugin.get_mem_storage('i')
    try: del ms['info']
    except: pass


@plugin.action('openfile')
def open_file(params):
    dialog = xbmcgui.Dialog()
    if params.link and params.link.startswith('http'):
      from client import client
      data = client('', host=params.link, ljs=False)
      if not data:
         return
      pFile = 'special://temp/torrserve.torrent'
      tFile = translatePath(pFile)
      rtFile = _de(tFile)
      open(rtFile, 'wb').write(data)
    else:
      tFile = dialog.browseSingle(1, translate('Select torrent file'), 'files', '.torrent')
    if tFile != '':
     listing = []
     tfiles = [tFile]
     if params.mod == 'opendir':
         dir = tFile[:tFile.rfind('/')]
         dirs, files = xbmcvfs.listdir(dir)
         files.sort()
         tfiles = [os.path.join(dir, i) for i in files if '.torrent' in i.lower()]
     for tfile in tfiles:
        tf = xbmcvfs.File(tfile)
        if PY2: i = tf.read()
        else: i = bytes(tf.readBytes())
        tf.close()
        metainfo = bencode.bdecode(i)
        length = metainfo['info'].get('length', 0)
        if length==0:
            for f in metainfo['info']['files']:
                  length += f['length']
        infohash = hashlib.sha1(bencode.bencode(metainfo['info'])).hexdigest()
        tr = [metainfo.get('announce')]
        name = metainfo['info'].get('name.utf-8', metainfo['info']['name'])
        if 'announce-list' in metainfo:
            for t in metainfo['announce-list']:
               if t: tr.append(t.pop())
        params = {
            'dn': name.encode('utf8') if isinstance(name, unicode) else name,
            'tr': tr,
        }
        magneturi = 'magnet:?xt=urn:btih:{0}&{1}'.format(str(infohash).upper(), urllib.urlencode(params, True))
        listing.append({
            'label': name + ' [COLOR blue]['+ humanizeSize(length) + '][/COLOR]',
            'url': plugin.get_url(action='gotInfo', magnet=magneturi),
            'icon': os.path.join(ADDON_PATH, "resources", "img", "magnet.png"),
            'is_folder': True,
            "context_menu": [(
                translate("Add to DB"),
                "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="add", magnet=magneturi),
            ), (
                translate("Add to DB")+" (torrent)",
                "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="upload", tfile=tfile),
            ), (
                translate("Add all to DB")+" (torrent)",
                "RunPlugin(%s)" % plugin.get_url(action="torrents", mod="upload", files=repr(tfiles)),
            )]
        })
     del_mem_info()
     return plugin.create_listing(listing, cache_to_disk=True, category=tFile, sort_methods=(xbmcplugin.SORT_METHOD_UNSORTED, xbmcplugin.SORT_METHOD_LABEL))
