import os
import xbmc
import threading

from xbmc import Monitor
from six.moves import urllib_request

from torrserver.daemon import shutdown
from kodi_six.utils import PY2


class TorrServerMonitor(xbmc.Monitor):
    def __init__(self):
        self._closing = threading.Event()
        self._reboot = False
        Monitor.__init__(self)

    def __str__(self):
        return 'TorrServerMonitor'

    @property
    def closing(self):
        return self._closing

    def onAbortRequested(self):
        if self.abortRequested():
            xbmc.executebuiltin("Dialog.Close(all, true)")
            shutdown()
            try:
                self._closing.set()
                self._closing.clear()
            except SystemExit as e:
                if e.code != 0:
                    os._exit(1)
                pass
