import threading

from torrserver.log import log
from torrserver.daemon import torrserverd_thread
from torrserver.monitor import TorrServerMonitor

import xbmc

def run():
    monitor = TorrServerMonitor()
    threads = [
        threading.Thread(target=torrserverd_thread, args=[monitor]),
    ]
    for t in threads:
        t.daemon = True
        t.start()
    while not monitor.abortRequested():
        xbmc.sleep(1000)
    try:
        monitor.onAbortRequested()
    except:
        pass
    log.info("TorrServer: exiting torserverd")
