# -*- coding: utf-8 -*-
import platform
import re

from kodi_six import xbmc, xbmcgui
from kodi_six.utils import py2_encode


from torrserver.addon import ADDON, ADDON_NAME, ADDON_ICON
from torrserver.log import log
from torrserver.osarch import PLATFORM

def translatePath(path):
    try:
        from xbmcvfs import translatePath
    except ImportError:
        from xbmc import translatePath

    return translatePath(path)



def notify(message, header=ADDON_NAME, time=5000, image=ADDON_ICON):
    dialog = xbmcgui.Dialog()
    return dialog.notification(header, message, image, time)


def dialog_ok(message, header=ADDON_NAME):
    dialog = xbmcgui.Dialog()
    return dialog.ok(getLocalizedLabel(header), getLocalizedLabel(message))


def dialog_yesno(message, message1="", header=ADDON_NAME):
    dialog = xbmcgui.Dialog()
    return dialog.yesno(getLocalizedLabel(header), getLocalizedLabel(message) + "\n" + getLocalizedLabel(message1))


def getLocalizedLabel(label):
    try:
        if "LOCALIZE" not in label:
            return py2_encode(label)
        if ";;" not in label and label.endswith(']'):
            return py2_encode(getLocalizedString(int(label[9:-1])))
        else:
            parts = label.split(";;")
            translation = getLocalizedString(int(parts[0][9:14]))
            for i, part in enumerate(parts[1:]):
                if part[0:8] == "LOCALIZE":
                    parts[i + 1] = getLocalizedString(int(part[9:14]))
                else:
                    parts[i + 1] = py2_encode(parts[i + 1])

            return py2_encode(translation % tuple(parts[1:]), 'utf-8', 'ignore')
    except Exception as e:
        log.error("Cannot decode the label: %s, Error: %s" % (label, e))
        return label


def getLocalizedStringMatch(match):
    try:
        return ADDON.getLocalizedString(int(match.group(1)))
    except:
        return match.group(1)


def getLocalizedText(text):
    try:
        return re.sub(r'LOCALIZE\[(\d+)\]', getLocalizedStringMatch, text)
    except:
        return text


def getLocalizedString(stringId):
    try:
        return py2_encode(ADDON.getLocalizedString(stringId), 'utf-8', 'ignore')
    except:
        return stringId


def system_information():
    build = xbmc.getInfoLabel("System.BuildVersion")
    log.info("System information: %(os)s_%(arch)s %(version)s" % PLATFORM)
    log.info("Kodi build version: %s" % build)
    log.info("OS type: %s" % platform.system())
    log.info("uname: %s" % repr(platform.uname()))
    return PLATFORM


def getShortPath(path):
    if PLATFORM["os"] == "windows":
        return getWindowsShortPath(path)
    return path


def getWindowsShortPath(path):
    try:
        import ctypes
        import ctypes.wintypes

        ctypes.windll.kernel32.GetShortPathNameW.argtypes = [
            ctypes.wintypes.LPCWSTR,  # lpszLongPath
            ctypes.wintypes.LPWSTR,  # lpszShortPath
            ctypes.wintypes.DWORD  # cchBuffer
        ]
        ctypes.windll.kernel32.GetShortPathNameW.restype = ctypes.wintypes.DWORD

        buf = ctypes.create_unicode_buffer(1024)  # adjust buffer size, if necessary
        ctypes.windll.kernel32.GetShortPathNameW(path, buf, len(buf))

        return buf.value
    except:
        return path
