# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import sys

if sys.version_info.major == 2:
     from urllib import quote_plus
else:
     from urllib.parse import quote as quote_plus

import xbmc
import xbmcgui
import xbmcaddon

import kodirpc


def LANG(id):
    return xbmcaddon.Addon().getLocalizedString(id) if 31000 <= id <= 33000 else xbmc.getLocalizedString(id)


def edit_title(title):
    kbd = xbmc.Keyboard()
    kbd.setDefault(title)
    kbd.setHeading(LANG(16017))
    kbd.doModal()
    if kbd.isConfirmed():
            title = kbd.getText().decode('utf8') if sys.version_info.major == 2 else kbd.getText()
    return title


def find_video(title, originaltitle="", year=None, item_id="", media_type="", animation=True, name="", cl_name="", us=True):
    list_title = []
    if isinstance(title, list):
          findnames = title
          list_title.extend(title)
          title = title[0]
    else:
          findnames = [title]
    if title!=originaltitle and originaltitle and originaltitle not in list_title: findnames += [originaltitle]
    if year:
       if list_title:
            for i in list_title: findnames += ['%s (%s)' % (i, year)]
       else:
            findnames += ['%s (%s)' % (title, year)]
    if title!=originaltitle and year and originaltitle and originaltitle not in list_title: findnames += ['%s (%s)' % (originaltitle, year)]
    if list_title:
       for i in list_title:
            if ': ' in title: findnames += i.split(':')
    elif ': ' in title: findnames += title.split(':')
    if originaltitle and ': ' in originaltitle and not (originaltitle in list_title or title == originaltitle): findnames += originaltitle.split(':')
    if cl_name and name!=cl_name: findnames += [ '[COLOR orange]%s:[/COLOR] %s' % (LANG(21435), cl_name) ]
    if name: findnames += [ '[COLOR yellow]%s:[/COLOR] %s' % (LANG(21435), name) ]
    index = xbmcgui.Dialog().select(heading=LANG(16017),
                                            list=findnames)
    if index == -1:
                   return None
    findname = findnames[index].strip()
    if cl_name and cl_name!=name and index == len(findnames)-2: findname = edit_title(cl_name)
    if name and index == len(findnames)-1: findname = edit_title(name)
    addonlist= [('United Search', 'plugin://plugin.video.united.search/?action=search&keyword='),
               ('ExtendedInfo Script |(поиск информации по названию)', 'RunScript(//script.extendedinfo/,info=moviedbbrowser,id=%s)' % findname),
#               ('TorrServer Client', 'plugin://plugin.video.torrserve/?action=search&mod=torrent&title=true&qs=true&id=%s&type=%s&query=' % (item_id, media_type)),
               ('TorrServer Client |(поиск по названию с инфо)', 'plugin://plugin.video.torrserve/?action=search&mod=torrent&type=video&getinfo=True&query='),
               ('TorrServer Client |(поиск по названию без инфо)', 'plugin://plugin.video.torrserve/?action=search&mod=torrent&type=video&query='),
               ('RuTracker', 'plugin://plugin.rutracker/?route=rutracker-search&content=global&search='),
#               ('Elementum |(поиск по TMDB_ID)', 'plugin://plugin.video.elementum/%s/%s/%s' % (media_type.replace('tv',''), item_id, "seasons" if media_type == "tvshow" else "links?external=true")),
               ('Elementum |(поиск по названию)', 'plugin://plugin.video.elementum/search?q='),
               ('Filmix', 'plugin://plugin.video.filmix/search?keyword='),
               ('Hdrezka.tv', 'plugin://plugin.video.hdrezka.tv/?mode=search&usearch=True&keyword='),
               ('kino-live.org', 'plugin://plugin.video.kino-live.org/?mode=usearch&keyword='),
               ('Киновод', 'plugin://plugin.video.kinovod/?route=catalog&s_kbd=True&search='),
               ('HD KinoTeatr', 'plugin://plugin.video.evld.hdkinoteatr.com/?mode=search&query='),
               ('Filmix.Net', 'plugin://plugin.video.filmix.net.dev/?mode=search&usearch=True&keyword='),
               ('ZONA.plus', 'plugin://plugin.video.zona.mobi/?action=search&keyword='),
               ('IVI', 'plugin://plugin.video.ivi.ru/?func=read_dir&from=0&to=50&url=%s&query=' % quote_plus('http://www.ivi.ru/mobileapi/search/v2/?subsite=15&%s')),
               ('ivi', 'plugin://plugin.video.ivi.client/?action=search&keyword='),
               ('Smotrim.ru', 'plugin://plugin.video.smotrim.ru/?action=search&context=brands&url=plugin%3a%2f%2fplugin.video.smotrim.ru%2f&search='),
               ('YouTube', 'plugin://plugin.video.youtube/kodion/search/query/?q='),
               ('ExtendedInfo Script - YouTube |(поиск по названию на YouTube)', 'RunScript(//script.extendedinfo/,info=youtubebrowser,id=%s)' % findname),
               ('RuTor', 'plugin://plugin.video.RuTor/?mode=US&text='),
               ('MegaPeer', 'plugin://plugin.video.megapeer/?route=catalog&s_kbd=True&search='),
               ('Rutor Аудиокниги', 'plugin://plugin.video.rutor.audio/?route=catalog&s_kbd=True&search='),
               ('Fast-Torrent.org', 'plugin://plugin.video.fasttorrent.org/?mode=US&title='),
               ('KinoPoisk', 'plugin://plugin.video.KinoPoisk.ru/?mode=HSearch&url='),
               ('Filmpotok', 'plugin://plugin.video.filmpotok/?mode=HSearch&info=%s' % quote_plus((repr({'src':findname.encode('utf8')}))) )]
    if media_type == 'tvshow' or not media_type:
       addonlist += [
               ('LostFilm', 'plugin://plugin.niv.lostfilm/?mode=common_part&param=search_part&search_string='),
#               ('TVShow |(поиск по TMDB_ID)', 'plugin://plugin.video.tvshow.tdw/?mode=Episodes&id=%s' % item_id),
               ('seasonvar.ru', 'plugin://plugin.video.dandy.seasonvar.ru/?mode=search&usearch=True&keyword=')]
    if animation:
       addonlist += [
               ('AniDub |(только аниме)', 'plugin://plugin.video.anidub/?mode=search&search_string='),
               ('Anilibria.TV |(только аниме)', 'plugin://plugin.video.anilibria.tv/?mode=HSearch&url='),
               ('Animedia.TV |(только аниме)', 'plugin://plugin.video.animedia.tv/?mode=HSearch&url='),
               ('AnimeVost.org |(только аниме)', 'plugin://plugin.video.animevost/?mode=serch_s&name='),
               ('AniMedia.TV Online |(только аниме)', 'plugin://plugin.video.evld.animedia.tv/?mode=popular&keywords=')]
#    installedlist = [i for i in addonlist if xbmc.getCondVisibility("System.HasAddon(%s)" % i[1].split('/')[2]) == 1] # почему-то не работает с заглавными буквами, наверное баг Kodi...
    installedlist = []
    addons = sorted(kodirpc.getAddons(), key=lambda x: x['name'])
    for i in addonlist:
        for addon in addons:
            if i[1].split('/')[2] == addon['addonid']:
                installedlist.append(i)
                addon['used']=True
#    xbmcgui.Dialog().textviewer('ddd', str(addons))
    if us:
        for addon in addons:
           us_command = xbmcaddon.Addon(id=addon['addonid']).getSetting('us_command')
           if us_command and 'used' not in addon:
               if '?' not in us_command: us_command = '?'+us_command
               installedlist.append((addon['name']+'|поддержка United Search', 'plugin://'+addon['addonid']+'/'+us_command))
    items = []
    findlist = []
    for i in installedlist:
         li = xbmcgui.ListItem()
         li.setLabel(i[0].split('|')[0])
         if '|' in i[0]: li.setLabel2(i[0].split('|',1)[1])
         try:
            li.setArt({"thumb": xbmcaddon.Addon(id=i[1].split('/')[2]).getAddonInfo('icon') })
            items.append(li)
            findlist.append(i)
         except: pass
    if int(xbmc.getInfoLabel('System.BuildVersion')[:2]) >= 17:
         index = xbmcgui.Dialog().select(heading=LANG(32001),
                                            list=items, useDetails=True)
    else:
         index = xbmcgui.Dialog().select(heading=LANG(32001), list=items)
    if index == -1:
                   return None
    purl = findlist[index][1]
    if purl[-1] == '=':
           purl += quote_plus(findname.encode('utf8'))
#    xbmcgui.Dialog().ok('Поиск тест', findname, str(index), purl)
    if purl.startswith('plugin://'):
       if xbmc.getCondVisibility("Window.IsVisible(videos)"):
          if 'plugin.video.united.search' in purl:
               xbmc.executebuiltin("Container.Update(plugin://plugin.video.united.search)")
               xbmc.sleep(500)
               xbmc.executebuiltin("RunPlugin(%s)" % purl)
          else:
               xbmc.executebuiltin("Container.Update(%s)" % purl)
       else:
          xbmc.executebuiltin("ActivateWindow(videos,%s,return)" % purl)
    else:
       purl = purl.replace('/','')
       xbmc.executebuiltin(purl.encode('utf8') if sys.version_info.major == 2 else purl)
