# -*- coding: utf-8 -*-

import sys, os
import re
import socket
import random, time
socket.setdefaulttimeout(20)

site_url = 'https://knizhkin.net'

try:
	from xbmcup.app import _setting
	#_quality_ = _setting['quality']
	_domain_ = _setting['site_domain']
	#_rating_ = int(_setting['rating_type'])
	#_subtitles_ = bool(_setting['view_subtitles'] == 'true')
	_get_domain_ = bool(_setting['get_domain'] == 'true')
	_kodi_ = True
	if _domain_:
		_domain_ = _domain_.replace('https://', '').replace('http://', '').strip('/').strip()
		if _domain_:
			if _setting['use_https'] == 'true': site_url = 'https://' + _domain_
			else: site_url = 'http://' + _domain_
except Exception:
	_get_domain_ = False
	_kodi_ = False
	#_subtitles_ = True
	#_rating_ = 1
	#_quality_ = '1080'
	sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'script.module.beautifulsoup4', 'lib'))


headers = {
	'User-Agent': 'Mozilla/5.0 (Android 8.1.0; Mobile; rv:67.0) Gecko/67.0 Firefox/67.0',
	#'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:67.0) Gecko/20100101 Firefox/67.0',
	#'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; rv:10.0.2) Gecko/20100101 Firefox/10.0.2',
	'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
	'Accept-Language': 'ru-ru,ru;q=0.8,en-us;q=0.5,en;q=0.3',
	'Cache-Control': 'no-cache',
	'Referer': site_url
	}


class Error(Exception):
    def __init__(self, msg):
	self.msg = msg

    def __str__(self):
	return '{}'.format(self.msg)

def getUrl(url, rurl=False, rheaders=False, referer=None, proxy=None):
	from xbmcup.net import HTTP
	http = HTTP()
	if isinstance(url, unicode):
		url = url.encode('utf8')
	if referer: headers['Referer'] = referer
	if proxy:
		response = http.fetch(url, headers=headers, cookies='knizhkin.moz', proxy_protocol=url.split(':')[0], proxy_host=proxy.split(':')[0], proxy_port=proxy.split(':')[1])
	else:
		response = http.fetch(url, headers=headers, cookies='knizhkin.moz')
	if response.code == 200:
		if rurl:
			return response.url , response.body
		elif rheaders:
			return response.headers, response.body
		else:
			return response.body
        else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def postUrl(url, param):
	from xbmcup.net import HTTP
	http = HTTP()
	if isinstance(url, unicode):
		url = url.encode('utf8')
	response = http.fetch(url, method='POST', params=param, headers=headers, cookies='knizhkin.moz')
	if response.code == 200:
			return response.url , response.body
        else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def GetProxyList():
	import httplib
	conn = httplib.HTTPConnection("antizapret.prostovpn.org")
	conn.request("GET", "/proxy.pac", headers={"User-Agent": 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)'})
	r1 = conn.getresponse()
	data = r1.read()
	conn.close()
	proxylist = re.compile('PROXY (.+?); DIRECT').findall(data)
	#print proxylist
	return proxylist

def proxy_update():
	return GetProxyList()[0]
"""
if _get_domain_:
		try: pt=float(_setting['proxy_time'])
		except: pt=0
		if time.time()-pt > 36000:
			proxy1 = proxy_update()
			#proxy1=__setting['proxy_serv']
			#print proxy1
			try:
				_setting['proxy_time'] = str(time.time())
			except: pass
			data = getUrl('https://t.me/s/kinovodnet', proxy=proxy1)
			#file('/home/osmc/tme-kinovodnet.txt', 'wb').write(data)
			r = re.compile('"(http[s]?://kinovod[0-9]*?\.[a-z]*?)/"',re.S|re.U).findall(data)
			#print r
			redirect_url = r[-1]
			if site_url != redirect_url:
				try:
					_setting['site_domain'] = redirect_url.split('/')[2]
					_setting['use_https'] = 'true' if redirect_url.split(':')[0] == 'https' else 'false'
				except: pass
				site_url = redirect_url
				#print redirect_url, site_url
				#print _setting
"""
def r_u(url):
	if url.startswith(site_url): return url.replace(site_url,'')
	else: return url

def n_u(url):
	if ('://' in url) or (url is None) or (url[0] != '/'): return url
	else: return site_url + url

def pars(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	c = soup.find('ul', 'side-box side-nav to-mob').findAll('li')
	#print c
	genres = []
	for i in c:
		tu = i.find('a')
		numb = i.find('span').text
		text = tu.text.strip() + '     ' + numb.strip()
		url = r_u(tu['href'])
		if url == '#':
			genres.append( ( u'[COLOR green]'+ text + u'[/COLOR]', 0 ) )
		else:
			genres.append( ( text, url ) )
	return { 'genres': genres }

def pars_authors(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	data = []
	c = soup.find('div', id='dle-content')
	tz = c.find('div', 'mtitle')
	data.append( ( u'[COLOR green]'+ tz.text + u'[/COLOR]', 0) )
	data.append( ( u'[COLOR green]Русские буквы:[/COLOR]', 0) )
	for i in c.findAll('a'):
		if i.text == 'A': data.append( ( u'[COLOR green]Зарубежные буквы:[/COLOR]', 0) )
		data.append( ( i.text, r_u(i['href']) ) )
	return { 'data': data }

def pars_ar_rezult(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	data = []
	c = soup.find('div', id='dle-content')
	tz = c.find('h2')
	data.append( ( u'[COLOR green]'+ tz.text + u'[/COLOR]', 0) )
	for i in c.findAll('a'):
		data.append( ( i.text, r_u(i['href']) ) )
	return { 'data': data }

def pars2(data, is_sort=False):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')
	from xbmcup.html import Clear

	i = soup.find('div', id='dle-content')
	v_temp_list = []
	podbor_list = []
	#i = v[0]
	#print i
	#for i in v:
	if i:
		x = i.findAll('div', 'short-item')
		#n = x[0]
		#print n
		for n in x:
		#if n:
			info = {}
			p = n.find('a', 'short-title')
			text = p.text
			info['title'] = Clear().string(text)
			url = r_u( p['href'] )

			s = p.findNext('a', 'short-img img-wide')
			im = s.find('img')
			img = None
			if im:
				if im['src'] != '':
					img = n_u( im['src'] )
			#print info, url, img

			gq = s.findNext('div', 'short-cat nowrap')
			text = ''.join(gq.findAll(text=True))
			info['genre'] = Clear().string(text)
			wd = gq.findNext('div', 'short-cat nowrap')
			yqt = ''
			wi = wd.find('i', 'fal fa-user')
			if wi:
				w = wi.findNext('a')
				info['writer'] = w.text
			di = wd.find('i', 'fal fa-microphone')
			if di:
				d = di.findNext('a')
				info['director'] = d.text
				yqt = d.text
			cki = wd.find('i', 'fal fa-recycle')
			if cki:
				ck = cki.findNext('a')
				if u'Слушать' not in ck.text: info['mpaa'] = ck.text
			r = re.compile('<i class="fal fa-stopwatch"></i>(\d+:\d+:\d+)',re.S).search(unicode(wd))
			if r: info['tagline'] = r.group(1)

			sr = n.find('div', 'short-text')
			if sr:
				info['plot'] = sr.text.strip()
			v_temp_list.append( {'url': url, 'thumb': img, 'info': info, 'yq': yqt} )
		#print v_temp_list

	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	pg = soup.find('div', 'navigation')
	#print pg
	if pg:
		t = pg.findAll('a')
		cu = pg.findAll('span')
		#print t
		#print cu
		try: page['max'] = int(t[-1]['href'].split('page/')[1].strip('/'))
		except:
			try: page['max'] = int(t[-2]['href'].split('page/')[1].strip('/'))
			except:
				try: page['max'] = int(t[-1].text)
				except: page['max'] = -1
		try: page['current'] = int(cu[0].text)
		except: page['current'] = int(cu[1].text)
		for i in t:
			if str(page['current']+1) == i.text:
				page['next'] = i['href']
				if i['href'] == '#': page['snext'] = int(i.text)
			if str(page['current']-1) == i.text: page['prev'] = i['href']
		#print page

	sort_list = []
	if is_sort and (page['current'] == 1):
		names = []
		n = soup.findAll('span', 'dropdown-u')
		if n:
			for i in n:
				names.append( i.text )
			v = soup.findAll('ul', 'dropdown-menu')
			for i, name in zip(v, names):
				sort_name = name+u': '
				actives_name = []
				a = i.findAll('li', 'active')
				if a:
					for a1 in a:
						a2 = a1.find('a')
						if a2:
							actives_name.append( a2.text)
					sort_param = u', '.join(actives_name)
				else:
					sort_param = u'Все'
					a = i.findAll('a', 'active')
					if a:
						for a2 in a:
							actives_name.append( a2.text)
						sort_param = u', '.join(actives_name)
				sort_name = u''.join([u'[COLOR green]', sort_name, sort_param, u'[/COLOR]'])
				#print sort_name
				all_sort = []
				for j in i.findAll('a'):
					s_name = j.text
					if s_name in actives_name: s_name = u'[COLOR gold]' + s_name + u'[/COLOR]'
					all_sort.append( (s_name, j['href']) )
				#print all_sort
				sort_list.append( {'name': sort_name, 'sort': all_sort} )
	return {'data': v_temp_list, 'page': page, 'podbor': podbor_list, 'filter': sort_list}


def pars3(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')
	from xbmcup.html import Clear

	ur= soup.find('meta', property='og:url')
	url = ur['content']
	p = soup.find('div', id='dle-content')
	content_list = []
	podbor_list = []
	if p:
		info = {'mediatype': 'song'}
		r = p.find('h1')
		if r: info['title'] = Clear().string(r.text)
		t = r.findNext('img')
		if t: img = n_u( t['src'] )

		g = p.find('div', 'fright fx-1')
		if g:
			text = ''.join(g.findAll(text=True))
		strana = False
		for j in text.splitlines():
			#print j
			if u'Оригинальное название:' in j: info['originaltitle'] = j.split(':')[1].strip()
			#if strana:
			#	if j.strip() != u'':
			#		info['studio'] = j.strip()
			#		strana = False
			if u'Добавлено:' in j: info['studio'] = j[j.find(':')+1:].strip()   #strana = True
			if u'Категория:' in j: info['genre'] = j.split(':')[1].strip()
			if u'Цикл:' in j: info['mpaa'] = j.split(':')[1].strip()
			if u'Автор:' in j:
				info['writer'] = j.split(':')[1].strip()
				info['album'] = info['writer']
			if u'Читает:' in j:
				info['director'] = j.split(':')[1].strip()
				info['artist'] = info['director']
			if u'Продолжительность:' in j:
	    				dc = re.compile(u'([\d+]+)',re.S).search(j)
					if dc:
						#ts = dc.group(1).split(':')
						#info['duration'] = int(ts[0])*60*60+int(ts[1])*60+int(ts[2])
						info['duration'] = int(dc.group(1))*60
			if u'Качество:' in j:
				info['plotoutline'] = j.split(':')[1].strip()
			if u'Длительность:' in j: info['tagline'] = j[j.find(':')+1:].strip()
			if u'Год выпуска:' in j:
					year = j.split(':')[1].strip()
					if year !='':
						if '-' in year: year = year.split('-')[1]
						info['year'] = int(year)
			if u'Актеры:' in j:
				info['cast'] = [i.strip() for i in j.split(':')[1].split(',') if i]


		o = p.find('div','fdesc full-text video-box clearfix')
		if o:
			r = re.compile(' mp3\:(.+?)$',re.S).search(o.text)
			if r:
				info['plot'] = r.group(1).replace('\t', ' ').strip('\n')
				info['comment'] = info['plot']

		screenshot = None
		tempcastfull = None
		content_list.append( {'url': r_u(url), 'thumb': img, 'info': info, 'cast': tempcastfull, 'screenshot': screenshot} )

	g = p.find('div', 'sect-content owl-carousel')
	if g:
		c = g.findAll('div', 'top-item')
		podbor_list.append( {'url': 0, 'thumb': None, 'info':{'title': '[COLOR green]Похожие аудиокниги:[/COLOR]'} } )
		#i = c[0]
		for i in c:
		#if i:
			info = {}
			a = i.find('a')
			url = r_u( a['href'] )
			t = a.find('div', 'top-title')
			info['title'] = t.text
			gr = a.find('div', 'top-subtitle')
			info['genre'] = Clear().string(gr.text)
			im = a.find('img')
			img = n_u( im['src'] )
			podbor_list.append( {'url': url, 'thumb': img, 'info': info} )

	comments_list = None
	c = p.find('div', id='dle-comments-list')
	if c:
		comments_list = []
		for i in c.findAll('div', id=re.compile('comment\-id\-\d+')):
			au = i.find('span')
			avtor = au.text.strip()
			dc = au.findNext('span')
			datacom = dc.text.strip()
			title = avtor+ u' от ' + datacom
			textcom = i.find('div', id=re.compile('comm\-id\-\d+')).text
			comments_list.append( (title, textcom) )

	pr_list = None
	pr = p.find('div', style="background-color: #2d2f38;font-size: 1.5em;color:#fff;padding:50px 0px 50px 0px; height:;text-align: center; border-radius:8px") #><img src="/uploads/rkn.png"><br />Извините.<br />Материал удалён по запросу правообладателя!</div>
	if pr:
		img = pr.find('img')['src']
		pr_list ={'thumb': n_u(img), 'title': pr.text}
		#print pr_list
	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	return {'data': content_list, 'page': page, 'podbor2': podbor_list, 'comments': comments_list, 'pr': pr_list }


def pars_play(data):
	r = re.compile('Playerjs\(\{id\:"player",file\:(.+?)\}\);',re.S).search(data)
	if r:
		#import json
		#tmp = json.loads(r.group(1))
		tmp = eval(r.group(1))
		for i in range(len(tmp)):
			t = tmp[i]
			t['index'] = i
			if '\u0' in t['title']:
				t['title'] = t['title'].decode('unicode-escape')
			elif 'u0' in t['title']:
				t['title'] = t['title'].replace('u0','\u0').decode('unicode-escape')
			else:
				t['title'] = t['title'].decode('utf8')
			tmp[i] = t
		return tmp
	return None

def catalog(url=site_url):
	if not url: url = site_url
	data = getUrl(n_u(url))
	#file('/home/osmc/catalog.txt', 'wb').write( data )
	return pars2(data)

def genres():
	data = getUrl(site_url)
	return pars(data)

def authors():
	data = getUrl(n_u('/authors.html'))
	#file('/home/osmc/authors.txt', 'wb').write( data )
	return pars_authors(data)

def readers():
	data = getUrl(n_u('/readers.html'))
	#file('/home/osmc/readers.txt', 'wb').write( data )
	return pars_authors(data)

def ar_rezult(url):
	data = getUrl(n_u(url))
	#file('/home/osmc/ar_rezult.txt', 'wb').write( data )
	return pars_ar_rezult(data)

def videoinfo(url):
	data = getUrl(n_u(url))
	#file('/home/osmc/videoinfo.txt', 'wb').write( data )
	res = pars3(data)
	res['url'] = pars_play(data)
	return res

def search(text):
	if isinstance(text, unicode): text = text.encode('utf8')
	from urllib import urlencode
	url, data = postUrl(site_url,{'do': 'search', 'subaction':'search', 'story': text, 'submit': r'Найти' } )
	#file('/home/osmc/search.txt', 'wb').write( data )
	if site_url == url:
		return False, pars2(data)
	else:
		return True, pars3(data)

def nextsearch(text, page):
	if isinstance(text, unicode): text = text.encode('utf8')
	from urllib import urlencode
	url, data = postUrl(site_url+'/index.php?do=search',{'do': 'search', 'subaction':'search', 'search_start': str(page), 'result_from': str((page-1)*14+1) ,'story': text, 'submit': r'Найти' } )
	#file('/home/osmc/nextsearch.txt', 'wb').write( data )
	return False, pars2(data)


def play_link(url, index=None):
	try:
		from xbmcup.errors import log
		log(url,'url=')
	except: pass
	#data = file('/home/osmc/videoinfo.txt', 'rb').read()
	data = getUrl(n_u(url))
	#file('/home/osmc/videoinfo.txt', 'wb').write(data)
	d_play = pars_play(data)
	try:
		from xbmcup.errors import log
		log(d_play,'d_play=')
	except: pass
	from urllib import urlencode
	opt = '|'+urlencode({'User-Agent': headers['User-Agent']})
	if index or index == 0:
		return  d_play[index]['file'] + opt, None
	else:
		return d_play['file'] + opt, None


def pars_filter(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	f = soup.find('form', 'filter-form')
	if f:
		c = f.find('select')
		characteristics = []
		for i in c.findAll('option'):
			characteristics.append( ( i['value'], i.text ) )
			#print i['value']

		s = c.findNext('select')
		subgenre = []
		for i in s.findAll('option'):
			subgenre.append( ( i['value'], i.text ) )
			#print i['value']

		sc = s.findNext('select')
		scene = []
		for i in sc.findAll('option'):
			scene.append( ( i['value'], i.text ) )
			#print i['value']

		t = sc.findNext('select')
		time = []
		for i in t.findAll('option'):
			time.append( ( i['value'], i.text ) )
			#print i['value']

		st = t.findNext('select')
		story = []
		for i in st.findAll('option'):
			story.append( ( i['value'], i.text ) )
			#print i['value']

		y = st.findNext('select')
		year = []
		for i in y.findAll('option'):
			year.append( ( i['value'], i.text ) )
			#print i['value']

		sort = [ ('date', 'По дате'), ('rating', 'По популярности'), ('news_read', 'По просмотрам'), ('comm_num', 'По комментариям'), ('title', 'По алфавиту')]
		order = [ ('desc', 'По убыванию'), ('asc', 'По возрастанию') ]
	return {'characteristics': characteristics, 'subgenre': subgenre, 'scene': scene, 'time': time, 'story': story, 'year': year, 'sort': sort, 'order': order}

def filter():
	data = getUrl(site_url)
	return pars_filter(data)


def pars_topweek(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')
	from xbmcup.html import Clear

	g = soup.find('div', 'sect sect-popular')
	topw = []
	if g:
		c = g.findAll('div', 'top-item')
		#i = c[0]
		for i in c:
		#if i:
			info = {}
			a = i.find('a')
			url = r_u( a['href'] )
			t = a.find('div', 'top-title')
			info['title'] = t.text
			gr = a.find('div', 'top-subtitle')
			info['genre'] = Clear().string(gr.text)
			im = a.find('img')
			img = n_u( im['src'] )
			topw.append( { 'url': url, 'thumb': img, 'info':info } )
	return { 'topweek': topw }

def topweek():
	data = getUrl(site_url)
	return pars_topweek(data)

if __name__ == '__main__':
	#catalog()
	data = file('/home/osmc/catalog.txt', 'rb').read()
	#print	pars2(data)
	#print filter()
	#print pars_topweek(data)

	data = file('/home/osmc/videoinfo.txt', 'rb').read()
	print 	pars3(data)
	#print pars_play(data)
	#print play_link('fff', 0)

	#print readers()
	#print authors()
	data = file('/home/osmc/authors.txt', 'rb').read()
	#print pars_authors(data)

	data = file('/home/osmc/ar_rezult.txt', 'rb').read()
	#print pars_ar_rezult(data)
	#print search('толстой')
	#print nextsearch('толстой', 2)

	data = file('/home/osmc/search.txt', 'rb').read()
	#print pars2(data)
	pass

