# -*- coding: utf-8 -*-

import os, sys

import xbmc, xbmcplugin, xbmcgui

from xbmcup.app import Link, Handler, Plugin, _setting
import knizhkin
from history import History, HistoryAdd

_view_ = _setting['view']

plugin = Plugin()

@plugin.radd()
class Menu(Handler):
	def handle(self):
		self.item(Link('catalog',{'search': True}), title='[Поиск]')
		self.item(Link('history'), title='[История поиска]')
		self.item(Link(Filters), title='Фильтр')
		self.item(Link(Catalog), title='Каталог книг')
		self.item(Link(Authors), title='Авторы')
		self.item(Link(Readers), title='Исполнители')
		self.item(Link(Genres), title='Жанры')
		self.item(Link(TopWeek), title='Топ книг за неделю')
		self.render(nextmode=_view_)

@plugin.radd()
class TopWeek(Handler):
	def handle(self):
		d = knizhkin.topweek()
		for i in d['topweek']:
			title = i['info']['title']
			self.popupadd(Link(BookInfo, {'info': i['info']}), 'Информация о книге', True, True)
			self.popupadd(Link('catalog', {'search': True, 'textsearch': title}, True), 'Поиск')
			self.item(Link('video',{'url': i['url']}), title=title, thumb=i['thumb'], info=i['info'], popup=True, popup_replace=True)
		self.render(nextmode=_view_)

@plugin.radd()
class Filters(Handler):
	def handle(self):
		series = self.argv.get('series', 'Цикл')
		charect_i = self.argv.get('charect_i', 0)
		subgenre_i = self.argv.get('subgenre_i', 0)
		scene_i = self.argv.get('scene_i', 0)
		time_i = self.argv.get('time_i', 0)
		story_i = self.argv.get('story_i', 0)
		year_i = self.argv.get('year_i', 0)
		sort_i = self.argv.get('sort_i', 0)
		order_i = self.argv.get('order_i', 0)
		d = self.argv.get('d')
		if d is None:
			d = knizhkin.filter()
			replace = False
		else: replace = True
		if series == True:
			series = self.kbdinput('Цикл / Серия')
			if series is None: return True
		elif isinstance(charect_i, bool):
			index = xbmcgui.Dialog().select(self.nameaddon, [ x[1] for x in d['characteristics'] ])
			if index < 0:
				return True
			else:
				charect_i = index
		elif isinstance(subgenre_i, bool):
			index = xbmcgui.Dialog().select(self.nameaddon, [ x[1] for x in d['subgenre'] ])
			if index < 0:
				return True
			else:
				subgenre_i = index
		elif isinstance(scene_i, bool):
			index = xbmcgui.Dialog().select(self.nameaddon, [ x[1] for x in d['scene'] ])
			if index < 0:
				return True
			else:
				scene_i = index
		elif isinstance(time_i, bool):
			index = xbmcgui.Dialog().select(self.nameaddon, [ x[1] for x in d['time'] ])
			if index < 0:
				return True
			else:
				time_i = index
		elif isinstance(story_i, bool):
			index = xbmcgui.Dialog().select(self.nameaddon, [ x[1] for x in d['story'] ])
			if index < 0:
				return True
			else:
				story_i = index
		elif isinstance(year_i, bool):
			index = xbmcgui.Dialog().select(self.nameaddon, [ x[1] for x in d['year'] ])
			if index < 0:
				return True
			else:
				year_i = index
		elif isinstance(sort_i, bool):
			index = xbmcgui.Dialog().select(self.nameaddon, [ x[1] for x in d['sort'] ])
			if index < 0:
				return True
			else:
				sort_i = index
		elif isinstance(order_i, bool):
			index = xbmcgui.Dialog().select(self.nameaddon, [ x[1] for x in d['order'] ])
			if index < 0:
				return True
			else:
				order_i = index
		self.item(Link(Filters,{'d':d, 'series': True, 'charect_i': charect_i, 'subgenre_i': subgenre_i, 'scene_i': scene_i, 'time_i': time_i, 'story_i': story_i, 'year_i': year_i, 'sort_i': sort_i, 'order_i': order_i}) , title=series)
		self.item(Link(Filters,{'d':d, 'series': series, 'charect_i': True, 'subgenre_i': subgenre_i, 'scene_i': scene_i, 'time_i': time_i, 'story_i': story_i, 'year_i': year_i, 'sort_i': sort_i, 'order_i': order_i}), title=d['characteristics'][charect_i][1])
		self.item(Link(Filters,{'d':d, 'series': series, 'charect_i': charect_i, 'subgenre_i': True, 'scene_i': scene_i, 'time_i': time_i, 'story_i': story_i, 'year_i': year_i, 'sort_i': sort_i, 'order_i': order_i}), title=d['subgenre'][subgenre_i][1])
		self.item(Link(Filters,{'d':d, 'series': series, 'charect_i': charect_i, 'subgenre_i': subgenre_i, 'scene_i': True, 'time_i': time_i, 'story_i': story_i, 'year_i': year_i, 'sort_i': sort_i, 'order_i': order_i}), title=d['scene'][scene_i][1])
		self.item(Link(Filters,{'d':d, 'series': series, 'charect_i': charect_i, 'subgenre_i': subgenre_i, 'scene_i': scene_i, 'time_i': True, 'story_i': story_i, 'year_i': year_i, 'sort_i': sort_i, 'order_i': order_i}), title=d['time'][time_i][1])
		self.item(Link(Filters,{'d':d, 'series': series, 'charect_i': charect_i, 'subgenre_i': subgenre_i, 'scene_i': scene_i, 'time_i': time_i, 'story_i': True, 'year_i': year_i, 'sort_i': sort_i, 'order_i': order_i}), title=d['story'][story_i][1])
		self.item(Link(Filters,{'d':d, 'series': series, 'charect_i': charect_i, 'subgenre_i': subgenre_i, 'scene_i': scene_i, 'time_i': time_i, 'story_i': story_i, 'year_i': True, 'sort_i': sort_i, 'order_i': order_i}), title=d['year'][year_i][1])
		self.item(Link(Filters,{'d':d, 'series': series, 'charect_i': charect_i, 'subgenre_i': subgenre_i, 'scene_i': scene_i, 'time_i': time_i, 'story_i': story_i, 'year_i': year_i, 'sort_i': True, 'order_i': order_i}), title=d['sort'][sort_i][1])
		self.item(Link(Filters,{'d':d, 'series': series, 'charect_i': charect_i, 'subgenre_i': subgenre_i, 'scene_i': scene_i, 'time_i': time_i, 'story_i': story_i, 'year_i': year_i, 'sort_i': sort_i, 'order_i': True}), title=d['order'][order_i][1])
		f = {}
		def _enc(s):
			if isinstance(s, unicode): s = s.encode('utf8')
			return s
		if isinstance(series, basestring) and _enc(series) != 'Цикл': f['series'] = _enc(series)
		if charect_i > 0: f['characteristics'] = _enc( d['characteristics'][charect_i][0] )
		if subgenre_i > 0: f['subgenre'] = _enc( d['subgenre'][subgenre_i][0] )
		if scene_i > 0: f['scene'] = _enc( d['scene'][scene_i][0] )
		if time_i > 0: f['time'] = _enc( d['time'][time_i][0] )
		if story_i > 0: f['story'] = _enc( d['story'][story_i][0] )
		if year_i > 0: f['year'] = _enc( d['year'][year_i][0] )
		f['sort'] = d['sort'][sort_i][0]
		f['order'] = d['order'][order_i][0]
		from urllib import urlencode
		furl = urlencode(f).replace('&','/')
		url = '/f/'+furl
		self.item(Link(Catalog,{'url':url, 's_kbd': True}), title='Найти книги')
		self.item(Link(Filters,{'d':d}), title='Очистить список')
		self.render(nextmode=_view_, replace=replace)

@plugin.radd()
class Authors(Handler):
	def handle(self):
		data = knizhkin.authors()
		for i in data['data']:
			self.item(Link(ARrezult,{'url': i[1]}), title=i[0])
		self.render(nextmode=_view_)

@plugin.radd()
class Readers(Handler):
	def handle(self):
		data = knizhkin.readers()
		for i in data['data']:
			self.item(Link(ARrezult,{'url': i[1]}), title=i[0])
		self.render(nextmode=_view_)

@plugin.radd()
class ARrezult(Handler):
	def handle(self):
		url = self.argv.get('url')
		data = knizhkin.ar_rezult(url)
		for i in data['data']:
			self.item(Link(Catalog,{'url': i[1]}), title=i[0])
		self.render(nextmode=_view_)

@plugin.radd()
class Genres(Handler):
	def handle(self):
		data = knizhkin.genres()
		for i in data['genres']:
			self.item(Link('catalog',{'url': i[1]}), title=i[0])
		self.render(nextmode=_view_)

@plugin.radd()
class Catalog(Handler):
	def handle(self):
		search = self.argv.get('search')
		url = self.argv.get('url')
		s_kbd = self.argv.get('s_kbd', False)
		sort = self.argv.get('sort')
		data = self.argv.get('data', None)
		page = self.argv.get('page')
		if sort:
			index = xbmcgui.Dialog().select(self.nameaddon, [x[0] for x in sort])
			if index < 0:
				return True
			else:
				url = sort[index][1]
		if page and search:
			s1, data = knizhkin.nextsearch(search, page)
		elif search:
			if isinstance(search, bool):
				textsearch = self.argv.get('textsearch', '')
				search = self.kbdinput('Поиск', textsearch)
				if search is None: return True
				s_kbd = True
				HistoryAdd(search)
			s1, data = knizhkin.search(search)
		elif url == 0:
			return True
		elif data is None:
			data = knizhkin.catalog(url)
		if (data['data']==[]) and s_kbd and (data['podbor'] ==[]):
			xbmcgui.Dialog().ok(self.nameaddon, 'Ничего не найдено')
		if data.get('filter'):
			for i in data['filter']:
				self.item(Link('catalog', {'sort': i['sort']}), title=i['name'], media='video', popup=self.popup, popup_replace=True)
		for i in data['data']:
			popup = []
			popup.extend(self.popup)
			title = i['info']['title']
			popup[0] = (Link(BookInfo, {'info': i['info']}), 'Информация о книге')
			popup.insert(1, (Link('catalog', {'search': True, 'textsearch': title}, True), 'Поиск') )
			if i['info'].get('mpaa'): popup.insert(2, (Link(Filters, {'series': i['info']['mpaa']}, True), 'Искать цикл') )
			if i['info'].get('writer'): popup.insert(-1, (Link(Catalog, {'search': i['info']['writer']}, True), 'Еще книги этого автора') )
			if i['info'].get('plotoutline'):
				title = title + u' (' + i['yq'] + u', ' + i['info']['plotoutline'] + u')'
			elif i.get('yq'):
				title = title + u' (' + i['yq'] + u')'
			if i['info'].get('rating'):
				title = title + u' [' + unicode(i['info']['rating']) + u']'
			self.item(Link('video', {'url': i['url']}), title=title, media='music', info=i['info'], thumb=i['thumb'], popup=popup, popup_replace=True)
		for i in data['podbor']:
			self.item(Link('catalog', {'url': i['url']}), title=i['info']['title'], media='music', info=i['info'], thumb=i['thumb'], popup=self.popup, popup_replace=True)
		if data['page']['next']:
			titlepage = 'Следующая страница '+ str(data['page']['current']+1)+ ' из ' + str(data['page']['max']) + ' >>'
			if data['page']['next'] == '#':
				self.item(Link('catalog',{'page':data['page']['snext'], 'search': search}), title=titlepage)
			else:
				self.item(Link('catalog',{'url':data['page']['next']}), title=titlepage)
		self.render(nextmode=_view_)


@plugin.radd()
class Video(Handler):
	def handle(self):
		url = self.argv.get('url')
		if url == 0:
			return True
		d = knizhkin.videoinfo(url)
		data = d['data'][0]
		title = data['info']['title']
		info = data['info']
		def normname(s):
			if ' (' in s: s = s[:s.find(' (')]
			return s
		self.popupadd(Link(BookInfo, {'info': info}), 'Информация о книге', start=True)
		if data.get('screenshot'): self.popupadd(Link('screenshot', data['screenshot']), 'Скриншоты' + ' (' + str(len(data['screenshot'])) + ')')
		if d.get('comments'): self.popupadd(Link(Comments, d['comments']), 'Комментарии' + ' (' + str(len(d['comments'])) + ')')
		self.popupadd(Link('catalog', {'search': True, 'textsearch': title}, True), 'Поиск')
		if info.get('mpaa'): self.popupadd(Link(Filters, {'series': normname(info['mpaa'])}, True), 'Искать цикл')
		if info.get('writer'):
			if ',' in info['writer']:
				for i in normname(info['writer']).split(','):
					self.popupadd(Link(Catalog, {'search': i.strip()}, True), u'Еще книги ' + i.strip())
				self.popupadd(Link(Catalog, {'search': normname(info['writer'])}, True), 'Еще книги этих авторов')
			else:
				self.popupadd(Link(Catalog, {'search': normname(info['writer'])}, True), 'Еще книги этого автора')
		if isinstance(d['url'], basestring):
			self.item(Link('play',{'url': data['url']}), title=title, media='music', info=info, thumb=data['thumb'], popup=True, popup_replace=True, property=[('IsPlayable','true')], cast=data['cast'], folder=False)
		else:
			self.item(Link('video', {'url': data['url'] }), title=title, media='music', info=data['info'], thumb=data['thumb'], popup=True, popup_replace=True, cast=data['cast'])
			if d['url'] is not None:
				for i in d['url']:
					info['title'] = title + u' / ' + i['title']
					info['tracknumber'] = i['index'] + 1
					self.item(Link('play',{'url': data['url'], 'index': i['index'] }), title=i['title'], media='music', info=info, thumb=data['thumb'], popup=True, popup_replace=True, property=[('IsPlayable','true')], cast=data['cast'], folder=False)
			else:
				self.item(Link('video', {'url': data['url'] }), title='[COLOR yellow]Нет ссылок на аудио.[/COLOR]', media='music', info=info, thumb=data['thumb'], popup=True, popup_replace=True, cast=data['cast'])
				if d.get('pr'): self.item(Link('video', {'url': data['url'] }), title=u'[COLOR pink]'+d['pr']['title']+u'[/COLOR]', media='music', thumb=d['pr']['thumb'], info=info, popup=True, popup_replace=True)
		for i in d['podbor2']:
			self.popupadd(Link(BookInfo, {'info': i['info']}), 'Информация о книге', True, start=True)
			self.item(Link('video', {'url': i['url']}), title=i['info']['title'], media='music', info=i['info'], thumb=i['thumb'], popup=True, popup_replace=True)
		self.render(nextmode=_view_)

@plugin.radd()
class Play(Handler):
	def handle(self):
		url = self.argv.get('url')
		durl = self.argv.get('durl')
		index = self.argv.get('index')
		if url:
			link, error = knizhkin.play_link(url, index)
		elif durl: link = durl
		if link == '': error = ['Нет ссылки на аудио.']
		if link:
			#xbmc.Player().play(link)
			item = xbmcgui.ListItem(path=link)
			xbmcplugin.setResolvedUrl(int(sys.argv[1]),True, item)
		else:
			xbmcgui.Dialog().ok(self.nameaddon, *error)

@plugin.radd()
class ScreenShot(Handler):
	def handle(self):
		from xbmcup import slideshow
		slideshow.open(self.argv, 0)
		return True

@plugin.radd()
class BookInfo(Handler):
	def handle(self):
		info = self.argv.get('info')
		text = u''
		if 'writer' in info:	text += u'Автор книги: ' + info['writer'] + u'\n'
		if 'director' in info:	text += u'Читает: ' + info['director'] + u'\n'
		if 'genre' in info:	text += u'Жанр: ' + info['genre'] + u'\n'
		if 'mpaa' in info:	text += u'Цикл: ' + info['mpaa'] + u'\n'
		if 'year' in info:	text += u'Год выпуска: ' + unicode(info['year']) + u'\n'
		if 'tagline' in info:	text += u'Длительность книги: ' + info['tagline'] + u'\n'
		if 'plotoutline' in info: text += u'Качество: ' + info['plotoutline'] + u'\n'
		if 'studio' in info:	text += u'Добавлено: ' + info['studio'] + u'\n'
		if 'plot' in info:	text += u'Описание: ' + info['plot'] + u'\n'
		gui = GuiTextViewer('DialogTextViewer.xml', sys.argv[0], descript=text, title=info['title'])
		gui.doModal()
		del gui
		return True

@plugin.radd()
class Comments(Handler):
	def handle(self):
		d = self.argv
		text = u''
		for a, c in d:
			text += a + u'\n' + c + u'\n\n'
		gui = GuiTextViewer('DialogTextViewer.xml', sys.argv[0], descript=text, title='Комментарии к книге')
		gui.doModal()
		del gui
		return True

class GuiTextViewer(xbmcgui.WindowXMLDialog):
    def __init__(self, *args, **kwargs):
        self.descript = kwargs['descript']
        self.title = kwargs['title']
        xbmcgui.WindowXMLDialog.__init__(self, *args, **kwargs)
    
    def onInit(self):
        #lang = Lang()
        self.getControl(1).setLabel(self.title)
        self.getControl(5).setText(self.descript)
    
    def onFocus(self, control):
        pass


def main():
	plugin.route('history', History)
	plugin.run(setcontent='songs')


if __name__ == '__main__':
	try:
                search_vars = sys.argv[2].split('?')
                search_vars = search_vars[-1].split('&')
                if 'usearch=True' in search_vars:
                        from urlparse import parse_qs
                        params = parse_qs(sys.argv[2].replace('?', ''))
                        united_search = {'route': 'catalog', 'argv': { 'search': params['keyword'][0] } }
			from urllib import quote_plus
                        import json
                        sys.argv[2] = '?'+quote_plus(json.dumps(united_search))
	except BaseException as e:
		from xbmcup.errors import log
		log(e)

	main()
