#!/usr/bin/python
# -*- coding: utf-8 -*-
#/*
# *      Copyright (C) 2011 Silen
# *
# *
# *  This Program is free software; you can redistribute it and/or modify
# *  it under the terms of the GNU General Public License as published by
# *  the Free Software Foundation; either version 2, or (at your option)
# *  any later version.
# *
# *  This Program is distributed in the hope that it will be useful,
# *  but WITHOUT ANY WARRANTY; without even the implied warranty of
# *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# *  GNU General Public License for more details.
# *
# *  You should have received a copy of the GNU General Public License
# *  along with this program; see the file COPYING.  If not, write to
# *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
# *  http://www.gnu.org/copyleft/gpl.html
# */
from utils23 import *
import re, os, time
import xbmc, xbmcgui, xbmcplugin, xbmcaddon, xbmcvfs
from datetime import date

try:
    xbmc.translatePath = xbmcvfs.translatePath
except AttributeError:
    pass

import resources.lib.diafilms as diafilms

Addon = xbmcaddon.Addon(id='plugin.video.diafilms')

#log = open('/opt/retropie/configs/ports/kodi/temp/dia_log.txt','ab')
#sys.stdout = log

try:
        from bs4  import BeautifulSoup
except:
  try:
    #sys.path.append(os.path.join(Addon.getAddonInfo('path'), r'resources', r'lib'))
    sys.path = [os.path.dirname(__file__) + '/resources/lib'] + sys.path
    from BeautifulSoup  import BeautifulSoup
  except:
    try:
        sys.path.insert(0, os.path.join(Addon.getAddonInfo('path'), r'resources', r'lib'))
        from BeautifulSoup  import BeautifulSoup
    except:
        sys.path.append(os.path.join(os.getcwd(), r'resources', r'lib'))
        from BeautifulSoup  import BeautifulSoup
        icon = xbmc.translatePath(os.path.join(os.getcwd().replace(';', ''),'icon.png'))

if PY2:
    import HTMLParser
    hpar = HTMLParser.HTMLParser()
    import urllib, urllib2, cookielib
else:
    import html as hpar
    import urllib.request as urllib2
    import urllib.parse as urllib
    import http.cookiejar as cookielib

h = int(sys.argv[1])
icon = xbmc.translatePath(os.path.join(Addon.getAddonInfo('path'),'icon.png'))
fcookies = xbmc.translatePath(os.path.join(Addon.getAddonInfo('path'), r'resources', r'data', r'cookies.txt'))

def showMessage(heading, message, times = 3000):
    xbmc.executebuiltin('XBMC.Notification("%s", "%s", %s, "%s")'%(heading, message, times, icon))

#---------- get categories  ----------------------------------------------------
def Get_Categories():
    # get diafilm categories
    url = 'http://www.diafilmy.su/'
    post = None
    request = urllib2.Request(url, post)

    request.add_header('User-Agent', 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)')
    request.add_header('Host',    'diafilmy.su')
    request.add_header('Accept', '*/*')
    request.add_header('Accept-Language', 'ru-RU')
    request.add_header('Referer',    'http://google.com')

    try:
        f = urllib2.urlopen(request)
    except IOError as e:
        if hasattr(e, 'reason'):
            xbmc.log('We failed to reach a server. Reason: '+ e.reason, xbmc.LOGERROR)
        elif hasattr(e, 'code'):
            xbmc.log('The server couldn\'t fulfill the request. Error code: '+ e.code, xbmc.LOGERROR)
        else: raise e

    html = f.read()

    # -- parsing web page ------------------------------------------------------

    soup = BeautifulSoup(html, fromEncoding="windows-1251")
#    xbmcgui.Dialog().textviewer('ok', str(soup))

    df_nav = soup.findAll("li", { "class" : "sublnk" })
    for df in df_nav:
#        try:
            if '/diafilmy' in df.find("a")["href"]:
                for dfr in df.findAll('li'):
                    name = _en(unescape(dfr.find('b').text))
                    url  = 'http://www.diafilmy.su' + dfr.find('a')['href']
                    if PY2:
                       i = xbmcgui.ListItem('[COLOR FF00FF00]'+name+'[/COLOR]', iconImage=icon, thumbnailImage=icon)
                    else:
                       i = xbmcgui.ListItem('[COLOR FF00FF00]'+name+'[/COLOR]')
                       i.setArt({'icon': icon, 'thumb': icon})
                    u = sys.argv[0] + '?mode=LIST'
                    u += '&name=%s'%urllib.quote_plus(name)
                    u += '&url=%s'%urllib.quote_plus(url)
                    xbmcplugin.addDirectoryItem(h, u, i, True)
#        except:
#            pass

    xbmcplugin.endOfDirectory(h)

#--- get number of pages for selected category ---------------------------------
def Get_Page_Number(url):
    post = None
    request = urllib2.Request(url, post)

    request.add_header('User-Agent', 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)')
    request.add_header('Host',    'diafilmy.su')
    request.add_header('Accept', '*/*')
    request.add_header('Accept-Language', 'ru-RU')
    request.add_header('Referer',    'http://google.com')

    try:
        f = urllib2.urlopen(request)
    except IOError as e:
        if hasattr(e, 'reason'):
            xbmc.log('We failed to reach a server. Reason: '+ e.reason, xbmc.LOGERROR)
        elif hasattr(e, 'code'):
            xbmc.log('The server couldn\'t fulfill the request. Error code: '+ e.code, xbmc.LOGERROR)

    html = f.read()

    # -- parsing web page ------------------------------------------------------

    soup = BeautifulSoup(html, fromEncoding="windows-1251")

    ret = 1

    try:
        df_nav = soup.find("div", { "class" : "navigation" })
        for df in df_nav.findAll('a'):
            try:
                if int(df.text) > ret:
                    ret = int(df.text)
            except: pass
    except: pass

    return ret

#---------- get list of diafilms -----------------------------------------------
def Get_List(params):
    # -- parameters
    url  = urllib.unquote_plus(params['url'])
    #xbmc.log(url)

    if 'page' in params:
        page = int(params['page'])
    else:
        page = 1
    
    if 'maxpage' in params:
        maxpage = int(params['maxpage'])
    else:
        maxpage = Get_Page_Number(url)
        
    # get all serials
    
    Get_List_by_Page(url + '/page/'+str(page)+'/')

    page += 1
    
    if page <= maxpage:
        if PY2:
           i = xbmcgui.ListItem('[COLOR FF00FF00]Следующая страница '+str(page)+ ' из ' + str(maxpage) + ' >>>[/COLOR]', iconImage=icon, thumbnailImage=icon)
        else:
           i = xbmcgui.ListItem('[COLOR FF00FF00]Следующая страница '+str(page)+ ' из ' + str(maxpage) + ' >>>[/COLOR]')
           i.setArt({'icon': icon, 'thumb': icon})
        u = sys.argv[0] + '?mode=LIST'
        u += '&url=%s' % urllib.quote_plus(url)
        u += '&page=%i' % page
        u += '&maxpage=%i' % maxpage
        xbmcplugin.addDirectoryItem(h, u, i, True)

#    xbmcplugin.addSortMethod(h, sortMethod=xbmcplugin.SORT_METHOD_LABEL)
    xbmcplugin.endOfDirectory(h)

def Get_List_by_Page(url2):
    xbmc.log('   '+url2)
    # get diafilm list
    post = None
    request = urllib2.Request(url2, post)

    request.add_header('User-Agent', 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)')
    request.add_header('Host',    'diafilmy.su')
    request.add_header('Accept', '*/*')
    request.add_header('Accept-Language', 'ru-RU')
    request.add_header('Referer',    'http://google.com')

    try:
        f = urllib2.urlopen(request)
    except IOError as e:
        if hasattr(e, 'reason'):
            xbmc.log('We failed to reach a server. Reason: '+ e.reason, xbmc.LOGERROR)
        elif hasattr(e, 'code'):
            xbmc.log('The server couldn\'t fulfill the request. Error code: '+ e.code, xbmc.LOGERROR)

    html = f.read()

    # -- parsing web page ------------------------------------------------------
    soup = BeautifulSoup(html, fromEncoding="windows-1251")

    df_nav = soup.findAll('div', {'class':'news'})
    for df in df_nav:
        name = _en(unescape(df.find('h3').find('a').text))
        url  = df.find('h3').find('a')['href']
        img  = 'http://diafilmy.su' + df.find('img')['src']

        if PY2:
           i = xbmcgui.ListItem(name, iconImage=img, thumbnailImage=img)
        else:
           i = xbmcgui.ListItem(name)
           i.setArt({'icon': img, 'thumb': img})
        u = sys.argv[0] + '?mode=PLAY'
        u += '&name=%s'%urllib.quote_plus(name)
        u += '&url=%s'%urllib.quote_plus(url)
        u += '&img=%s'%urllib.quote_plus(img)
        xbmcplugin.addDirectoryItem(h, u, i, False)


#-------------------------------------------------------------------------------

def PLAY(params):
    # -- parameters
    url  = urllib.unquote_plus(params['url'])

    # -- initialize GUI
    path = Addon.getAddonInfo('path')
    ui = diafilms.Diafilm('Diafilms.xml',  path, 'default', '720p')
    ui.Set_URL(url)

    # -- show images
    ui.doModal()
    del ui

    try: sys.modules.clear()
    except: pass

#-------------------------------------------------------------------------------

def unescape(text):
    try:
        text = hpar.unescape(text)
    except:
        text = hpar.unescape(text.decode('utf8'))

    try:
        text = unicode(text, 'utf-8')
    except:
        text = text

    return text

#-------------------------------------------------------------------------------
def get_params(paramstring):
    param=[]
    if len(paramstring)>=2:
        params=paramstring
        cleanedparams=params.replace('?','')
        if (params[len(params)-1]=='/'):
            params=params[0:len(params)-2]
        pairsofparams=cleanedparams.split('&')
        param={}
        for i in range(len(pairsofparams)):
            splitparams={}
            splitparams=pairsofparams[i].split('=')
            if (len(splitparams))==2:
                param[splitparams[0]]=splitparams[1]
    return param
#-------------------------------------------------------------------------------
params=get_params(sys.argv[2])

# get cookies from last session
cj = cookielib.FileCookieJar(fcookies)
hr  = urllib2.HTTPCookieProcessor(cj)
opener = urllib2.build_opener(hr)
urllib2.install_opener(opener)

mode = None

try:
    mode = urllib.unquote_plus(params['mode'])
except:
    Get_Categories()

if mode == 'LIST':
    Get_List(params)
elif mode == 'PLAY':
    PLAY(params)

