# -*- coding: utf-8 -*-

import sys, os
import re
import socket
import random, time
socket.setdefaulttimeout(20)

site_url = 'https://kinokrad.co'

randindex = random.randint(0,1)

try:
	from xbmcup.app import _setting
	_quality_ = _setting['quality']
	_domain_ = _setting['site_domain']
	_rating_ = int(_setting['rating_type'])
	_subtitles_ = bool(_setting['view_subtitles'] == 'true')
	_get_domain_ = bool(_setting['get_domain'] == 'true')
	_kodi_ = True
	if _domain_:
		_domain_ = _domain_.replace('https://', '').replace('http://', '').strip('/').strip()
		if _domain_:
			if _setting['use_https'] == 'true': site_url = 'https://' + _domain_
			else: site_url = 'http://' + _domain_
except Exception:
	_get_domain_ = False
	_kodi_ = False
	_subtitles_ = True
	_rating_ = 1
	_quality_ = '720'
	sys.path.append(os.path.join(os.path.dirname(__file__), '..', 'script.module.beautifulsoup4', 'lib'))


headers = {
	'User-Agent': 'Mozilla/5.0 (Android 8.1.0; Mobile; rv:67.0) Gecko/67.0 Firefox/67.0',
	#'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:67.0) Gecko/20100101 Firefox/67.0',
	#'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; rv:10.0.2) Gecko/20100101 Firefox/10.0.2',
	'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
	'Accept-Language': 'ru-ru,ru;q=0.8,en-us;q=0.5,en;q=0.3',
	'Cache-Control': 'no-cache',
	'Referer': site_url
	}

Quality = (360, 480, 720, 1080)

class Error(Exception):
    def __init__(self, msg):
	self.msg = msg

    def __str__(self):
	return '{}'.format(self.msg)

def getUrl(url, rurl=False, rheaders=False, referer=None, proxy=None):
	from xbmcup.net import HTTP
	http = HTTP()
	if isinstance(url, unicode):
		url = url.encode('utf8')
	if referer: headers['Referer'] = referer
	if proxy:
		response = http.fetch(url, headers=headers, cookies='kinokrad.moz', proxy_protocol=url.split(':')[0], proxy_host=proxy.split(':')[0], proxy_port=proxy.split(':')[1])
	else:
		response = http.fetch(url, headers=headers, cookies='kinokrad.moz')
	if response.code == 200:
		if rurl:
			return response.url , response.body
		elif rheaders:
			return response.headers, response.body
		else:
			return response.body
        else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def postUrl(url, param):
	from xbmcup.net import HTTP
	http = HTTP()
	if isinstance(url, unicode):
		url = url.encode('utf8')
	response = http.fetch(url, method='POST', params=param, headers=headers, cookies='kinokrad.moz')
	if response.code == 200:
			return response.url , response.body
        else:
		try:
			from xbmcup.errors import message
			message('Ошибка '+str(response.code)+' HTTP:', response.error)
			import xbmc
			xbmc.sleep(3000)
		except: pass
		raise Error(response.error)
		return response.code

def GetProxyList():
	import httplib
	conn = httplib.HTTPConnection("antizapret.prostovpn.org")
	conn.request("GET", "/proxy.pac", headers={"User-Agent": 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)'})
	r1 = conn.getresponse()
	data = r1.read()
	conn.close()
	proxylist = re.compile('PROXY (.+?); DIRECT').findall(data)
	#print proxylist
	return proxylist

def proxy_update():
	return GetProxyList()[0]
"""
if _get_domain_:
		try: pt=float(_setting['proxy_time'])
		except: pt=0
		if time.time()-pt > 36000:
			proxy1 = proxy_update()
			#proxy1=__setting['proxy_serv']
			#print proxy1
			try:
				_setting['proxy_time'] = str(time.time())
			except: pass
			data = getUrl('https://t.me/s/kinovodnet', proxy=proxy1)
			#file('/home/osmc/tme-kinovodnet.txt', 'wb').write(data)
			r = re.compile('"(http[s]?://kinovod[0-9]*?\.[a-z]*?)/"',re.S|re.U).findall(data)
			#print r
			redirect_url = r[-1]
			if site_url != redirect_url:
				try:
					_setting['site_domain'] = redirect_url.split('/')[2]
					_setting['use_https'] = 'true' if redirect_url.split(':')[0] == 'https' else 'false'
				except: pass
				site_url = redirect_url
				#print redirect_url, site_url
				#print _setting
"""
def r_u(url):
	if url.startswith(site_url): return url.replace(site_url,'')
	else: return url

def n_u(url):
	if ('://' in url) or (url is None) or (url[0] != '/'): return url
	else: return site_url + url

def pars(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	c = soup.find('ul', 'topmenu').findAll('a')
	category = []
	for i in c[:-1]:
		category.append( ( i.text, r_u(i['href']) ) )
	lm = soup.findAll('ul', 'leftmenu')
	m = lm[0].findAll('a')
	x = lm[0].findAll('div', 'menucatcount')
	menufilms = []
	for i in range(len(m)):
		text = m[i].text
		try:
			text = text.strip() + '     ' + x[i].text.strip()
		except: pass
		#print text
		menufilms.append( ( text, r_u(m[i]['href']) ) )
	g = lm[1].findAll('a')
	x = lm[1].findAll('div', 'menucatcount')
	genres = []
	for i in range(len(g)):
		text = g[i].text
		try:
			text = text.strip() + '     ' + x[i].text.strip()
		except: pass
		genres.append( ( text, r_u(g[i]['href']) ) )
	years = []
	country = [] #TODO
	return { 'category': category[2:], 'menufilms': menufilms, 'genres': genres, 'years': years, 'country': country }


def pars2(data, is_search=False, is_sort=False, rating_type=_rating_):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	i = soup.find('div', id='dle-content')
	v_temp_list = []
	podbor_list = []
	#i = v[0]
	#print i
	#for i in v:
	if i:
		x = i.findAll('div', 'shorbox')
		#n = x[0]
		#print n
		for n in x:
		#if n:
			info = {}
			p = n.find('div', 'postertitle')
			tr = p.find('h2').find('a')
			text = tr.text
			#if ' / ' in text:
			#	info['originaltitle'] = text.split(' / ')[1]
			#	text = text.split(' / ')[0]
			info['title'] = text
			url = r_u( tr['href'] )
			s = p.findNext('div', 'postershort')
			a = s.find('a')
			img = n_u( a.find('img')['src'] )
			cont_r = s.find('div', 'cont')
			if cont_r: info['writer'] = u'Всего: ' + cont_r.text
			#print info, url
			yq = s.findNext('div', 'shortboxh')
			if rating_type == 1:
				rr = n.find('li', 'current-rating')
				if rr:
					info['rating'] = float(rr.text)
			text = ''.join(yq.findAll(text=True))
			yqt = ''
			for j in text.splitlines():
				#print j
				if u'Страна:' in j: info['studio'] = j.split(':')[1].strip()
				if u'Жанр:' in j: info['genre'] = j.split(':')[1].strip()
				if u'Из цикла про:' in j: info['tagline'] = j.split(':')[1].strip()
				if u'Сценарий:' in j: info['writer'] = j.split(':')[1].strip()
				if u'Режиссер:' in j: info['director'] = j.split(':')[1].strip()
				if u'Длительность:' in j:
	    				dc = re.compile(u'([\d+]+)',re.S).search(j)
					if dc:
						#ts = dc.group(1).split(':')
						#info['duration'] = int(ts[0])*60*60+int(ts[1])*60+int(ts[2])
						info['duration'] = int(dc.group(1))*60
				#if u'Качество:' in j: info['plotoutline'] = j
				if u'Перевод:' in j: info['mpaa'] = j
				if u'Год:' in j:
					info['year'] = int(j.split(':')[1].strip())
					yqt += str(info['year'])
				if u'В ролях:' in j:
					info['cast'] = [a.strip() for a in j.split(':')[1].split(',') if a]
			qc = n.find('img', 'po')
			if qc:
				info['plotoutline'] = qc['src'].split('/')[-1].split('.')[0]
			sr = yq.find('div', 'shorttext')
			if sr:
				info['plot'] = sr.text.strip()
			v_temp_list.append( {'url': url, 'thumb': img, 'info': info, 'yq': yqt} )
		#print v_temp_list
		if is_search:
			y = i.findAll('div', 'searchitem')
			#j = y[0]
			for j in y:
			#if j:
				info = {}
				img = n_u( j.find('img')['src'] )
				tr = j.find('h3').find('a')
				info['title'] = tr.text
				url = r_u( tr['href'] )
				text = ''.join(j.findAll(text=True))
				lt = text.splitlines()
				yqt = ''
				for i in range(len(lt)):
					#print lt[i]
					if u'Качество:' in lt[i]: info['plotoutline'] = lt[i].split(':')[1].strip()
					if u'Дата:' in lt[i]: yqt = lt[i][lt[i].find(':')+1:].strip()
					if u'Жанр:' in lt[i]:
						iplot = i + 1
						info['genre'] = lt[i].split(':')[1].strip()
				info['plot'] = ''.join(lt[iplot:]).strip()

				v_temp_list.append( {'url': url, 'thumb': img, 'info': info, 'yq': yqt} )
		else:
			v = i.find('div', 'collections')
			if v:
				n = v.findAll('div', 'collect')
				if n:
					for i in n:
						img = n_u( i.find('img')['src'] )
						num = i.find('div', 'num').text
						urn = i.find('div', 'namec').find('a')
						info = {}
						info['title'] = urn.text + ' (' + num + ')'
						podbor_list.append( {'url': r_u(urn['href']), 'thumb': img, 'info':info} )

	else:
		j = soup.find('table', 'tabltop')
		if j:
			for i in j.findAll('tr')[1:]:
				#print i
				info = {}
				img_r = i.find('img')
				if img_r: img = n_u( img_r['src'] )
				name_r = img_r.findNext('a')
				if name_r:
					info['title'] = name_r.text
					url = r_u( name_r['href'] )
				num_r = name_r.findNext('td')
				if num_r: yqt = num_r.text
				v_temp_list.append( {'url': url, 'thumb': img, 'info': info, 'yq': yqt} )
	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	pg = soup.find('div', 'navigationbox')
	#print pg
	if pg:
		t = pg.findAll('a')
		cu = pg.findAll('span')
		#print cu
		try: page['max'] = int(t[-2]['href'].split('page/')[1].strip('/'))
		except: page['max'] = -1
		try: page['current'] = int(cu[-2].text)
		except: page['current'] = int(cu[-3].text)
		for i in t:
			if u'Вперед' in i.text: page['next'] = i['href']
			if u'Назад' in i.text: page['prev'] = i['href']
		#print page

	sort_list = []
	if is_sort and (page['current'] == 1):
		names = []
		n = soup.findAll('span', 'dropdown-u')
		if n:
			for i in n:
				names.append( i.text )
			v = soup.findAll('ul', 'dropdown-menu')
			for i, name in zip(v, names):
				#actives = []
				sort_name = name+u': '
				actives_name = []
				a = i.findAll('li', 'active')
				if a:
					for a1 in a:
						a2 = a1.find('a')
						if a2:
							#actives.append( (a2.text , a2['href']) )
							actives_name.append( a2.text)
					sort_param = u', '.join(actives_name)
				else:
					sort_param = u'Все'
					a = i.findAll('a', 'active')
					if a:
						for a2 in a:
							#actives.append( (a2.text , a2['href']) )
							actives_name.append( a2.text)
						sort_param = u', '.join(actives_name)
				sort_name = u''.join([u'[COLOR green]', sort_name, sort_param, u'[/COLOR]'])
				#print sort_name
				#print actives
				all_sort = []
				for j in i.findAll('a'):
					s_name = j.text
					if s_name in actives_name: s_name = u'[COLOR gold]' + s_name + u'[/COLOR]'
					all_sort.append( (s_name, j['href']) )
				#print all_sort
				sort_list.append( {'name': sort_name, 'sort': all_sort} ) # 'active': actives} )
	return {'data': v_temp_list, 'page': page, 'podbor': podbor_list, 'filter': sort_list}

def pars2top(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	i = soup.find('div', id='dle-content')
	v_temp_list = []
	podbor_list = []
	sort_list = []
	if i:
		v = i.find('div', 'basecont')
		if v:
			for j in v.findAll('a')[2:]:
				info = {}
				info['title'] = j.text
				podbor_list.append( {'url': r_u(j['href']), 'thumb': None, 'info':info} )
	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	return {'data': v_temp_list, 'page': page, 'podbor': podbor_list, 'filter': sort_list}

def pars2skoro(data):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	i = soup.find('div', 'topelse')
	v_temp_list = []
	podbor_list = []
	sort_list = []
	if i:
			for j in soup.findAll('div', 'shorbox2'):
				info = {}
				name_r = j.find('a')
				if name_r:
					info['title'] = name_r.text
				img = j.find('img')['src']
				info['plot'] = j.find('div', 'dateic').text
				v_temp_list.append( {'url': r_u(name_r['href']), 'thumb': img, 'info':info, 'yq': info['plot']} )
	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	return {'data': v_temp_list, 'page': page, 'podbor': podbor_list, 'filter': sort_list}

def pars3(data, rating_type=_rating_):
	from bs4 import BeautifulSoup
	soup = BeautifulSoup(data, 'html.parser')

	ur= soup.find('meta', property='og:url')
	url = ur['content']
	p = soup.find('div', id='dle-content')
	content_list = []
	podbor_list = []
	if p:
		info = {}
		r = p.find('h1')
		if r: info['title'] = r.text
		l = p.find('div', 'bigposter')
		t = l.find('img')
		if t: img = n_u( t['src'] )
		cont_r = l.find('div', 'cont')
		if cont_r: info['writer'] = u'Всего: ' + cont_r.text
		if rating_type == 1:
			r = p.find('div', 'rating-more')
			if r:
				rr = re.compile('([\d]+)[^\d]+([\d]+)',re.S).search( r.text )
				info['rating'] = float(rr.group(1))
				info['votes'] = rr.group(2)
		g = p.find('ul', 'janrfall')
		if g:
			text = ''.join(g.findAll(text=True))
		strana = False
		for j in text.splitlines():
			#print j
			if u'Оригинальное название:' in j: info['originaltitle'] = j.split(':')[1].strip()
			if strana:
				if j.strip() != u'':
					info['studio'] = j.strip()
					strana = False
			if u'Страна:' in j: strana = True
			if u'Жанр:' in j: info['genre'] = j.split(':')[1].strip()
			if u'Из цикла про:' in j: info['tagline'] = j.split(':')[1].strip()
			if u'Сценарий:' in j: info['writer'] = j.split(':')[1].strip()
			if u'Режиссёр:' in j: info['director'] = j.split(':')[1].strip()
			if u'Продолжительность:' in j:
	    				dc = re.compile(u'([\d+]+)',re.S).search(j)
					if dc:
						#ts = dc.group(1).split(':')
						#info['duration'] = int(ts[0])*60*60+int(ts[1])*60+int(ts[2])
						info['duration'] = int(dc.group(1))*60
			if u'Качество:' in j:
				ik = g.find('img', 'po')
				tk = ''
				if ik:
					 tk = u' ' + ik['src'].split('/')[-1].split('.')[0]
				info['plotoutline'] = j + tk
			if u'Перевод:' in j: info['mpaa'] = j
			if u'Год:' in j: info['year'] = int(j.split(':')[1].strip())
			#if u'Актеры:' in j:
			#	info['cast'] = [i.strip() for i in j.split(':')[1].split(',') if i]

		vd = p.find('div', 'btnvideobox')
		if vd:
			tb1 = vd.find('div', id='tab-1')
			if tb1:
				vnd = tb1.find('div', 'vnd')
				if vnd:
					vpr = tb1.find('div', 'novid')
					if vpr:
						podbor_list.append( {'url': 0, 'thumb': None, 'info': {'title': u'[COLOR yellow]' + vpr.text + u'[/COLOR]'} } )
					else:
						podbor_list.append( {'url': 0, 'thumb': None, 'info': {'title': u'[COLOR red]Видео недоступно для вашего региона!!![/COLOR]'} } )

		o = p.find('div','fulltext')
		if o:
			info['plot'] = o.text.replace('\t', ' ').strip('\n')
			sezr = o.findAll('a')
			if sezr:
				numb = 1
				podbor_list.append( {'url': 0, 'thumb': None, 'info': {'title': u'[COLOR green]Порядок просмотра:[/COLOR]'} } )
				for s in sezr:
					podbor_list.append( {'url': s['href'], 'thumb': None, 'info': {'title': unicode(numb) + u'. ' + s.text} } )
					numb += 1

		c = p.find('div','postactors')
		tempcastfull = None
		if c:
			tempcast = []
			tempcastfull = []
			for i in c.findAll('div','fullactbox'):
				ia = i.find('img')
				if ia: img_act = n_u( ia['src'] )
				ina = i.find('div','acttitle')
				if ina: name_act = ina.text
				#print img_act, name_act
				tempcast.append(name_act)
				tempcastfull.append({'name':name_act, 'thumbnail': img_act})
			info['cast'] = tempcast
		r = re.compile(r'<iframe width="620" height="433" src="https://www.youtube.com/embed/([^"]+?)" frameborder="0" allowfullscreen=""></iframe>',re.S).search(data)
		if r: info['trailer'] = 'plugin://plugin.video.youtube/play/?video_id=' + r.group(1)

		sc_r = p.find('div', 'scrinover')
		screenshot = None
		if sc_r:
			screenshot = []
			for i in sc_r.findAll('a'):
				if '.jpg' in i['href']:	screenshot.append( n_u(i['href']) )

		content_list.append( {'url': r_u(url), 'thumb': img, 'info': info, 'cast': tempcastfull, 'screenshot': screenshot} )

	page = {'max': 1, 'current': 1, 'next': None, 'prev': None}
	return {'data': content_list, 'page': page, 'podbor2': podbor_list}


def vtt_to_srt(fileContents):
	replacement = re.sub(r'(\d\d:\d\d:\d\d).(\d\d\d) --> (\d\d:\d\d:\d\d).(\d\d\d)(?:[ \-\w]+:[\w\%\d:]+)*\n', r'\1,\2 --> \3,\4\n', fileContents)
	replacement = re.sub(r'(\d\d:\d\d).(\d\d\d) --> (\d\d:\d\d).(\d\d\d)(?:[ \-\w]+:[\w\%\d:]+)*\n', r'00:\1,\2 --> 00:\3,\4\n', replacement)
	replacement = re.sub(r'(\d\d).(\d\d\d) --> (\d\d).(\d\d\d)(?:[ \-\w]+:[\w\%\d:]+)*\n', r'00:00:\1,\2 --> 00:00:\3,\4\n', replacement)
	replacement = re.sub(r'WEBVTT\n', '', replacement)
	replacement = re.sub(r'Kind:[ \-\w]+\n', '', replacement)
	replacement = re.sub(r'Language:[ \-\w]+\n', '', replacement)
	#replacement = re.sub(r'^\d+\n', '', replacement)
	#replacement = re.sub(r'\n\d+\n', '\n', replacement)
	replacement = re.sub(r'<c[.\w\d]*>', '', replacement)
	replacement = re.sub(r'</c>', '', replacement)
	replacement = re.sub(r'<\d\d:\d\d:\d\d.\d\d\d>', '', replacement)
	replacement = re.sub(r'::[\-\w]+\([\-.\w\d]+\)[ ]*{[.,:;\(\) \-\w\d]+\n }\n', '', replacement)
	replacement = re.sub(r'Style:\n##\n', '', replacement)
	id = 1
	out = ''
	for i in replacement.splitlines():
		if i == '':
			if id == 1:
				out = out + str(id) + '\n'
			else:
				out = out + '\n' + str(id) + '\n'
			id += 1
		else:
			out = out + i + '\n'
	return out

def qurl(url, quality=_quality_):
			urls = url.split(',[')
			listurls = {}
			gl = []
			for i in urls:
				d = i.replace('[','').split(']')
				if u'4K' in d[0]: d[0] = '4000'
				elif u'p' in d[0]: d[0] = d[0].strip('p')
				listurls[str(d[0])] = d[1]
				gl.append( (int(d[0]), d[1]) )
			#print listurls
			gl.sort()
			#print gl
			qprev = 0
			for i in gl:
				if int(i[0]) > int(quality):
					q = qprev
					break
				qprev = i[0]
				q = i[0]
			url = listurls[str(q)]
			return url

def turl(url):
	turls = url.split(';{')
	list_trans = []
	index = 0
	for i in turls:
		url = i.split('}')[1]
		name = i.split('}')[0].strip('{')
		list_trans.append( (name.decode('utf8'), url, None, index) )
		index += 1
	return list_trans

def surl(url):
	surls = url.split(',[')
	list_subt = []
	for i in surls:
		url = i.split(']')[1]
		list_subt.append( url )
	return list_subt

def pars_seria(data):
	lurls = eval(data)
	print lurls
	list_seria = []
	index = 0
        i = lurls
	if i:
	#for i in lurls:
		sezon_name = i.get('comment', '')
		if 'playlist' in i:
			for j in i['playlist']:
				seria_num = j['comment']
				url = j['file']
				if url.startswith('['):
					url = qurl(url)
				subt = j.get('subtitle')
				if subt:
					suburl = surl(subt)
				else: suburl = None
				if sezon_name:
					name = sezon_name + ' / ' + seria_num
				else:
					name = seria_num
				list_seria.append( (name.decode('unicode-escape'), url, suburl, index) )
				index += 1
		else:
			url = i['file']
			if url.startswith('['):
				url = qurl(url)
			subt = i.get('subtitle')
			if subt:
				suburl = surl(subt)
			else: suburl = None
			list_seria.append( (sezon_name.decode('unicode-escape'), url, suburl, index) )
			index += 1
	return list_seria

def pars_m3u8(data, quality=_quality_):
	listurl = {}
	d = data.splitlines()
	#print d
	for i in d:
		if (i !='') and (i[0] == '#') and ('RESOLUTION=' in i):
			if ('x360' in i) or ('640x' in i): qu = '360'
			elif ('x480' in i) or ('854x' in i): qu = '480'
			elif ('x720' in i) or ('1280x' in i): qu = '720'
			elif ('x1080' in i) or ('1920x' in i): qu = '1080'
			else:
				res = i.split('RESOLUTION=')[1].split(',')[0].split('x')
				#print res
				if int(res[0]) < 1000 and int(res[1]) < 480 : qu = '360'
				elif int(res[0]) > 1000 and int(res[1]) > 480 and int(res[1]) < 720 : qu = '720'
				else: qu = '1080'
		if (i != '') and (i[0] != '#'):
			#print i
			listurl[qu] = i
			#if i.startswith('http'): listurl[qu] = i
			#else: listurl[qu] = url[:url.rfind('/')+1] + i
	#print listurl
	gl = []
	for i in listurl:
			gl.append((int(i), listurl[i]))
	gl.sort()
	qprev = 0
	for i in gl:
			if int(i[0]) > int(quality):
					q = qprev
					break
			qprev = i[0]
			q = i[0]
	return listurl[str(q)]

def pars_play(data, quality=_quality_):
	r = re.compile('var filmSource = "([^"]*)" \|\| "([^"]*)"',re.S).search(data)
#	                  var filmSource = "" || "/playlist/340742.txt";
	if not r:
		t = re.compile(r'<iframe width="620" height="433" src="https://www.youtube.com/embed/([^"]+?)" frameborder="0" allowfullscreen=""></iframe>',re.S).search(data)
		if t:
			y_id = t.group(1)
			return 'plugin://plugin.video.youtube/play/?video_id=' + y_id, None
		else: return '', None
	if r:
		url = r.group(1) if r.group(1) else r.group(2)
		subtitles = None
		print url
		if url.endswith('.m3u8'):
			url = url.replace('kinokrad.co/','kinoplayer.co/')
			#data = getUrl(url)
			#file('/home/osmc/kinokrad-data.txt', 'wb').write(data)
			#print data
			#url = pars_m3u8(data)
		elif url.endswith('.txt'):
			data2 = getUrl(n_u(url))
			url = pars_seria(data2.replace('\/','/').replace('kinokrad.co/','kinoplayer.co/'))
	return [ url, subtitles ]

def catalog(url=site_url):
	if not url: url = site_url
	data = getUrl(n_u(url))
	if url == '/luchshie-filmy-onlayn-top-100.html': return pars2top(data)
	if url == '/kino-premery/': return pars2skoro(data)
	#file('/home/osmc/catalog.txt', 'wb').write( data )
	return pars2(data)

def startpage():
	data = getUrl(site_url)
	d = pars(data)
	d.update(pars2(data))
	return d

def genre():
	data = getUrl(site_url)
	return pars(data)


def videoinfo(url):
	data = getUrl(n_u(url))
	#file('/home/osmc/kinokrad.txt', 'wb').write( data )
	res = pars3(data)
	res['url'] = pars_play(data)[0]
	return res

def search(text):
	if isinstance(text, unicode): text = text.encode('utf8')
	from urllib import urlencode
	url, data = postUrl(site_url,{'do': 'search', 'subaction':'search', 'story': text, 'dosearch': r'Начать поиск' } )
	#file('/home/osmc/search.txt', 'wb').write( data )
	if site_url == url:
		return False, pars2(data, True)
	else:
		return True, pars3(data)


def subt_convert(subtlist, subtitleson=_subtitles_):
	if subtitleson and subtlist:
		subt_list = []
		for i in subtlist:
				if '.vtt' in i:
					name = i.split('/')[-1].replace('.vtt','.srt')
					isu = i
					if ' or ' in i: isu = i.split(' or ')[randindex]
					data_vtt = getUrl(isu)
					data_srt = vtt_to_srt(data_vtt)
					if _kodi_:
						from xbmcup.app import Handler
						sdir = Handler().path('srt')
						if not os.path.isdir(sdir): os.mkdir(sdir)
						f_name = Handler().path('srt', name)
					else:
						f_name = name
					file(f_name, 'wb').write(data_srt)
					subt_list.append( f_name )
				else:
					subt_list.append( i )
		return subt_list
	else:
		return None

def play_link(url, index=None):
	try:
		from xbmcup.errors import log
		log(url,'url=')
	except: pass
	#data = file('/home/osmc/kinokrad.txt', 'rb').read()
	data = getUrl(n_u(url))
	#file('/home/osmc/z2-kinokrad.net.txt', 'wb').write(data)
	d_play = pars_play(data)
	try:
		from xbmcup.errors import log
		log(d_play,'d_play=')
	except: pass
	from urllib import urlencode
	opt = '|'+urlencode({'User-Agent': headers['User-Agent']})
	if index or index == 0:
		if d_play[1]:
			return [ d_play[0][index][1]+opt, subt_convert( d_play[1] ) ], None
		return [ d_play[0][index][1]+opt, subt_convert( d_play[0][index][2] ) ], None
	else:
		if d_play[1]:
			return [d_play[0]+opt, subt_convert(d_play[1]) ], None
		if d_play[0].startswith('plugin:') or d_play[0] == '':
			return [ d_play[0], d_play[1] ], None
		return [ d_play[0]+opt, d_play[1] ], None


def play_link2(url, index=None):
	d = play_link2(url, index)
	if ' or ' in d[0][0]:
		return ( d[0][0].split(' or ')[randindex], d[0][1] ), d[1]
	return d

if __name__ == '__main__':
	#catalog()
	data = file('/home/osmc/skorocatalog.txt', 'rb').read()
	#print  pars2skoro(data)

	data = file('/home/osmc/kinokrad.txt', 'rb').read()
	print  pars3(data)
	#print pars_play(data)
	#print play_link('fff')

	#print search('озеро')
	#data = file('/home/osmc/search.txt', 'rb').read()
	#print pars2(data, True)
	pass

