# -*- coding: utf-8 -*-

import os, sys

import xbmc, xbmcplugin, xbmcgui

from xbmcup.app import Link, Handler, Plugin, _setting
import kinokrad
from history import History, HistoryAdd

_view_ = _setting['view']

plugin = Plugin()

@plugin.radd()
class Menu(Handler):
	def handle(self):
		d = kinokrad.startpage()
		self.item(Link('catalog',{'search': True}), title='[Поиск]')
		self.item(Link('history'), title='[История поиска]')
		self.item(Link('genre',{'data': d['category']}), title='Раздел')
		self.item(Link('genre',{'data': d['years']}), title='Год')
		self.item(Link('genre',{'data': d['genres']}), title='Жанр')
		#self.item(Link('genre',{'data': d['country']}), title='Страна')
		#
		#for i in range(len(d['gpt'])):
		#	title = u'[COLOR green]' + d['gpt'][i][0] + u':[/COLOR]'
		#	self.item(Link('catalog', {'url': d['gpt'][i][1]}), title=title)
		#	for j in d['data'][i]:
		#		popup =  []
		#		popup.extend(self.popup)
		#		title = j['info']['title']
		#		popup.insert(1, (Link('catalog', {'search': True, 'textsearch': title}, True), 'Поиск') )
		#		if j['info'].get('plotoutline'):
		#			title = title + u' (' + j['yq'] + u', ' + j['info']['plotoutline'] + u')'
		#		else:
		#			title = title + u' (' + j['yq'] + u')'
		#		self.item(Link('video', {'url': j['url']}), title=title, media='video', info=j['info'], thumb=j['thumb'], popup=popup, popup_replace=True)
		Catalog(argv={'data':d}).handle()
		#self.render(nextmode=_view_)

@plugin.radd()
class Catalog(Handler):
	def handle(self):
		search = self.argv.get('search')
		url = self.argv.get('url')
		s_kbd = self.argv.get('s_kbd', False)
		sort = self.argv.get('sort')
		data = self.argv.get('data', None)
		if sort:
			index = xbmcgui.Dialog().select(self.nameaddon, [x[0] for x in sort])
			if index < 0:
				return True
			else:
				url = sort[index][1]
		if search:
			if isinstance(search, bool):
				textsearch = self.argv.get('textsearch', '')
				search = self.kbdinput('Поиск', textsearch)
				if search is None: return True
				s_kbd = True
				HistoryAdd(search)
			s1, data = kinokrad.search(search)
		elif url == 0:
			return True
		elif data is None:
			data = kinokrad.catalog(url)
		if (data['data']==[]) and s_kbd and (data['podbor'] ==[]):
			xbmcgui.Dialog().ok(self.nameaddon, 'Ничего не найдено')
		if data.get('filter'):
			for i in data['filter']:
				self.item(Link('catalog', {'sort': i['sort']}), title=i['name'], media='video', popup=self.popup, popup_replace=True)
		for i in data['data']:
			popup = []
			popup.extend(self.popup)
			title = i['info']['title']
			popup.insert(1, (Link('catalog', {'search': True, 'textsearch': title}, True), 'Поиск') )
			if i['info'].get('plotoutline'):
				title = title + u' (' + i['yq'] + u', ' + i['info']['plotoutline'] + u')'
			else:
				title = title + u' (' + i['yq'] + u')'
			if i['info'].get('rating'):
				title = title + u' [' + unicode(i['info']['rating']) + u']'
			self.item(Link('video', {'url': i['url']}), title=title, media='video', info=i['info'], thumb=i['thumb'], popup=popup, popup_replace=True)
		for i in data['podbor']:
			self.item(Link('catalog', {'url': i['url']}), title=i['info']['title'], media='video', info=i['info'], thumb=i['thumb'], popup=self.popup, popup_replace=True)
		if data['page']['next']:
			titlepage = 'Следующая страница '+ str(data['page']['current']+1)+ ' из ' + str(data['page']['max']) + ' >>'
			self.item(Link('catalog',{'url':data['page']['next']}), title=titlepage)
		self.render(nextmode=_view_)

@plugin.radd()
class Genre(Handler):
	def handle(self):
		data = self.argv.get('data')
		for i in data:
			self.item(Link('catalog',{'url': i[1]}), title=i[0])
		self.render(nextmode=_view_)

@plugin.radd()
class Video(Handler):
	def handle(self):
		url = self.argv.get('url')
		if url == 0:
			return True
		d = kinokrad.videoinfo(url)
		data = d['data'][0]
		title = data['info']['title']
		info = data['info']
		if data.get('screenshot'): self.popupadd(Link('screenshot', data['screenshot']), 'Скриншоты' + ' (' + str(len(data['screenshot'])) + ')')
		self.popupadd(Link('catalog', {'search': True, 'textsearch': title}, True), 'Поиск')
		if isinstance(d['url'], basestring):
			self.item(Link('play',{'url': data['url']}), title=title, media='video', info=info, thumb=data['thumb'], popup=True, popup_replace=True, property=[('IsPlayable','true')], cast=data['cast'], folder=False)
		else:
			self.item(Link('video', {'url': data['url'] }), title=title, media='video', info=data['info'], thumb=data['thumb'], popup=True, popup_replace=True, cast=data['cast'])
			for name, durl, surl, index in d['url']:
				info['title'] = title + u' / ' + name
				self.item(Link('play',{'url': data['url'], 'index': index }), title=name, media='video', info=info, thumb=data['thumb'], popup=True, popup_replace=True, property=[('IsPlayable','true')], cast=data['cast'], folder=False)
		for i in d['podbor2']:
			self.item(Link('video', {'url': i['url']}), title=i['info']['title'], media='video', info=i['info'], thumb=i['thumb'], popup=self.popup, popup_replace=True)
		self.render(nextmode=_view_)

@plugin.radd()
class Play(Handler):
	def handle(self):
		url = self.argv.get('url')
		durl = self.argv.get('durl')
		index = self.argv.get('index')
		if url:
			link, error = kinokrad.play_link(url, index)
		elif durl: link = [durl, None]
		if link and link[0] == '': error = ['Нет ссылки на видео.']
		if link and link[0]:
			#xbmc.Player().play(link)
			#from urllib import urlencode
			#link = link + '|' + urlencode( {'Referer': link} )
			item = xbmcgui.ListItem(path=link[0])
			if link[1]:
				item.setSubtitles(link[1])
			xbmcplugin.setResolvedUrl(int(sys.argv[1]),True, item)
		else:
			xbmcgui.Dialog().ok(self.nameaddon, *error)

@plugin.radd()
class ScreenShot(Handler):
	def handle(self):
		from xbmcup import slideshow
		slideshow.open(self.argv, 0)
		return True


def main():
	plugin.route('history', History)
	plugin.run()


if __name__ == '__main__':
	try:
                search_vars = sys.argv[2].split('?')
                search_vars = search_vars[-1].split('&')
                if 'usearch=True' in search_vars:
                        from urlparse import parse_qs
                        params = parse_qs(sys.argv[2].replace('?', ''))
                        united_search = {'route': 'catalog', 'argv': { 'search': params['keyword'][0] } }
			from urllib import quote_plus
                        import json
                        sys.argv[2] = '?'+quote_plus(json.dumps(united_search))
	except BaseException as e:
		from xbmcup.errors import log
		log(e)

	main()
